/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.EntityComboBoxModel;
import com.ahsrcm.client.scanning.gui.IndexOptionEnum;
import com.ahsrcm.client.scanning.gui.IntegerField;
import com.ahsrcm.client.scanning.gui.ScanCustomField;
import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.BatchType;
import com.ahsrcm.corp.BusinessEntity;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Doctor;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.ScanBatchExtraData;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.UserContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.model3.chrono.DateOnly;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.lang.AbstractComparable;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.swing.GuiHelper;
import net.model3x.swing.M3Panel;
import net.model3x.swing.datechooser.TextFieldDateOnlyChooser;

public class ScanHeaderPanel {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 1L;
    EntityComboBoxModel<Company> _companyModel = EntityComboBoxModel.create();
    EntityComboBoxModel<Division> _divisionModel = EntityComboBoxModel.create();
    EntityComboBoxModel<Location> _locationModel = EntityComboBoxModel.create();
    EntityComboBoxModel<Doctor> _doctorModel = EntityComboBoxModel.create();
    EntityComboBoxModel<BatchType> _batchTypeModel = EntityComboBoxModel.create();
    EntityComboBoxModel<User> _nextUserModel = EntityComboBoxModel.create();
    User _user;
    M3Panel _mainPanel;
    JTextArea _commentTF;
    JComboBox _companyCB;
    JComboBox _divisionCB;
    JButton _createButton;
    TextFieldDateOnlyChooser _dateOfServiceDC;
    JLabel _disabledMessage;
    JComboBox _doctorCB;
    JLabel _dosMsg;
    JComboBox _locationOfServiceCB;
    JLabel _locationOfServiceMsg;
    IntegerField _numberOfPages;
    JLabel _numberOfPagesMsg;
    IntegerField _numberOfPatientFiles;
    JLabel _numberOfPatientFilesMsg;
    JComboBox _batchType;
    JLabel _batchTypeMsg;
    JComboBox _indexingCB;
    List<ScanCustomField> _customFields;
    private Listener _listener = new Listener(){

        @Override
        public void scanBatchCreated(ScanBatch scanBatch, IndexOptionEnum indexOptionEnum) {
        }
    };

    public static void main(String[] stringArray) throws Exception {
        new SimpleLoggingConfigurator().addEclipseConsoleAppender();
        UIManager.setLookAndFeel(new MetalLookAndFeel());
        ScanHeaderPanel scanHeaderPanel = new ScanHeaderPanel(false);
        scanHeaderPanel._user = new User();
        scanHeaderPanel.init();
        GuiHelper.createFrame((JComponent)scanHeaderPanel._mainPanel);
    }

    public ScanHeaderPanel(boolean bl) {
        if (bl) {
            this.init();
        }
    }

    private void init() {
        this.initComponents();
        this.initPartTwo();
        this.setEnabled(true);
    }

    public User getUser() {
        if (this._user == null) {
            this._user = ((UserContext)UserContext.Impl.get()).getUser();
        }
        return this._user;
    }

    private void initPartTwo() {
        this._doctorModel.setNullable(true);
        this._companyCB.setModel(this._companyModel);
        this._divisionCB.setModel(this._divisionModel);
        this._locationOfServiceCB.setModel(this._locationModel);
        this._doctorCB.setModel(this._doctorModel);
        this._nextUserModel.setItems(new ArrayList());
        this._nextUserModel.setNullable(false);
        this._nextUserModel.setDefault(null);
        for (BusinessEntity businessEntity : this.getUser().getBusinessEntities()) {
            logger.debug((Object)"biz entities {}={}", businessEntity.entityId.get(), businessEntity.value.get());
        }
        this._companyModel.setItems(this.getUser().allowedCompanies.get());
        this._companyCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SwingWorker<Void, Void>(){
                    List<Division> divisions = Collections.emptyList();

                    @Override
                    protected Void doInBackground() throws Exception {
                        try {
                            if (ScanHeaderPanel.this._companyModel.getSelectedEntity() != null) {
                                this.divisions = ScanHeaderPanel.this.getUser().getAuthorizedDivisions(ScanHeaderPanel.this._companyModel.getSelectedEntity());
                            }
                        }
                        catch (Exception exception) {
                            logger.warn((Object)exception);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        ScanHeaderPanel.this._divisionModel.setItems(this.divisions);
                        ScanHeaderPanel.this._divisionModel.reset();
                    }
                }.execute();
            }
        });
        this._divisionCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SwingWorker<Void, Void>(){
                    List<Location> losList = ListX.create();
                    List<Doctor> doctors = ListX.create();

                    @Override
                    protected Void doInBackground() throws Exception {
                        try {
                            Division division = ScanHeaderPanel.this._divisionModel.getSelectedEntity();
                            if (division != null) {
                                for (Location location : ScanHeaderPanel.this.getUser().getAuthorizedLocations(division)) {
                                    if (!location.isActive()) continue;
                                    this.losList.add(location);
                                }
                                this.doctors = division.getActiveDoctors();
                            }
                        }
                        catch (Exception exception) {
                            logger.warn((Object)exception);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        ScanHeaderPanel.this._locationModel.setItems(this.losList);
                        ScanHeaderPanel.this._locationModel.reset();
                        ScanHeaderPanel.this._doctorModel.setItems(this.doctors);
                        ScanHeaderPanel.this._doctorModel.reset();
                    }
                }.execute();
            }
        });
        if (this._companyModel.getSize() > 0) {
            this._companyCB.setSelectedIndex(0);
        }
        this._batchType.setModel(this._batchTypeModel);
        this._batchTypeModel.setItems(this.getUser().batchTypes.get());
        this._dosMsg.setVisible(false);
        this._numberOfPagesMsg.setVisible(false);
        this._createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanHeaderPanel.this.processCreateButtonAction();
            }
        });
        this._createButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ScanHeaderPanel.this.processCreateButtonAction();
                }
            }
        });
        this._indexingCB.setModel(new DefaultComboBoxModel<String>(IndexOptionEnum.getIdKeySet()));
        this._indexingCB.setSelectedIndex(1);
        this.resetForm();
    }

    private void processCreateButtonAction() {
        if (!this.validateForm()) {
            return;
        }
        ScanBatch scanBatch = this.createScanBatch();
        String string = (String)this._indexingCB.getSelectedItem();
        IndexOptionEnum indexOptionEnum = IndexOptionEnum.enumFromSelectorString(string);
        this._listener.scanBatchCreated(scanBatch, indexOptionEnum);
    }

    void resetErrorMessages() {
        JLabel[] jLabelArray;
        for (JLabel jLabel : jLabelArray = new JLabel[]{this._dosMsg, this._locationOfServiceMsg, this._numberOfPagesMsg, this._batchTypeMsg}) {
            jLabel.setText("");
            jLabel.setVisible(false);
            jLabel.setForeground(Color.RED);
        }
    }

    void initComponents() {
        this._mainPanel = new M3Panel("ins 10", "[][fill]");
        this._commentTF = new JTextArea();
        this._companyCB = new JComboBox<Company>(this._companyModel);
        this._divisionCB = new JComboBox<Division>(this._divisionModel);
        this._createButton = new JButton("Create");
        this._dateOfServiceDC = new TextFieldDateOnlyChooser();
        this._disabledMessage = new JLabel();
        this._doctorCB = new JComboBox<Doctor>(this._doctorModel);
        this._dosMsg = new JLabel();
        this._locationOfServiceCB = new JComboBox<Location>(this._locationModel);
        this._locationOfServiceMsg = new JLabel();
        this._numberOfPages = new IntegerField();
        this._numberOfPagesMsg = new JLabel();
        this._numberOfPatientFiles = new IntegerField();
        this._numberOfPatientFilesMsg = new JLabel();
        this._batchType = new JComboBox<BatchType>(this._batchTypeModel);
        this._batchTypeMsg = new JLabel();
        this._disabledMessage = new JLabel();
        this._indexingCB = new JComboBox();
        this._customFields = ListX.create((Object[])new ScanCustomField[]{new ScanCustomField.LongScanCustomField("depositNumber", "Deposit #", 12).asScanCustomField()});
        this._mainPanel.setBackground(Color.white);
        this._disabledMessage.setText("<html>Can only create one batch at a time. Finish the current batch before starting a new one.</html>");
        this._dosMsg.setForeground(Color.red);
        this._numberOfPagesMsg.setForeground(Color.red);
        this._numberOfPatientFilesMsg.setForeground(Color.red);
        this._commentTF.setColumns(132);
        this._commentTF.setRows(5);
        this._commentTF.setBorder(new LineBorder(Color.gray));
        this._mainPanel.add((Component)this._disabledMessage, (Object)"wrap, spanx");
        this._mainPanel.add((Component)new JLabel("Company"), (Object)"right");
        this._mainPanel.add((Component)this._companyCB, (Object)"wrap, growx");
        this._mainPanel.add((Component)new JLabel("Division"), (Object)"right");
        this._mainPanel.add((Component)this._divisionCB, (Object)"wrap, growx");
        this._mainPanel.add((Component)new JLabel("Location"), (Object)"right");
        this._mainPanel.add((Component)this._locationOfServiceCB, (Object)"wrap, growx");
        this._mainPanel.add((Component)this._locationOfServiceMsg, (Object)"wrap, spanx");
        this._mainPanel.add((Component)new JLabel("Date of Service"), (Object)"right");
        this._mainPanel.add((Component)this._dateOfServiceDC, (Object)"wrap");
        this._mainPanel.add((Component)this._dosMsg, (Object)"wrap, spanx");
        this._mainPanel.add((Component)new JLabel("Doctor"), (Object)"right");
        this._mainPanel.add((Component)this._doctorCB, (Object)"wrap");
        this._mainPanel.add((Component)new JLabel("Number of Pages"), (Object)"right");
        this._mainPanel.add((Component)((Object)this._numberOfPages), (Object)"wrap");
        this._mainPanel.add((Component)this._numberOfPagesMsg, (Object)"wrap, spanx");
        this._mainPanel.add((Component)new JLabel("Indexing"), (Object)"right");
        this._mainPanel.add((Component)this._indexingCB, (Object)"wrap");
        this._mainPanel.add((Component)new JLabel("Number of Patient Files"), (Object)"right");
        this._mainPanel.add((Component)((Object)this._numberOfPatientFiles), (Object)"wrap");
        this._mainPanel.add((Component)this._numberOfPatientFilesMsg, (Object)"wrap, spanx");
        this._mainPanel.add((Component)new JLabel("Batch Type"), (Object)"right");
        this._mainPanel.add((Component)this._batchType, (Object)"wrap");
        this._mainPanel.add((Component)this._batchTypeMsg, (Object)"wrap, spanx");
        for (ScanCustomField scanCustomField : this._customFields) {
            scanCustomField.addToPanel(this._mainPanel);
        }
        this._mainPanel.add((Component)new JLabel("Notes"), (Object)"right");
        this._mainPanel.add((Component)this._commentTF, (Object)"wrap");
        this._mainPanel.add((Component)this._createButton, (Object)"center, spanx");
    }

    public void setEnabled(boolean bl) {
        this._mainPanel.setEnabled(bl);
        this._companyCB.setEnabled(bl);
        this._divisionCB.setEnabled(bl);
        this._locationOfServiceCB.setEnabled(bl);
        this._dateOfServiceDC.setEnabled(bl);
        this._doctorCB.setEnabled(bl);
        this._numberOfPages.setEnabled(bl);
        this._numberOfPatientFiles.setEnabled(bl);
        for (ScanCustomField scanCustomField : this._customFields) {
            scanCustomField.setEnabled(bl);
        }
        this._disabledMessage.setVisible(!bl);
        this._createButton.setVisible(bl);
        this._commentTF.setEnabled(bl);
        this._createButton.setEnabled(bl);
        GuiHelper.doLayoutHack((Component)this._mainPanel);
    }

    public boolean validateForm() {
        this.resetErrorMessages();
        boolean bl = true;
        DateOnly dateOnly = this._dateOfServiceDC.getValue();
        if (dateOnly == null) {
            this._dosMsg.setText("Date of service must be entered");
            this._dosMsg.setVisible(true);
            bl = false;
        } else if (dateOnly.greaterThan((AbstractComparable)new DateOnly())) {
            this._dosMsg.setText("Date of service cannot be in the future");
            this._dosMsg.setVisible(true);
            bl = false;
        }
        if (this._batchTypeModel.getSelectedEntity() == null) {
            this._batchTypeMsg.setText("Batch type must be entered");
            this._batchTypeMsg.setVisible(true);
            bl = false;
        }
        if (this._locationModel.getSelectedEntity() == null) {
            this._locationOfServiceMsg.setText("Company/Division/Location of Service must be entered");
            this._locationOfServiceMsg.setVisible(true);
            bl = false;
        }
        if (this._numberOfPages.getValue() < 0) {
            this._numberOfPagesMsg.setText("Must enter a valid number for the expected number of pages");
            this._numberOfPagesMsg.setVisible(true);
            bl = false;
        }
        if (this._numberOfPatientFiles.getValue() <= 0) {
            this._numberOfPatientFilesMsg.setText("Must enter a valid number for the expected number of patient files");
            this._numberOfPatientFilesMsg.setVisible(true);
            bl = false;
        }
        return bl;
    }

    private ScanBatch createScanBatch() {
        ScanBatch scanBatch = new ScanBatch();
        scanBatch.location.set((Object)this._locationModel.getSelectedEntity());
        scanBatch.dateOfService.set((Object)new Date(this._dateOfServiceDC.getValue().inMillis()));
        scanBatch.doctor.set((Object)this._doctorModel.getSelectedEntity());
        scanBatch.batchType.set((Object)this._batchTypeModel.getSelectedEntity());
        scanBatch.expectedImageCount.set((Object)this._numberOfPages.getValue());
        scanBatch.expectedVisitCount.set((Object)this._numberOfPatientFiles.getValue());
        scanBatch.comment.set((Object)this._commentTF.getText());
        scanBatch.id.set((Object)((ScanningDao)ScanningDao.Impl.get()).nextControlNumber(ScanBatch.class));
        scanBatch.stage.set((Object)((Stage)Stage.ScanningInProgress.get()));
        ((ScanningDao)ScanningDao.Impl.get()).insert((BaseBusinessBean)scanBatch);
        Map map = MapX.create();
        for (ScanCustomField scanCustomField : this._customFields) {
            if (scanCustomField.getValue() == null) continue;
            map.put(scanCustomField.getName(), scanCustomField.getValue());
        }
        ScanBatchExtraData scanBatchExtraData = new ScanBatchExtraData(scanBatch, map);
        ((ScanningDao)ScanningDao.Impl.get()).insert((BaseBusinessBean)scanBatchExtraData);
        this.resetForm();
        return scanBatch;
    }

    public void resetForm() {
        this.resetErrorMessages();
        this._companyModel.reset();
        this._divisionModel.reset();
        this._locationModel.reset();
        this._dateOfServiceDC.setValue(null);
        this._doctorModel.reset();
        this._numberOfPages.setValue(0);
        this._batchTypeModel.setSelectedItem(null);
        this._nextUserModel.reset();
        this._commentTF.setText("");
        this._numberOfPatientFiles.setValue(0);
        this._numberOfPatientFilesMsg.setText("");
        for (ScanCustomField scanCustomField : this._customFields) {
            scanCustomField.clear();
        }
    }

    public void setListener(Listener listener) {
        this._listener = listener;
    }

    public Component getMainPanel() {
        return this._mainPanel;
    }

    public static interface Listener {
        public void scanBatchCreated(ScanBatch var1, IndexOptionEnum var2);
    }
}

