/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.ImageViewer;
import com.ahsrcm.client.scanning.gui.ScanDetailPanel;
import com.ahsrcm.client.scanning.gui.Thumbnail;
import com.ahsrcm.client.scanning.gui.ThumbnailStrip;
import com.ahsrcm.core.scanning.gui.ImageProxy;
import com.ahsrcm.core.scanning.gui.ImageProxyPopupFactory;
import com.ahsrcm.core.scanning.gui.ScannedImageProxy;
import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.DocumentType;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.dao.DaoBackgroundExecutor;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.PrintingService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import net.model3.collections.ListX;
import net.model3.lang.Visitor;

public class ScanDetailPopupFactory
implements ImageProxyPopupFactory {
    private ScanBatch _scanBatch;
    private boolean _applyMenuSelectionsToThumbnailStrip = false;
    private ThumbnailStrip<ScannedImage> _thumbnailStrip;
    private ScanDetailPanel _scanDetailPanel;

    private ScanDetailPopupFactory(ScanBatch scanBatch, ThumbnailStrip<ScannedImage> thumbnailStrip) {
        this._scanBatch = scanBatch;
        this._thumbnailStrip = null;
        this._scanDetailPanel = null;
        this._applyMenuSelectionsToThumbnailStrip = false;
        this._thumbnailStrip = thumbnailStrip;
    }

    private ScanDetailPopupFactory(ScanDetailPanel scanDetailPanel) {
        this._scanBatch = scanDetailPanel.getScanBatch();
        this._thumbnailStrip = scanDetailPanel.getThumbnailStrip();
        this._scanDetailPanel = scanDetailPanel;
        this._applyMenuSelectionsToThumbnailStrip = true;
    }

    public JPopupMenu createPopup(ImageProxy imageProxy) {
        JMenuItem jMenuItem;
        final ScannedImage scannedImage = ((ScannedImageProxy)imageProxy).getScannedImage();
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this._scanDetailPanel != null && this._scanDetailPanel._scanningEnabled && this._scanDetailPanel._correspondenceScanningInfo == null) {
            PatientFile patientFile;
            Object object2;
            JMenu jMenu = new JMenu("Patient File");
            jPopupMenu.add(jMenu);
            jMenuItem = new JMenuItem("New Patient File");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final PatientFile patientFile = ScanDetailPopupFactory.this._scanBatch.addPatientFile();
                    ScanDetailPopupFactory.this.visitSelectedThumbnails(scannedImage, new Visitor<ScannedImage>(){

                        public void visit(final ScannedImage scannedImage) {
                            ScanDetailPopupFactory.this.setVisitOnImage(scannedImage, patientFile);
                            DaoBackgroundExecutor.executeInGuiBackground((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ((ScanningDao)ScanningDao.Impl.get()).update((BaseBusinessBean)scannedImage);
                                }
                            });
                        }
                    });
                }
            });
            jMenu.addSeparator();
            for (Object object2 : this._scanBatch.patientFiles) {
                patientFile = object2;
                jMenuItem = new JMenuItem("Patient File " + patientFile.id.get());
                jMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ScanDetailPopupFactory.this.visitSelectedThumbnails(scannedImage, new Visitor<ScannedImage>(){

                            public void visit(final ScannedImage scannedImage) {
                                ScanDetailPopupFactory.this.setVisitOnImage(scannedImage, patientFile);
                                DaoBackgroundExecutor.executeInGuiBackground((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        ((ScanningDao)ClientScanningDao.Impl.get()).update((BaseBusinessBean)scannedImage);
                                    }
                                });
                            }
                        });
                    }
                });
            }
            jMenu = new JMenu("Document Type");
            jPopupMenu.add(jMenu);
            List list = ((ScanningDao)ScanningDao.Impl.get()).selectAll(DocumentType.class);
            object2 = list.iterator();
            while (object2.hasNext()) {
                PatientFile patientFile2 = patientFile = (DocumentType)object2.next();
                jMenuItem = new JMenuItem(patientFile.toString());
                jMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener((DocumentType)patientFile2){
                    final /* synthetic */ DocumentType val$finalDocumentType;
                    {
                        this.val$finalDocumentType = documentType;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ScanDetailPopupFactory.this.visitSelectedThumbnails(scannedImage, new Visitor<ScannedImage>(){

                            public void visit(final ScannedImage scannedImage) {
                                scannedImage.documentType.set((Object)val$finalDocumentType);
                                ScanDetailPopupFactory.this._thumbnailStrip.resetGroups();
                                DaoBackgroundExecutor.executeInGuiBackground((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        ((ScanningDao)ScanningDao.Impl.get()).update((BaseBusinessBean)scannedImage);
                                    }
                                });
                            }
                        });
                    }
                });
            }
            jMenuItem = new JMenuItem("Enter Patient #");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final PatientFile patientFile = scannedImage.getPatientFile();
                    String string = JOptionPane.showInputDialog(null, "Enter Patient Number:", patientFile.patientNumber.get());
                    if (string != null) {
                        patientFile.patientNumber.set((Object)string);
                        DaoBackgroundExecutor.executeInGuiBackground((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ((ScanningDao)ScanningDao.Impl.get()).update((BaseBusinessBean)patientFile);
                            }
                        });
                    }
                }
            });
            jPopupMenu.addSeparator();
        }
        if (this._thumbnailStrip != null) {
            jMenuItem = new JMenuItem("View");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImageViewer.showImage((ImageProxy)scannedImage.getImageProxy(), ScanDetailPopupFactory.this._thumbnailStrip.getImageCollection(), ScanDetailPopupFactory.createImageViewerPopup(scannedImage, ScanDetailPopupFactory.this._thumbnailStrip));
                }
            });
        }
        jMenuItem = new JMenuItem("Print");
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintingService.print((ScannedImage)scannedImage);
            }
        });
        if (this._thumbnailStrip != null && !this._thumbnailStrip.getSelectedThumbnails().isEmpty()) {
            jMenuItem = new JMenuItem("Print Selected");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    List list = ListX.create();
                    for (Thumbnail thumbnail : ScanDetailPopupFactory.this._thumbnailStrip.getSelectedThumbnails()) {
                        list.add((ScannedImage)thumbnail.getReference());
                    }
                    list.sort(Comparator.comparing(ScannedImage::getPageNumber));
                    PrintingService.print((Collection)list);
                }
            });
        }
        if (this._scanDetailPanel != null && this._scanDetailPanel._scanningEnabled) {
            jMenuItem = new JMenuItem("Re-Scan");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Thumbnail<ScannedImage> thumbnail = ScanDetailPopupFactory.this._thumbnailStrip.getThumbnailByReference(scannedImage);
                    ScanDetailPopupFactory.this._scanDetailPanel.performScan(true, scannedImage);
                    thumbnail.setImageProxy((ImageProxy)scannedImage.getImageProxy());
                }
            });
        }
        if (this._scanDetailPanel != null && this._scanDetailPanel.isNewlyCreatedBatch()) {
            jMenuItem = new JMenuItem("Remove Image(s)");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScanDetailPopupFactory.this._scanDetailPanel.removeScanActionPerformed();
                }
            });
        }
        return jPopupMenu;
    }

    protected void visitSelectedThumbnails(ScannedImage scannedImage, Visitor<ScannedImage> visitor) {
        if (this._thumbnailStrip != null && this._applyMenuSelectionsToThumbnailStrip) {
            for (Thumbnail<ScannedImage> thumbnail : this._thumbnailStrip.getSelectedThumbnails()) {
                Visitor.Helper.safeVisit(visitor, (Object)thumbnail.getReference());
            }
        } else {
            Visitor.Helper.safeVisit(visitor, (Object)scannedImage);
        }
    }

    private void setVisitOnImage(ScannedImage scannedImage, PatientFile patientFile) {
        scannedImage.patientFileId.set((Object)((Long)patientFile.id.get()));
        this._thumbnailStrip.resetGroups();
    }

    public static ScanDetailPopupFactory createImageViewerPopup(ScannedImage scannedImage, ThumbnailStrip<ScannedImage> thumbnailStrip) {
        return new ScanDetailPopupFactory((ScanBatch)scannedImage.batch.get(), thumbnailStrip);
    }

    public static ScanDetailPopupFactory createThumbnailStripPopup(ScanDetailPanel scanDetailPanel) {
        return new ScanDetailPopupFactory(scanDetailPanel);
    }
}

