/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.ImageIndexer;
import com.ahsrcm.client.scanning.ImageSource;
import com.ahsrcm.client.scanning.ImportProcessor;
import com.ahsrcm.client.scanning.ImportProcessorImpl;
import com.ahsrcm.client.scanning.JTwainImageSource;
import com.ahsrcm.client.scanning.PdfChooserImageSource;
import com.ahsrcm.client.scanning.RescanImportProcessor;
import com.ahsrcm.client.scanning.ScannedImageSource;
import com.ahsrcm.client.scanning.ScannerManager;
import com.ahsrcm.client.scanning.TiffChooserImageSource;
import com.ahsrcm.client.scanning.gui.EntityComboBoxModel;
import com.ahsrcm.client.scanning.gui.IndexOptionEnum;
import com.ahsrcm.client.scanning.gui.IntegerField;
import com.ahsrcm.client.scanning.gui.ScanDetailPopupFactory;
import com.ahsrcm.client.scanning.gui.Thumbnail;
import com.ahsrcm.client.scanning.gui.ThumbnailStrip;
import com.ahsrcm.core.scanning.gui.ImageProxy;
import com.ahsrcm.core.util.DeployEdgeProperties;
import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.DocumentType;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.rules.Rule;
import com.ahsrcm.corp.rules.RuleManager;
import com.ahsrcm.corp.rules.RuleSet;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.scanning.app.client.beans.CorrespondenceScanningInfo;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.dao.DaoBackgroundExecutor;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.scanning.device.Feeder;
import com.ahsrcm.scanning.device.PaperSize;
import com.ahsrcm.util.PrintingService;
import com.ahsrcm.util.UserContext;
import com.ahsrcm.util.guice.Directories;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.java.dev.properties.container.PropertyContextable;
import net.java.dev.properties.util.BeanComparator;
import net.model3.bean.converters.Converter;
import net.model3.chrono.DateOnly;
import net.model3.collections.ListX;
import net.model3.collections.SetX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.AbstractComparable;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.Directory;
import net.model3x.swing.HStringProvider;
import net.model3x.swing.M3Panel;
import net.model3x.swing.datechooser.TextFieldDateOnlyChooser;
import net.model3x.swing.domviewer.ComponentTreeModelBuilder;

public class ScanDetailPanel {
    private static final long serialVersionUID = 860682280559347721L;
    private static final Log logger = LogHelper.getLog(ScanDetailPanel.class);
    DeployEdgeProperties _deployEdgeProperties = (DeployEdgeProperties)DependencyInjector.getInstance(DeployEdgeProperties.class);
    Directories _directories = (Directories)DependencyInjector.getInstance(Directories.class);
    ScannerManager _jtwainManager = (ScannerManager)DependencyInjector.getInstance(ScannerManager.class);
    EntityComboBoxModel<ImageSource> _scannerModel;
    final EntityComboBoxModel<Feeder> _feederModel = new EntityComboBoxModel<Feeder>(Feeder.values());
    final EntityComboBoxModel<PaperSize> _paperSizeModel = new EntityComboBoxModel<PaperSize>(PaperSize.values());
    final EntityComboBoxModel<User> _nextUserModel = new EntityComboBoxModel();
    final ThumbnailStrip<ScannedImage> _thumbnailStrip = new ThumbnailStrip();
    final ScanBatch _scanBatch;
    final CorrespondenceScanningInfo _correspondenceScanningInfo;
    boolean _scanningEnabled = true;
    boolean _newlyCreatedBatch = false;
    private JLabel _numberOfPatientFilesTag;
    private JLabel _paperSizeTag;
    private RuleManager _ruleManager;
    Listener _listener = new Listener(){

        @Override
        public void closing(boolean bl) {
        }
    };
    M3Panel _mainPanel;
    M3Panel _headerPanel;
    JLabel _numberOfPatientFilesMsg;
    JButton _cancelButton;
    TextFieldDateOnlyChooser _dateOfServiceDC;
    JComboBox _feederCB;
    JButton _finishedButton;
    JLabel _losLabel;
    JLabel _numberOfPagesMsg = new JLabel();
    IntegerField _numberOfPagesTF;
    IntegerField _numberOfPatientFilesTF;
    JComboBox _paperSizeCB;
    JButton _printBatchButton;
    JLabel _waitingLabel;
    JButton _scanButton;
    JTextField _scanControlNumberLabel;
    JButton _scanWithOptionsButton;
    JComboBox _scannerCB;
    JScrollPane _scrollPane;
    JComboBox _views;
    JComboBox _indexingCB;
    JLabel _nextStageLabel;
    JLabel _nextStageTag;
    JComboBox _nextUserCB;
    JLabel _nextUserTag;
    JLabel _codingRequiredLabel;
    JLabel _codingRequiredTag;
    JLabel _scanControlNumberTag;
    JLabel _scannerTag;
    JLabel _viewsTag;
    JLabel _dateOfServiceTag;
    JLabel _feederTag;
    JLabel _indexingTag;
    JLabel _losTag;
    JLabel _numberOfPagesTag;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        ScanDetailPanel scanDetailPanel = new ScanDetailPanel(ScanBatch.Meta, true, true, null, null);
        jFrame.add((Component)scanDetailPanel.getMainPanel());
        jFrame.pack();
        ComponentTreeModelBuilder.addFrameMenus();
        jFrame.setVisible(true);
    }

    public ScanDetailPanel(ScanBatch scanBatch, boolean bl, IndexOptionEnum indexOptionEnum, CorrespondenceScanningInfo correspondenceScanningInfo) {
        this(scanBatch, bl, true, indexOptionEnum, correspondenceScanningInfo);
        this._indexingCB.setSelectedItem(indexOptionEnum.getId());
    }

    public ScanDetailPanel(ScanBatch scanBatch, boolean bl, boolean bl2, IndexOptionEnum indexOptionEnum, CorrespondenceScanningInfo correspondenceScanningInfo) {
        this._scanBatch = scanBatch;
        this._newlyCreatedBatch = bl;
        this._correspondenceScanningInfo = correspondenceScanningInfo;
        this.initComponents();
        if (!bl2) {
            this.disableScanning();
        }
        logger.debug((Object)"prefetch images for scan batch {}", this._scanBatch.id.get());
        for (PatientFile patientFile : scanBatch.patientFiles) {
            patientFile.scheduleImageDownloading();
        }
    }

    public List<ImageSource> getScannerOptions(boolean bl) {
        List list = ListX.create();
        list.addAll(this._jtwainManager.getAllScanners());
        list.add(new TiffChooserImageSource());
        if (bl) {
            list.add(new PdfChooserImageSource());
        }
        return list;
    }

    public List<ImageSource> getScannerOptions(String string) {
        boolean bl = this._correspondenceScanningInfo == null && string != null;
        return this.getScannerOptions(bl);
    }

    private void initComponents() {
        this._mainPanel = new M3Panel("fill, ins 10");
        this._mainPanel.setBackground(Color.white);
        this._headerPanel = new M3Panel("ins 10");
        this._headerPanel.setColumnConstraints("[][]25[][]25[][]");
        this._headerPanel.setBackground(Color.white);
        this._mainPanel.add((Component)this._headerPanel, (Object)"growx, north");
        this._scannerCB = new JComboBox();
        this._scannerCB.setPreferredSize(new Dimension(160, this._scannerCB.getPreferredSize().height));
        this._scannerTag = new JLabel("Scanner:");
        this._headerPanel.add((Component)this._scannerTag, (Object)"right");
        this._headerPanel.add((Component)this._scannerCB);
        this._numberOfPagesTF = new IntegerField(10);
        this._numberOfPagesTag = new JLabel("Number of Pages:");
        this._headerPanel.add((Component)this._numberOfPagesTag, (Object)"right");
        this._headerPanel.add((Component)((Object)this._numberOfPagesTF));
        this._scanControlNumberLabel = new JTextField();
        this._scanControlNumberLabel.setEditable(false);
        this._scanControlNumberLabel.setBorder(null);
        this._scanControlNumberLabel.setBackground(Color.white);
        this._scanControlNumberTag = new JLabel("Scan Batch:");
        this._headerPanel.add((Component)this._scanControlNumberTag, (Object)"right");
        this._headerPanel.add((Component)this._scanControlNumberLabel);
        this._numberOfPagesMsg = new JLabel();
        this._headerPanel.add((Component)this._numberOfPagesMsg, (Object)"newline, skip 3");
        this._feederCB = new JComboBox();
        this._feederCB.setPreferredSize(new Dimension(160, this._scannerCB.getPreferredSize().height));
        this._feederTag = new JLabel("Document Feeder:");
        this._headerPanel.add((Component)this._feederTag, (Object)"newline, right");
        this._headerPanel.add((Component)this._feederCB);
        this._indexingCB = new JComboBox();
        this._indexingCB.setModel(new DefaultComboBoxModel<String>(IndexOptionEnum.getIdKeySet()));
        this._indexingTag = new JLabel("Indexing:");
        this._headerPanel.add((Component)this._indexingTag, (Object)"right");
        this._headerPanel.add((Component)this._indexingCB);
        this._codingRequiredTag = new JLabel("Coding Required:");
        this._codingRequiredLabel = new JLabel();
        this._headerPanel.add((Component)this._codingRequiredTag, (Object)"right");
        this._headerPanel.add((Component)this._codingRequiredLabel);
        this._paperSizeCB = new JComboBox();
        this._paperSizeCB.setPreferredSize(new Dimension(160, this._scannerCB.getPreferredSize().height));
        this._paperSizeTag = new JLabel("Paper Size:");
        this._headerPanel.add((Component)this._paperSizeTag, (Object)"newline,right");
        this._headerPanel.add((Component)this._paperSizeCB);
        this._numberOfPatientFilesTF = new IntegerField(10);
        this._numberOfPatientFilesTag = new JLabel("Number of Patient Files:");
        this._headerPanel.add((Component)this._numberOfPatientFilesTag, (Object)"right");
        this._headerPanel.add((Component)((Object)this._numberOfPatientFilesTF));
        this._nextStageTag = new JLabel("Next Stage:");
        this._nextStageLabel = new JLabel();
        this._headerPanel.add((Component)this._nextStageTag, (Object)"right");
        this._headerPanel.add((Component)this._nextStageLabel);
        this._numberOfPatientFilesMsg = new JLabel();
        this._headerPanel.add((Component)this._numberOfPatientFilesMsg, (Object)"newline, skip 3");
        this._losLabel = new JLabel();
        this._losTag = new JLabel("Location of Service:");
        this._headerPanel.add((Component)this._losTag, (Object)"newline, right");
        this._headerPanel.add((Component)this._losLabel);
        this._dateOfServiceDC = new TextFieldDateOnlyChooser();
        this._dateOfServiceDC.setPreferredSize(new Dimension(130, this._dateOfServiceDC.getPreferredSize().height));
        this._dateOfServiceTag = new JLabel("Date:");
        this._headerPanel.add((Component)this._dateOfServiceTag, (Object)"right");
        this._headerPanel.add((Component)this._dateOfServiceDC);
        this._nextUserTag = new JLabel("Next User:");
        this._nextUserCB = new JComboBox<User>(this._nextUserModel);
        this._headerPanel.add((Component)this._nextUserTag, (Object)"right");
        this._headerPanel.add((Component)this._nextUserCB);
        URL uRL = this.getClass().getClassLoader().getResource("waiting.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this._waitingLabel = new JLabel(imageIcon);
        this._waitingLabel.setVisible(false);
        this._scanButton = new JButton("Scan");
        this._scanWithOptionsButton = new JButton("Scan (With Options)");
        this._headerPanel.add((Component)this._waitingLabel, (Object)"newline, right, split 2");
        this._headerPanel.add((Component)this._scanButton);
        this._headerPanel.add((Component)this._scanWithOptionsButton);
        this._views = new JComboBox();
        this._viewsTag = new JLabel("Views");
        this._headerPanel.add((Component)this._viewsTag, (Object)"right");
        this._headerPanel.add((Component)this._views);
        this._printBatchButton = new JButton("Print Batch");
        String string = "Cancel";
        if (!this._newlyCreatedBatch) {
            string = "Close";
        }
        this._cancelButton = new JButton(string);
        this._finishedButton = new JButton("Finished");
        this._headerPanel.add((Component)this._printBatchButton);
        this._headerPanel.add((Component)this._cancelButton, (Object)"split 2");
        this._headerPanel.add((Component)this._finishedButton, (Object)"gapleft 11");
        this._scrollPane = new JScrollPane();
        this._mainPanel.add((Component)this._scrollPane, (Object)"grow");
        List<ImageSource> list = this.getScannerOptions(true);
        this._scannerModel = new EntityComboBoxModel<ImageSource>(list);
        this._scannerModel.setConverter((Converter<ImageSource>)new HStringProvider.HStringAdapter<ImageSource>(null){

            public String valueToString(ImageSource imageSource) {
                if (imageSource instanceof TiffChooserImageSource) {
                    return "TIFF File Scanner";
                }
                if (imageSource instanceof PdfChooserImageSource) {
                    return "PDF File Scanner";
                }
                if (imageSource instanceof JTwainImageSource) {
                    return ((JTwainImageSource)imageSource).getName();
                }
                return imageSource.toString();
            }
        });
        this._nextUserModel.setNullable(false);
        this._nextUserCB.setModel(this._nextUserModel);
        this._nextStageLabel.setText("");
        this._codingRequiredLabel.setText("");
        this._scannerCB.setModel(this._scannerModel);
        this._feederCB.setModel(this._feederModel);
        this._paperSizeCB.setModel(this._paperSizeModel);
        this._indexingCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SwingWorker<Void, Void>(){
                    List<ImageSource> scanners = ListX.create();

                    @Override
                    protected Void doInBackground() throws Exception {
                        try {
                            String string = (String)ScanDetailPanel.this._indexingCB.getSelectedItem();
                            boolean bl = string != null;
                            this.scanners = ScanDetailPanel.this.getScannerOptions(bl);
                        }
                        catch (Exception exception) {
                            logger.warn((Object)exception);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        ScanDetailPanel.this._scannerModel.setItems(this.scanners);
                        if (this.scanners.size() > 0) {
                            ScanDetailPanel.this._scannerCB.setSelectedIndex(0);
                        }
                    }
                }.execute();
            }
        });
        this._scrollPane.setViewportView(this._thumbnailStrip);
        this._paperSizeModel.setSelectedEntity(PaperSize.Letter);
        this._feederModel.setSelectedEntity(Feeder.Simplex);
        this._numberOfPagesTF.setValue((Integer)this._scanBatch.expectedImageCount.get());
        if (this._scanBatch.id.get() != null) {
            this._scanControlNumberLabel.setText(((Long)this._scanBatch.id.get()).toString());
        }
        this._numberOfPatientFilesTF.setValue((Integer)this._scanBatch.expectedVisitCount.get());
        this._numberOfPagesMsg.setVisible(false);
        this._numberOfPatientFilesMsg.setVisible(false);
        this._thumbnailStrip.setResetGroupsListener(new ThumbnailStrip.ResetGroupsListener(){

            @Override
            public void reset() {
            }
        });
        this._thumbnailStrip.setPopupFactory(ScanDetailPopupFactory.createThumbnailStripPopup(this));
        this._thumbnailStrip.setScrollPane(this._scrollPane);
        final ArrayList<ThumbnailStrip.GroupingStrategy> arrayList = new ArrayList<ThumbnailStrip.GroupingStrategy>();
        ThumbnailStrip.GroupingStrategy<ScannedImage> groupingStrategy = new ThumbnailStrip.GroupingStrategy<ScannedImage>(){

            @Override
            public String getGroupingField(Thumbnail<ScannedImage> thumbnail) {
                return "" + thumbnail.getReference().patientFileId.get();
            }

            public String toString() {
                return "Patient File";
            }
        };
        arrayList.add(groupingStrategy);
        arrayList.add(new ThumbnailStrip.GroupingStrategy<ScannedImage>(){

            @Override
            public String getGroupingField(Thumbnail<ScannedImage> thumbnail) {
                return String.valueOf(thumbnail.getReference().pageNumber.get());
            }

            public String toString() {
                return "Page Number";
            }
        });
        arrayList.add(new ThumbnailStrip.GroupingStrategy<ScannedImage>(){

            @Override
            public String getGroupingField(Thumbnail<ScannedImage> thumbnail) {
                DocumentType documentType = (DocumentType)thumbnail.getReference().documentType.get();
                if (documentType == null) {
                    return "";
                }
                return documentType.toString();
            }

            public String toString() {
                return "Document Type";
            }
        });
        this._thumbnailStrip.setCaptionProvider(new ThumbnailStrip.CaptionProvider<ScannedImage>(){

            @Override
            public String getCaption(Thumbnail<ScannedImage> thumbnail) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html>");
                for (ThumbnailStrip.GroupingStrategy groupingStrategy : arrayList) {
                    String string = groupingStrategy.getGroupingField(thumbnail);
                    if (!StringX.isNotBlank((String)string) || !groupingStrategy.showOnCaption() || groupingStrategy == ScanDetailPanel.this._thumbnailStrip.getGroupingStrategy()) continue;
                    stringBuilder.append(groupingStrategy);
                    stringBuilder.append(" ");
                    stringBuilder.append(string);
                    stringBuilder.append("<br>");
                }
                stringBuilder.append("Image id ");
                stringBuilder.append(thumbnail.getReference().id.get());
                stringBuilder.append("<br>");
                stringBuilder.append("</html>");
                return stringBuilder.toString();
            }
        });
        final EntityComboBoxModel entityComboBoxModel = new EntityComboBoxModel(arrayList);
        this._views.setModel(entityComboBoxModel);
        this._thumbnailStrip.setGroupingStrategy(groupingStrategy);
        this._views.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanDetailPanel.this._thumbnailStrip.setGroupingStrategy((ThumbnailStrip.GroupingStrategy)entityComboBoxModel.getSelectedEntity());
            }
        });
        if (this._scannerModel.getSize() > 0) {
            this._scannerModel.setSelectedEntity(this._scannerModel.getEntityAt(0));
        }
        for (ScannedImage scannedImage : this._scanBatch.getVisibleImages()) {
            if (!scannedImage.isVisible()) continue;
            this._thumbnailStrip.addThumbnail((ImageProxy)scannedImage.getImageProxy(), scannedImage);
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2 = bl = actionEvent.getSource() == ScanDetailPanel.this._cancelButton;
                if (ScanDetailPanel.this._scanningEnabled && !bl && !ScanDetailPanel.this.validateScan()) {
                    return;
                }
                boolean bl3 = ScanDetailPanel.this._deployEdgeProperties.getCleanupPdfToTifConversionFiles();
                if (bl3) {
                    Directory directory = ScanDetailPanel.this._directories.conversionTemp();
                    logger.debug((Object)("cleaning up " + directory.getCanonicalPath()));
                    directory.deleteTree();
                }
                if (ScanDetailPanel.this._scanningEnabled) {
                    ScanDetailPanel.this.finishBatch(ScanDetailPanel.this._scanBatch, bl);
                }
                ScanDetailPanel.this._listener.closing(bl);
            }
        };
        this._cancelButton.addActionListener(actionListener);
        this._finishedButton.addActionListener(actionListener);
        this._dateOfServiceDC.setValue(new DateOnly(((Date)this._scanBatch.dateOfService.get()).getTime()));
        if (this._scanBatch.location.get() != null) {
            this._losLabel.setText(((Location)this._scanBatch.location.get()).getVisualId());
        }
        entityComboBoxModel.setSelectedEntity(groupingStrategy);
        this._printBatchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintingService.print((Collection)ScanDetailPanel.this._scanBatch.getVisibleImages());
            }
        });
        this._scanWithOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanDetailPanel.this._scanWithOptionsButtonActionPerformed(actionEvent);
            }
        });
        this._scanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScanDetailPanel.this._scanButtonActionPerformed(actionEvent);
            }
        });
        if (!ScanBatch.Meta.equals((Object)this._scanBatch)) {
            if (this._newlyCreatedBatch) {
                this.updateRuleInfo();
            } else {
                this._nextStageLabel.setVisible(false);
                this._nextStageTag.setVisible(false);
                this._nextUserCB.setVisible(false);
                this._nextUserTag.setVisible(false);
                this._codingRequiredLabel.setVisible(false);
                this._codingRequiredTag.setVisible(false);
            }
        }
        if (this._correspondenceScanningInfo != null) {
            this._indexingCB.setEnabled(false);
            this._nextStageLabel.setVisible(false);
            this._nextStageTag.setVisible(false);
            this._nextUserCB.setVisible(false);
            this._nextUserTag.setVisible(false);
            this._codingRequiredLabel.setVisible(false);
            this._codingRequiredTag.setVisible(false);
        }
        this._numberOfPatientFilesMsg.setBackground(Color.white);
        this._numberOfPatientFilesMsg.setForeground(Color.red);
    }

    private void _scanWithOptionsButtonActionPerformed(ActionEvent actionEvent) {
        this.performScan(true, null);
    }

    private void _scanButtonActionPerformed(ActionEvent actionEvent) {
        this.performScan(false, null);
    }

    void performScan(final boolean bl, final ScannedImage scannedImage) {
        if (this._scannerModel.getSelectedEntity() == null) {
            JOptionPane.showMessageDialog((Component)this._mainPanel, "Please select a scanner");
            return;
        }
        this._scanButton.setEnabled(false);
        this._scanWithOptionsButton.setEnabled(false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ImageSource imageSource = ScanDetailPanel.this._scannerModel.getSelectedEntity();
                    if (imageSource instanceof TiffChooserImageSource) {
                        ((TiffChooserImageSource)imageSource).setDuplex(Feeder.Duplex.equals((Object)ScanDetailPanel.this._feederModel.getSelectedEntity()));
                    } else if (imageSource instanceof ScannedImageSource) {
                        ((ScannedImageSource)imageSource).setFeeder(ScanDetailPanel.this._feederModel.getSelectedEntity());
                        ((ScannedImageSource)imageSource).setPaperSize(ScanDetailPanel.this._paperSizeModel.getSelectedEntity());
                        ((ScannedImageSource)imageSource).setShowOptionsDialog(bl);
                    }
                    String string = (String)ScanDetailPanel.this._indexingCB.getSelectedItem();
                    IndexOptionEnum indexOptionEnum = IndexOptionEnum.enumFromSelectorString(string);
                    ImageIndexer imageIndexer = indexOptionEnum.getImageIndexer();
                    indexOptionEnum.applySettings(ScanDetailPanel.this._feederModel.getSelectedEntity());
                    ImportProcessor importProcessor = null;
                    importProcessor = scannedImage != null ? ScanDetailPanel.this.getRescanProcessor(scannedImage, imageSource) : ScanDetailPanel.this.getProcessor(imageSource, imageIndexer);
                    importProcessor.process();
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                    throw new RuntimeException(exception);
                }
            }
        };
        DaoBackgroundExecutor.executeInGuiBackground((Runnable)runnable);
    }

    private ImportProcessor getProcessor(ImageSource imageSource, ImageIndexer imageIndexer) {
        return new ImportProcessorImpl(DependencyInjector.get(), this._scanBatch, imageSource, imageIndexer, this._correspondenceScanningInfo, false, new ImportProcessor.ListenerAdapter(){

            @Override
            public void start() {
                ScanDetailPanel.this._waitingLabel.setVisible(true);
            }

            @Override
            public void newScannedImage(final ScannedImage scannedImage) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanDetailPanel.this._thumbnailStrip.addThumbnail((ImageProxy)scannedImage.getImageProxy(), scannedImage);
                        ScanDetailPanel.this._thumbnailStrip.resetGroups();
                    }
                });
            }

            @Override
            public void complete(boolean bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanDetailPanel.this._waitingLabel.setVisible(false);
                        ScanDetailPanel.this._scanButton.setEnabled(true);
                        ScanDetailPanel.this._scanWithOptionsButton.setEnabled(true);
                    }
                });
            }
        });
    }

    private ImportProcessor getRescanProcessor(ScannedImage scannedImage, ImageSource imageSource) {
        return new RescanImportProcessor(DependencyInjector.get(), scannedImage, imageSource, new ImportProcessor.ListenerAdapter(){

            @Override
            public void start() {
                ScanDetailPanel.this._waitingLabel.setVisible(true);
            }

            @Override
            public void newScannedImage(final ScannedImage scannedImage) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Thumbnail<ScannedImage> thumbnail = ScanDetailPanel.this._thumbnailStrip.getThumbnailByReference(scannedImage);
                        if (thumbnail == null) {
                            ScanDetailPanel.this._thumbnailStrip.addThumbnail((ImageProxy)scannedImage.getImageProxy(), scannedImage);
                        }
                    }
                });
            }

            @Override
            public void complete(boolean bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanDetailPanel.this._waitingLabel.setVisible(false);
                        ScanDetailPanel.this._scanButton.setEnabled(true);
                        ScanDetailPanel.this._scanWithOptionsButton.setEnabled(true);
                        ScanDetailPanel.this._thumbnailStrip.resetGroups();
                    }
                });
            }
        });
    }

    public void setListener(Listener listener) {
        this._listener = listener;
    }

    public boolean validateScan() {
        boolean bl = false;
        try {
            if (this._numberOfPagesTF.isBlank()) {
                throw new RuntimeException();
            }
            this._scanBatch.expectedImageCount.set((Object)this._numberOfPagesTF.getValue());
            this._numberOfPagesMsg.setVisible(false);
        }
        catch (Exception exception) {
            this._numberOfPagesMsg.setVisible(true);
            this._numberOfPagesMsg.setForeground(Color.RED);
            this._numberOfPagesMsg.setText("Must be a valid number between 1 and 999");
            bl = true;
        }
        try {
            if (this._numberOfPatientFilesTF.isBlank()) {
                throw new RuntimeException();
            }
            this._scanBatch.expectedVisitCount.set((Object)this._numberOfPatientFilesTF.getValue());
            this._numberOfPatientFilesMsg.setVisible(false);
        }
        catch (Exception exception) {
            this._numberOfPatientFilesMsg.setVisible(true);
            this._numberOfPatientFilesMsg.setForeground(Color.RED);
            this._numberOfPatientFilesMsg.setText("Must be a valid number between 1 and 999");
            bl = true;
        }
        if (bl) {
            return false;
        }
        DateOnly dateOnly = this._dateOfServiceDC.getValue();
        if (dateOnly == null) {
            JOptionPane.showConfirmDialog((Component)this.getMainPanel(), "Date must be entered", "Confirm Completion", -1, 0);
            return false;
        }
        if (dateOnly.greaterThan((AbstractComparable)new DateOnly())) {
            JOptionPane.showConfirmDialog((Component)this.getMainPanel(), "Date cannot be in the future", "Confirm Completion", -1, 0);
            return false;
        }
        int n = this._scanBatch.getPatientFiles().size() - this.getPruneableVisits().size();
        int n2 = this._scanBatch.getVisibleImageCount();
        if (n2 != (Integer)this._scanBatch.expectedImageCount.get()) {
            JOptionPane.showConfirmDialog((Component)this.getMainPanel(), "Expected " + this._scanBatch.expectedImageCount.get() + " and " + n2 + " image(s) have been scanned.", "Confirm Completion", -1, 0);
            return false;
        }
        if (n != (Integer)this._scanBatch.expectedVisitCount.get()) {
            JOptionPane.showConfirmDialog((Component)this.getMainPanel(), "Expected " + this._scanBatch.expectedVisitCount.get() + " and " + this._scanBatch.patientFiles.size() + " patient file(s) have been scanned.", "Confirm Completion", -1, 0);
            return false;
        }
        if (this._newlyCreatedBatch && ((Boolean)this._ruleManager.getRuleSet().getPostScanningRule().userRequired.get()).booleanValue() && this._nextUserModel.getSelectedEntity() == null) {
            JOptionPane.showConfirmDialog((Component)this.getMainPanel(), "Must select a user for this batch to get pushed to.", "Must select a user for this batch to get pushed to.", -1, 0);
            return false;
        }
        return true;
    }

    public void disableScanning() {
        this._scanningEnabled = false;
        JComponent[] jComponentArray = new JComponent[]{this._cancelButton, this._feederCB, this._numberOfPagesTF, this._numberOfPatientFilesTF, this._paperSizeCB, this._waitingLabel, this._scanButton, this._scanWithOptionsButton, this._scannerCB, this._scanControlNumberLabel, this._scannerTag, this._losLabel, this._dateOfServiceDC, this._codingRequiredTag, this._nextStageTag, this._nextUserTag, this._nextStageLabel, this._nextUserCB, this._codingRequiredLabel, this._numberOfPagesTag, this._scanControlNumberTag, this._feederTag, this._losTag, this._dateOfServiceTag, this._indexingTag, this._paperSizeTag, this._indexingCB, this._numberOfPatientFilesTag};
        for (int i = 0; i < jComponentArray.length; ++i) {
            this._headerPanel.remove((Component)jComponentArray[i]);
        }
    }

    void finishBatch(ScanBatch scanBatch, final boolean bl) {
        logger.debug((Object)"Submitting finish batch {}", (Object)scanBatch);
        final Long l = scanBatch.getId();
        DaoBackgroundExecutor.executeInGuiBackground((Runnable)new Runnable(){

            @Override
            public void run() {
                ((ScanningDao)ScanningDao.Impl.get()).finishScanBatch(l.longValue(), bl, ScanDetailPanel.this._newlyCreatedBatch, new Date(ScanDetailPanel.this._dateOfServiceDC.getValue().inMillis()), ScanDetailPanel.this._numberOfPagesTF.getValue(), ScanDetailPanel.this._numberOfPatientFilesTF.getValue(), ScanDetailPanel.this._nextUserModel.getSelectedEntity());
            }
        });
        logger.debug((Object)"finishBatch {} has been completed on the client side", (Object)scanBatch);
    }

    private void pruneEmptyVisits() {
        Set<PatientFile> set = this.getPruneableVisits();
        for (PatientFile patientFile : set) {
            ((ScanBatch)patientFile.batch.get()).patientFiles.remove((Object)patientFile);
            patientFile.batch.set(null);
        }
        for (PatientFile patientFile : set) {
            logger.debug((Object)"Calling delete on patient file -- {}", (Object)patientFile);
            ((ScanningDao)ClientScanningDao.Impl.get()).delete((BaseBusinessBean)patientFile);
        }
    }

    private Set<PatientFile> getPruneableVisits() {
        Set set = SetX.create();
        for (PatientFile patientFile : this._scanBatch.patientFiles) {
            if (!patientFile.getAllImages().isEmpty() || !patientFile.getStage().equals((Object)Stage.ScanningInProgress.get())) continue;
            set.add(patientFile);
        }
        return set;
    }

    public ThumbnailStrip<ScannedImage> getThumbnailStrip() {
        return this._thumbnailStrip;
    }

    public ScanBatch getScanBatch() {
        return this._scanBatch;
    }

    void removeScanActionPerformed() {
        for (Thumbnail<ScannedImage> thumbnail : this._thumbnailStrip.getSelectedThumbnails()) {
            ScannedImage scannedImage = thumbnail.getReference();
            this._scanBatch.removeImage(scannedImage);
            scannedImage.patientFileId.set(null);
            ((ScanningDao)ScanningDao.Impl.get()).update((BaseBusinessBean)scannedImage);
            this._thumbnailStrip.removeThumbnail(scannedImage);
        }
        this._thumbnailStrip.resetGroups();
    }

    User getUser() {
        return ((UserContext)UserContext.Impl.get()).getUser();
    }

    public boolean isNewlyCreatedBatch() {
        return this._newlyCreatedBatch;
    }

    public M3Panel getMainPanel() {
        return this._mainPanel;
    }

    void updateRuleInfo() {
        this._ruleManager = (RuleManager)this._scanBatch.ruleManager.get();
        RuleSet ruleSet = this._ruleManager.getRuleSet();
        Rule rule = ruleSet.getPostScanningRule();
        List list = ListX.create((Iterable)this._ruleManager.getPossibleUsers((Stage)rule.stage.get()));
        User user = this._ruleManager.getDefaultUser(rule);
        Collections.sort(list, BeanComparator.create((PropertyContextable[])new PropertyContextable[]{User.Meta.description}));
        this._nextStageLabel.setText(((Stage)rule.stage.get()).getVisualId());
        this._nextUserModel.setItems(list);
        this._nextUserModel.setSelectedEntity(user);
        this._scanBatch.codingRequired.set((Object)ruleSet.isCodingRequired());
        if (ruleSet.isCodingRequired()) {
            this._codingRequiredLabel.setText("Yes");
        } else {
            this._codingRequiredLabel.setText("No");
        }
    }

    public static interface Listener {
        public void closing(boolean var1);
    }
}

