/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.model3.lang.StringX;
import net.model3x.swing.M3Panel;

public abstract class ScanCustomField {
    private final String name;
    private final String label;

    public ScanCustomField(String string, String string2) {
        this.name = string;
        this.label = string2;
    }

    public ScanCustomField asScanCustomField() {
        return this;
    }

    public void addToPanel(M3Panel m3Panel) {
        m3Panel.add((Component)new JLabel(this.label), (Object)"right");
        m3Panel.add((Component)this.getComponent(), (Object)"wrap");
    }

    public String getName() {
        return this.name;
    }

    public abstract void setEnabled(boolean var1);

    public abstract void clear();

    public abstract Object getValue();

    protected abstract JComponent getComponent();

    public static class LongScanCustomField
    extends ScanCustomField {
        private final JTextField component = new JTextField();

        public LongScanCustomField(String string, String string2, int n) {
            super(string, string2);
            this.decorate(n);
        }

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.component.setEnabled(bl);
        }

        @Override
        public void clear() {
            this.component.setText("");
        }

        @Override
        public Object getValue() {
            String string = this.component.getText();
            if (StringX.isBlank((String)string)) {
                return null;
            }
            return Long.parseLong(string);
        }

        private void decorate(final int n) {
            this.component.setDocument(new PlainDocument(){
                private final Pattern p = Pattern.compile("[0-9]");

                @Override
                public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (!this.p.matcher(Character.toString(c)).matches()) continue;
                        stringBuilder.append(c);
                    }
                    super.insertString(n2, StringX.safeSubstring((String)stringBuilder.toString(), (int)0, (int)(n - n2)), attributeSet);
                }
            });
        }
    }
}

