/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.CheckBoxFilterComponent;
import com.ahsrcm.client.scanning.gui.RegexFilter;
import java.awt.BorderLayout;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.model3x.swing.BeanTableModel;

public class RegexFilterTextfield
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BeanTableModel<Object> _tableModel;
    private JTextField _textField;
    private RowFilter<BeanTableModel<Object>, Integer> _delegateFilter;
    int previousLength = 0;

    public RegexFilterTextfield(BeanTableModel<?> beanTableModel) {
        this._tableModel = beanTableModel;
        this._textField = new JTextField();
        this.setLayout(new BorderLayout());
        this.add(this._textField);
        this._textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RegexFilterTextfield.this.filterChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RegexFilterTextfield.this.filterChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RegexFilterTextfield.this.filterChanged();
            }
        });
        CheckBoxFilterComponent.addFilterToRowSorter(this._tableModel.getRowSorter(), new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                if (RegexFilterTextfield.this.getDelegateFilter() == null) {
                    return true;
                }
                return RegexFilterTextfield.this.getDelegateFilter().include(entry);
            }
        });
    }

    void filterChanged() {
        if (this._textField.getText().length() >= 3 || this.previousLength >= 3 && this._textField.getText().length() < 3) {
            this._delegateFilter = null;
            this._tableModel.getRowSorter().sort();
        }
        this.previousLength = this._textField.getText().length();
    }

    public RowFilter<BeanTableModel<Object>, Integer> getDelegateFilter() {
        if (this._delegateFilter == null && this._textField.getText().length() >= 3) {
            Pattern pattern = Pattern.compile(this._textField.getText(), 2);
            this._delegateFilter = new RegexFilter<BeanTableModel<Object>, Integer>(pattern);
        }
        return this._delegateFilter;
    }

    public JTextField getTextField() {
        return this._textField;
    }
}

