/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.core.virtualmanager.ReferralDTO;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Location;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ThreadScheduler;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.GuiHelper;
import net.model3x.swing.BeanListener;
import net.model3x.swing.M3Panel;
import net.model3x.swing.SmartTable;
import net.model3x.swing.uistate.FrameStateMarshaller;

public class ReferralSelector {
    static final Logger logger = LoggerHelper.getLogger();
    SmartTable<ReferralDTO> _table = SmartTable.create(ReferralDTO.class);
    JTextField _searchField = new JTextField();
    M3Panel _panel = new M3Panel("fill");
    Division _division;
    String _currentSearch;
    @Inject
    ThreadScheduler _threadScheduler;

    public ReferralSelector() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        this._table.getModel().clearColumns();
        this._table.getModel().addColumn((PropertyContextable)ReferralDTO.$id);
        this._table.getModel().addColumn((PropertyContextable)ReferralDTO.$name);
        this._table.getModel().addColumn((PropertyContextable)ReferralDTO.$address);
        this._table.getModel().addColumn((PropertyContextable)ReferralDTO.$city);
        this._table.getModel().addColumn((PropertyContextable)ReferralDTO.$state);
        this._table.getModel().addColumn((PropertyContextable)ReferralDTO.$zip);
        this._panel.add((Component)this._searchField, (Object)"wrap, growx");
        this._panel.add((Component)new JScrollPane((Component)this._table), (Object)"wrap, grow");
        this._searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    ReferralSelector.this.doSearch();
                }
            }
        });
    }

    public M3Panel getPanel() {
        return this._panel;
    }

    void doSearch() {
        final String string = this._searchField.getText();
        if (this._currentSearch == null || !this._currentSearch.equals(string)) {
            this._threadScheduler.submit("patientSearch", new Runnable(){

                @Override
                public void run() {
                    List list = ((ScanningDao)ScanningDao.Impl.get()).referralLookup(ReferralSelector.this._division, string);
                    ReferralSelector.this._table.setRows(list);
                }
            });
            this._currentSearch = string;
        }
    }

    public void addSimpleSelectionListener(BeanListener<ReferralDTO> beanListener) {
        this._table.addSimpleSelectionListener(beanListener);
    }

    public static ReferralDTO popupSelector(Location location, Component component) {
        return ReferralSelector.popupSelector((Division)location.division.get(), component);
    }

    public static ReferralDTO popupSelector(Division division, Component component) {
        final AtomicReference atomicReference = new AtomicReference();
        Window window = GuiHelper.getWindowAncestor((Component)component);
        final JDialog jDialog = new JDialog(window);
        jDialog.setName("referralSelector");
        jDialog.setTitle("Referring Doctor");
        jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        ReferralSelector referralSelector = (ReferralSelector)DependencyInjector.getInstance(ReferralSelector.class);
        referralSelector._division = division;
        referralSelector.addSimpleSelectionListener(new BeanListener<ReferralDTO>(){

            public void beanEvent(ReferralDTO referralDTO) {
                atomicReference.set(referralDTO);
                jDialog.setVisible(false);
            }
        });
        jDialog.getContentPane().add((Component)referralSelector.getPanel());
        jDialog.pack();
        jDialog.setSize(jDialog.getWidth(), (int)((double)jDialog.getHeight() * 2.5));
        GuiHelper.center((Component)component, (Dialog)jDialog);
        referralSelector.doSearch();
        ((FrameStateMarshaller)DependencyInjector.getInstance(FrameStateMarshaller.class)).attach((Window)jDialog);
        jDialog.setVisible(true);
        return (ReferralDTO)atomicReference.get();
    }
}

