/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.BusyCursorHelper;
import com.ahsrcm.core.virtualmanager.PatientDTO;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Location;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ThreadScheduler;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.GuiHelper;
import net.model3x.swing.BeanListener;
import net.model3x.swing.M3Panel;
import net.model3x.swing.SmartTable;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class PatientSelector {
    static final Logger logger = LoggerHelper.getLogger();
    SmartTable<PatientDTO> _table = SmartTable.create(PatientDTO.class);
    JTextField _searchField = new JTextField();
    M3Panel _panel = new M3Panel("fill");
    Division _division;
    String _currentSearch = null;
    BusyCursorHelper _busyCursorHelper = new BusyCursorHelper();
    @Inject
    ThreadScheduler _threadScheduler;
    private JXLayer<JComponent> _layer;

    public PatientSelector() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        this._table.getModel().clearColumns();
        this._table.getModel().addColumn((PropertyContextable)PatientDTO.$number);
        this._table.getModel().addColumn((PropertyContextable)PatientDTO.$first);
        this._table.getModel().addColumn((PropertyContextable)PatientDTO.$middle);
        this._table.getModel().addColumn((PropertyContextable)PatientDTO.$last);
        this._table.getModel().addColumn((PropertyContextable)PatientDTO.$last);
        this._table.getModel().addColumn((PropertyContextable)PatientDTO.$ssn);
        this._table.getModel().addColumn((PropertyContextable)PatientDTO.$chartNumber);
        this._table.getModel().addColumn((PropertyContextable)PatientDTO.$birthDate);
        this._table.getModel().addColumn((PropertyContextable)PatientDTO.$homePhone);
        this._panel.add((Component)this._searchField, (Object)"wrap, growx");
        JScrollPane jScrollPane = new JScrollPane((Component)this._table);
        this._panel.add((Component)jScrollPane, (Object)"wrap, grow");
        this._searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    PatientSelector.this.doSearch();
                }
            }
        });
    }

    public void setDivision(Division division) {
        this._division = division;
    }

    Component getWrappedPanel() {
        if (this._layer == null) {
            AbstractLayerUI<JComponent> abstractLayerUI = new AbstractLayerUI<JComponent>(){
                private static final long serialVersionUID = 1L;

                protected void processMouseMotionEvent(MouseEvent mouseEvent, JXLayer<? extends JComponent> jXLayer) {
                    PatientSelector.this._busyCursorHelper.processMouseMotionEvent(mouseEvent);
                }
            };
            this._layer = new JXLayer((Component)this._panel);
            this._layer.setUI((LayerUI)abstractLayerUI);
        }
        return this._layer;
    }

    void doSearch() {
        final String string = this._searchField.getText();
        if (this._currentSearch == null || !this._currentSearch.equals(string)) {
            this._threadScheduler.submit("patientSearch", new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PatientSelector.this._busyCursorHelper.setBusyCursor();
                        }
                    });
                    try {
                        List list = ((ScanningDao)ScanningDao.Impl.get()).patientLookup(PatientSelector.this._division, string);
                        PatientSelector.this._table.setRows(list);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PatientSelector.this._busyCursorHelper.setDefaultCursor();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            this._currentSearch = string;
        }
    }

    public void addSimpleSelectionListener(BeanListener<PatientDTO> beanListener) {
        this._table.addSimpleSelectionListener(beanListener);
    }

    public static PatientDTO popupSelector(Location location, Component component) {
        return PatientSelector.popupSelector((Division)location.division.get(), component);
    }

    public static PatientDTO popupSelector(Division division, Component component) {
        final AtomicReference atomicReference = new AtomicReference();
        Window window = GuiHelper.getWindowAncestor((Component)component);
        final JDialog jDialog = new JDialog(window);
        jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        PatientSelector patientSelector = (PatientSelector)DependencyInjector.getInstance(PatientSelector.class);
        patientSelector._division = division;
        patientSelector.addSimpleSelectionListener(new BeanListener<PatientDTO>(){

            public void beanEvent(PatientDTO patientDTO) {
                atomicReference.set(patientDTO);
                jDialog.setVisible(false);
            }
        });
        jDialog.getContentPane().add(patientSelector.getWrappedPanel());
        jDialog.pack();
        jDialog.setSize(jDialog.getWidth(), (int)((double)jDialog.getHeight() * 2.5));
        GuiHelper.center((Component)component, (Dialog)jDialog);
        patientSelector.doSearch();
        jDialog.setVisible(true);
        return (PatientDTO)atomicReference.get();
    }
}

