/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.FileMonitor;
import com.ahsrcm.client.scanning.gui.ChargeEntryPanel;
import com.ahsrcm.client.scanning.gui.CodingPanel;
import com.ahsrcm.client.scanning.gui.CorrespondenceHeaderPanel;
import com.ahsrcm.client.scanning.gui.DeveloperHelperPanel;
import com.ahsrcm.client.scanning.gui.IndexOptionEnum;
import com.ahsrcm.client.scanning.gui.IvrPanel;
import com.ahsrcm.client.scanning.gui.ScanDetailPanel;
import com.ahsrcm.client.scanning.gui.ScanHeaderPanel;
import com.ahsrcm.client.scanning.gui.autoimport.AutoImportBatchProgressPanel;
import com.ahsrcm.client.scanning.gui.autoimport.ImportBatchPanel;
import com.ahsrcm.client.scanning.gui.autoimport.StragglerPanel;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.dto.CompanyCPTCodes;
import com.ahsrcm.corp.dto.ScanBatchDTO;
import com.ahsrcm.scanning.app.client.WindowActivator;
import com.ahsrcm.scanning.app.client.beans.CorrespondenceScanningInfo;
import com.ahsrcm.scanning.app.client.beans.IvrInfo;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import css.Stylesheet;
import css.StylesheetLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorListener;
import javax.swing.table.DefaultTableModel;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.imaging.Size;
import net.model3.lang.ClassX;
import net.model3.lang.StringX;
import net.model3.lang.SystemX;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.File;
import net.model3.swing.GuiHelper;
import net.model3x.swing.uistate.FrameStateMarshaller;

@Singleton
public class PanelPopupHelper {
    final Log logger = LogHelper.getLog();
    final List<Window> _visibleWindows = Collections.synchronizedList(new LinkedList());
    boolean _cleanupNeeded = false;
    JFrame _developerHelperFrame;
    boolean _showDeveloperHelperFrame;
    @Inject
    StylesheetLoader _stylesheetLoader;
    @Inject
    Injector _injector;
    Stylesheet _stylesheet;

    public PanelPopupHelper() {
        DependencyInjector.inject((Object)this);
        this.init();
    }

    private void init() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    List<Window> list = PanelPopupHelper.this.getVisibleWindows();
                    PanelPopupHelper.this.logger.debug((Object)"logging visible windows count={}", (Object)list.size());
                    for (Window window : list) {
                        if (window == null || !(window instanceof JFrame)) continue;
                        JFrame jFrame = (JFrame)window;
                        PanelPopupHelper.this.logger.debug(new Object[]{"visible frame title={} visible={} displayable={} showing={}", jFrame.getTitle(), jFrame.isVisible(), jFrame.isDisplayable(), jFrame.isShowing()});
                    }
                    PanelPopupHelper.this.purgeNonvisibleWindows();
                } else {
                    SwingUtilities.invokeLater(this);
                }
            }
        };
        ThreadScheduler threadScheduler = (ThreadScheduler)DependencyInjector.getInstance(ThreadScheduler.class);
        threadScheduler.scheduleRepeating("popupPanel", new TimeDuration("1 minute"), runnable);
        File file = new File("./src/main/resources/stylesheet.groovy");
        this._stylesheet = file.exists() ? this._stylesheetLoader.load(file) : this._stylesheetLoader.load(ClassX.getResource((String)"stylesheet.groovy"));
    }

    public List<Window> getVisibleWindows() {
        return ListX.create(this._visibleWindows);
    }

    public void showCodingPanel(final PatientFile patientFile, final CompanyCPTCodes companyCPTCodes) {
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ScanBatchDTO scanBatchDTO = ((ClientScanningDao)ClientScanningDao.Impl.get()).getScanBatchDTO(patientFile.getBatch().getId().longValue());
                PanelPopupHelper.this.logger.debug((Object)"showCodingPanel( {} )", (Object)patientFile);
                CodingPanel codingPanel = new CodingPanel(patientFile, companyCPTCodes, scanBatchDTO);
                PanelPopupHelper.this._stylesheet.applyTo((Component)codingPanel.getPanel());
                ChargeEntryPanel chargeEntryPanel = codingPanel.getChargeEntryPanel();
                PanelPopupHelper.this._stylesheet.applyTo((Component)((Object)chargeEntryPanel));
                PanelPopupHelper.this.popupPanel(codingPanel.getWrappedLayer(), "Coding " + patientFile.getVisualId(), "codingPanel");
            }
        });
    }

    public void showScanDetail(final ScanBatch scanBatch, final boolean bl) {
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                PanelPopupHelper.this.logger.debug((Object)"showScanDetail( {}, {} )", (Object)scanBatch, (Object)bl);
                final ScanDetailPanel scanDetailPanel = new ScanDetailPanel(scanBatch, false, bl, null, null);
                scanDetailPanel.setListener(new ScanDetailPanel.Listener(){

                    @Override
                    public void closing(boolean bl) {
                        SwingUtilities.getWindowAncestor((Component)scanDetailPanel.getMainPanel()).dispose();
                    }
                });
                PanelPopupHelper.this._stylesheet.applyTo((Component)scanDetailPanel.getMainPanel());
                PanelPopupHelper.this.popupPanel((JComponent)scanDetailPanel.getMainPanel(), "Scanning Panel for Batch " + scanBatch.id.get(), "scanDetail");
            }
        });
    }

    public void showCreateScanBatchPanel() {
        this.logger.debug((Object)"showCreateScanBatchPanel()");
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.setBackground(Color.WHITE);
                PanelPopupHelper.this.initCreateScanBatchPanel(jPanel);
                PanelPopupHelper.this._stylesheet.applyTo((Component)jPanel);
                PanelPopupHelper.this.popupPanel(jPanel, "Create New Scan Batch", new Size(800, 600), "createBatch");
            }
        });
    }

    public void showCorrespondencePanel(final CorrespondenceScanningInfo correspondenceScanningInfo) {
        this.logger.debug((Object)"showCreateScanBatchPanel()");
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.setBackground(Color.WHITE);
                PanelPopupHelper.this.initCorrespondenceScanPanel(jPanel, correspondenceScanningInfo);
                PanelPopupHelper.this._stylesheet.applyTo((Component)jPanel);
                PanelPopupHelper.this.popupPanel(jPanel, "Correspondence Scanning", new Size(800, 600), "correspondence");
            }
        });
    }

    public void showIvrPage(final IvrInfo ivrInfo) {
        this.logger.debug((Object)"showIVRPage()");
        this.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.setBackground(Color.WHITE);
                PanelPopupHelper.this.initIvrPanel(jPanel, ivrInfo);
                PanelPopupHelper.this._stylesheet.applyTo((Component)jPanel);
                PanelPopupHelper.this.popupPanel(jPanel, "Patient IVR Info", new Size(800, 600), "showIVRData");
            }
        });
    }

    void invokeAndWait(Runnable runnable) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
        }
    }

    void initCorrespondenceScanPanel(final JPanel jPanel, final CorrespondenceScanningInfo correspondenceScanningInfo) {
        jPanel.removeAll();
        JTabbedPane jTabbedPane = new JTabbedPane();
        CorrespondenceHeaderPanel correspondenceHeaderPanel = new CorrespondenceHeaderPanel(correspondenceScanningInfo, true);
        jTabbedPane.addTab("Correspondence", correspondenceHeaderPanel.getMainPanel());
        jPanel.add(jTabbedPane);
        correspondenceHeaderPanel.setListener(new CorrespondenceHeaderPanel.Listener(){

            @Override
            public void scanBatchCreated(ScanBatch scanBatch, IndexOptionEnum indexOptionEnum) {
                PanelPopupHelper.this.replaceMainPanelWithScanDetailPanel(jPanel, scanBatch, true, indexOptionEnum, correspondenceScanningInfo, false);
            }
        });
        GuiHelper.doLayoutHack((Component)jPanel);
    }

    void initIvrPanel(JPanel jPanel, IvrInfo ivrInfo) {
        jPanel.removeAll();
        JTabbedPane jTabbedPane = new JTabbedPane();
        IvrPanel ivrPanel = new IvrPanel(ivrInfo);
        jTabbedPane.addTab("IVR Info", (Component)ivrPanel.getMainPanel());
        jPanel.add(jTabbedPane);
        GuiHelper.doLayoutHack((Component)jPanel);
    }

    void initCreateScanBatchPanel(final JPanel jPanel) {
        Object object2;
        jPanel.removeAll();
        JTabbedPane jTabbedPane = new JTabbedPane();
        ScanHeaderPanel scanHeaderPanel = new ScanHeaderPanel(true);
        jTabbedPane.addTab("Scanning", scanHeaderPanel.getMainPanel());
        List list = ListX.create();
        for (Object object2 : User.selectAll()) {
            if (!object2.isCoder()) continue;
            list.add(object2);
        }
        AutoImportBatchProgressPanel autoImportBatchProgressPanel = new AutoImportBatchProgressPanel();
        jTabbedPane.addTab("Import", new ImportBatchPanel(list).getPanel());
        jTabbedPane.addTab("Stragglers", new StragglerPanel().getPanel());
        jTabbedPane.addTab("Progress", autoImportBatchProgressPanel.getPanel());
        jPanel.add(jTabbedPane);
        object2 = (FileMonitor)this._injector.getInstance(FileMonitor.class);
        ((FileMonitor)object2).setCoders(list);
        ((FileMonitor)object2).progressMonitors.addListener((Object)autoImportBatchProgressPanel);
        scanHeaderPanel.setListener(new ScanHeaderPanel.Listener(){

            @Override
            public void scanBatchCreated(ScanBatch scanBatch, IndexOptionEnum indexOptionEnum) {
                PanelPopupHelper.this.replaceMainPanelWithScanDetailPanel(jPanel, scanBatch, true, indexOptionEnum, null, true);
            }
        });
        GuiHelper.doLayoutHack((Component)jPanel);
    }

    private void popupPanel(JComponent jComponent, String string, String string2) {
        this.popupPanel(jComponent, string, null, string2);
    }

    private void popupPanel(JComponent jComponent, String string, Size size, String string2) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setBackground(Color.WHITE);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.setLayout(new BorderLayout());
        jFrame.setBackground(Color.WHITE);
        jFrame.add(jComponent);
        jFrame.setTitle(string);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PanelPopupHelper.this.logger.debug((Object)"frame/window listener windowClosed()");
                super.windowClosed(windowEvent);
            }
        });
        if (size == null) {
            jFrame.pack();
        } else {
            jFrame.setSize(size.asDimension());
        }
        if (StringX.isNotBlank((String)string2)) {
            jFrame.setName(string2);
            ((FrameStateMarshaller)DependencyInjector.getInstance(FrameStateMarshaller.class)).attach((Window)jFrame);
        }
        jFrame.setDefaultCloseOperation(2);
        jFrame.setVisible(true);
        WindowActivator.activateWindow((String)string);
        this.addVisibleFrame(jFrame);
    }

    public void addVisibleFrame(JFrame jFrame) {
        this._visibleWindows.add(jFrame);
        this._cleanupNeeded = true;
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PanelPopupHelper.this.purgeNonvisibleWindows();
                    }
                });
            }
        });
        this.purgeNonvisibleWindows();
        this.logger.debug((Object)"adding visible window count {} window {}", (Object)this.getVisibleWindows().size(), (Object)jFrame.getTitle());
    }

    private void purgeNonvisibleWindows() {
        for (Window window : this.getVisibleWindows()) {
            if (window != null && window.isVisible() && window.isDisplayable()) continue;
            String string = "";
            if (window instanceof JFrame) {
                JFrame jFrame = (JFrame)window;
                string = jFrame.getTitle();
            }
            string.toString();
            window.dispose();
            this._visibleWindows.remove(window);
            this.logger.debug((Object)"removing non-visible window count {} window {}", (Object)this.getVisibleWindows().size(), (Object)window);
        }
        int n = this.getVisibleWindows().size();
        if (n == 0 && this._cleanupNeeded) {
            this._cleanupNeeded = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelPopupHelper.this.logger.debug((Object)"doing gui cleanup");
                    ((ClientScanningDao)DependencyInjector.getInstance(ClientScanningDao.class)).resetSession();
                    for (int i = 1; i <= 1; ++i) {
                        PanelPopupHelper.this.logger.debug((Object)("before doing GC " + i));
                        SystemX.logMemoryUsage();
                        Runtime.getRuntime().gc();
                        PanelPopupHelper.this.logger.debug((Object)("after doing GC " + i));
                        SystemX.logMemoryUsage();
                    }
                }
            });
        }
    }

    public JFrame showDeveloperHelperPanel() {
        this._showDeveloperHelperFrame = true;
        this._developerHelperFrame = new JFrame();
        this._developerHelperFrame.setTitle("Standalone AHS Scanning App");
        DeveloperHelperPanel developerHelperPanel = (DeveloperHelperPanel)((Object)DependencyInjector.getInstance(DeveloperHelperPanel.class));
        this._developerHelperFrame.add((Component)((Object)developerHelperPanel));
        this._developerHelperFrame.pack();
        this._developerHelperFrame.setDefaultCloseOperation(2);
        this._developerHelperFrame.setVisible(true);
        return this._developerHelperFrame;
    }

    /*
     * WARNING - void declaration
     */
    void removeChildrenDescending(Component component) {
        try {
            int n;
            Object object;
            if (component instanceof Container) {
                object = (PropertyChangeListener[])component;
                for (int i = 0; i < ((Container)object).getComponentCount(); ++i) {
                    this.removeChildrenDescending(((Container)object).getComponent(i));
                }
                try {
                    ((Container)object).removeAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ((Container)object).setLayout(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (component instanceof JComboBox) {
                void var5_16;
                void propertyChangeListener;
                object = (JComboBox)component;
                try {
                    ((JComboBox)object).setModel(new DefaultComboBoxModel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EventListener[] eventListenerArray = ((JComboBox)object).getItemListeners();
                n = eventListenerArray.length;
                boolean i = false;
                while (propertyChangeListener < n) {
                    ItemListener itemListener = eventListenerArray[propertyChangeListener];
                    try {
                        ((JComboBox)object).removeItemListener(itemListener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++propertyChangeListener;
                }
                eventListenerArray = ((JComboBox)object).getActionListeners();
                n = eventListenerArray.length;
                boolean eventListener = false;
                while (var5_16 < n) {
                    EventListener eventListener2 = eventListenerArray[var5_16];
                    try {
                        ((JComboBox)object).removeActionListener((ActionListener)eventListener2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++var5_16;
                }
            }
            if (component instanceof JTable) {
                object = (JTable)component;
                ((JTable)object).setModel(new DefaultTableModel());
                ((JTable)object).setRowSorter(null);
            }
            if (component instanceof JViewport) {
                object = (JViewport)component;
                ((Component)object).toString();
            }
            for (PropertyChangeListener propertyChangeListener : component.getPropertyChangeListeners()) {
                try {
                    component.removePropertyChangeListener(propertyChangeListener);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (EventListener eventListener : component.getComponentListeners()) {
                try {
                    component.removeComponentListener((ComponentListener)eventListener);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (component instanceof JComponent) {
                void var5_20;
                object = (JComponent)component;
                Object field = ((JComponent)object).getAncestorListeners();
                n = ((AncestorListener[])field).length;
                boolean bl = false;
                while (var5_20 < n) {
                    AncestorListener ancestorListener = field[var5_20];
                    ((JComponent)object).removeAncestorListener(ancestorListener);
                    ++var5_20;
                }
                try {
                    field = object.getClass().getField("listenerList");
                    ((Field)field).setAccessible(true);
                    ((Field)field).set(object, null);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            this.logger.warn((Object)"error removing {} - {}", component.getClass(), (Object)component, (Object)exception);
        }
    }

    private void replaceMainPanelWithScanDetailPanel(final JPanel jPanel, ScanBatch scanBatch, boolean bl, IndexOptionEnum indexOptionEnum, CorrespondenceScanningInfo correspondenceScanningInfo, final boolean bl2) {
        ScanDetailPanel scanDetailPanel = new ScanDetailPanel(scanBatch, bl, indexOptionEnum, correspondenceScanningInfo);
        jPanel.removeAll();
        jPanel.add((Component)scanDetailPanel.getMainPanel());
        scanDetailPanel.setListener(new ScanDetailPanel.Listener(){

            @Override
            public void closing(boolean bl) {
                Window window = SwingUtilities.getWindowAncestor(jPanel);
                window.setVisible(false);
                window.dispose();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PanelPopupHelper.this.purgeNonvisibleWindows();
                        if (bl2) {
                            PanelPopupHelper.this.showCreateScanBatchPanel();
                        }
                    }
                });
            }
        });
        GuiHelper.doLayoutHack((Component)jPanel);
    }
}

