/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.scanning.app.client.beans.IvrInfo;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.model3.io.IOHelper;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.swing.GuiHelper;
import net.model3x.swing.M3Panel;

public class IvrPanel {
    private static final Log logger = LogHelper.getLog();
    M3Panel _mainPanel;
    IvrInfo _ivrInfo;
    boolean showCopyButton = true;
    String currencyPrefix = "$ ";

    public static void main(String[] stringArray) throws Exception {
        new SimpleLoggingConfigurator().addEclipseConsoleAppender();
        UIManager.setLookAndFeel(new MetalLookAndFeel());
        IvrInfo ivrInfo = new IvrInfo("John Smith", "0123456789012", new BigDecimal("1.23"), "SINY", "DEMO", "SID-987654321", new Date(), new BigDecimal("3.21"));
        IvrPanel ivrPanel = new IvrPanel(ivrInfo);
        ivrPanel.init();
        GuiHelper.createFrame((JComponent)ivrPanel._mainPanel);
    }

    public IvrPanel(IvrInfo ivrInfo) {
        this._ivrInfo = ivrInfo;
        this.init();
    }

    void init() {
        this.initComponents();
    }

    void initComponents() {
        this._mainPanel = new M3Panel("ins 50", "[]50:push[]70:push[]", "30:push");
        Font font = new Font("Serif", 0, 20);
        ImageIcon imageIcon = this.getButtonIcon("ivr-copy.png");
        String string = ":";
        String string2 = "Patient Name";
        JLabel jLabel = new JLabel(string2 + string);
        jLabel.setFont(font);
        JTextField jTextField = this.createTextField(this._ivrInfo.getPatientName(), font);
        JButton jButton = this.createCopyButton(jTextField, string2, imageIcon);
        String string3 = "Patient ID";
        JLabel jLabel2 = new JLabel(string3 + string);
        jLabel2.setFont(font);
        JTextField jTextField2 = this.createTextField(this._ivrInfo.getPatientID(), font);
        JButton jButton2 = this.createCopyButton(jTextField2, string3, imageIcon);
        String string4 = "Account Balance";
        JLabel jLabel3 = new JLabel(string4 + string);
        jLabel3.setFont(font);
        JTextField jTextField3 = this.createTextField(this.currencyPrefix + this._ivrInfo.getAccountBalance(), font);
        JButton jButton3 = this.createCopyButton(jTextField3, string4, imageIcon);
        String string5 = "Company";
        JLabel jLabel4 = new JLabel(string5 + string);
        jLabel4.setFont(font);
        JTextField jTextField4 = this.createTextField(this._ivrInfo.getCompany(), font);
        JButton jButton4 = this.createCopyButton(jTextField4, string5, imageIcon);
        String string6 = "Client";
        JLabel jLabel5 = new JLabel(string6 + string);
        jLabel5.setFont(font);
        JTextField jTextField5 = this.createTextField(this._ivrInfo.getDivision(), font);
        JButton jButton5 = this.createCopyButton(jTextField5, string6, imageIcon);
        String string7 = "Statement ID";
        JLabel jLabel6 = new JLabel(string7 + string);
        jLabel6.setFont(font);
        JTextField jTextField6 = this.createTextField(this._ivrInfo.getStatementID(), font);
        JButton jButton6 = this.createCopyButton(jTextField6, string7, imageIcon);
        String string8 = "Last Payment Date";
        JLabel jLabel7 = new JLabel(string8 + string);
        jLabel7.setFont(font);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy");
        String string9 = simpleDateFormat.format(this._ivrInfo.getLastPaymentDate());
        JTextField jTextField7 = this.createTextField(string9, font);
        JButton jButton7 = this.createCopyButton(jTextField7, string8, imageIcon);
        String string10 = "Last Payment Amount";
        JLabel jLabel8 = new JLabel(string10 + string);
        jLabel8.setFont(font);
        JTextField jTextField8 = this.createTextField(this.currencyPrefix + this._ivrInfo.getLastPaymentAmount(), font);
        JButton jButton8 = this.createCopyButton(jTextField8, string10, imageIcon);
        this._mainPanel.add((Component)jLabel, (Object)"left, gap");
        this._mainPanel.add((Component)jTextField, (Object)"left");
        this._mainPanel.add((Component)jButton, (Object)"wrap, spanx, gap unrelated");
        this._mainPanel.add((Component)jLabel2, (Object)"left");
        this._mainPanel.add((Component)jTextField2, (Object)"left");
        this._mainPanel.add((Component)jButton2, (Object)"wrap, spanx, gap unrelated");
        this._mainPanel.add((Component)jLabel6, (Object)"left");
        this._mainPanel.add((Component)jTextField6, (Object)"left");
        this._mainPanel.add((Component)jButton6, (Object)"wrap, spanx, gap unrelated");
        this._mainPanel.add((Component)jLabel3, (Object)"left");
        this._mainPanel.add((Component)jTextField3, (Object)"left");
        this._mainPanel.add((Component)jButton3, (Object)"wrap, spanx, gap unrelated");
        this._mainPanel.add((Component)jLabel7, (Object)"left");
        this._mainPanel.add((Component)jTextField7, (Object)"left");
        this._mainPanel.add((Component)jButton7, (Object)"wrap, spanx, gap unrelated");
        this._mainPanel.add((Component)jLabel8, (Object)"left");
        this._mainPanel.add((Component)jTextField8, (Object)"left");
        this._mainPanel.add((Component)jButton8, (Object)"wrap, spanx, gap unrelated");
        this._mainPanel.add((Component)jLabel4, (Object)"left");
        this._mainPanel.add((Component)jTextField4, (Object)"left");
        this._mainPanel.add((Component)jButton4, (Object)"wrap, spanx, gap unrelated");
        this._mainPanel.add((Component)jLabel5, (Object)"left");
        this._mainPanel.add((Component)jTextField5, (Object)"left");
        this._mainPanel.add((Component)jButton5, (Object)"wrap, spanx, gap unrelated");
    }

    JButton createCopyButton(final JTextField jTextField, String string, ImageIcon imageIcon) {
        JButton jButton = new JButton("Copy");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                if (jTextField.getText().startsWith(IvrPanel.this.currencyPrefix)) {
                    n = IvrPanel.this.currencyPrefix.length();
                }
                jTextField.setSelectionStart(n);
                jTextField.setSelectionEnd(jTextField.getText().length());
                jTextField.copy();
            }
        });
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
            String string2 = "Copy " + string + " to Clipboard";
            jButton.setToolTipText(string2);
            jButton.setText("");
        }
        jButton.setFocusable(false);
        jButton.setBackground(jTextField.getBackground());
        jButton.setBorder(null);
        jButton.setVisible(this.showCopyButton);
        return jButton;
    }

    JTextField createTextField(String string, Font font) {
        JTextField jTextField = new JTextField(string);
        jTextField.setEnabled(true);
        jTextField.setEditable(false);
        jTextField.setBorder(null);
        jTextField.setBackground(null);
        jTextField.setFont(font);
        return jTextField;
    }

    ImageIcon getButtonIcon(String string) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            logger.warn((Object)"unable to load image {}", (Object)string);
            return null;
        }
        return new ImageIcon(IOHelper.readFully((InputStream)inputStream));
    }

    M3Panel getMainPanel() {
        return this._mainPanel;
    }
}

