/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.BlankPageIndexer;
import com.ahsrcm.client.scanning.FixedPageCountIndexer;
import com.ahsrcm.client.scanning.ImageIndexer;
import com.ahsrcm.client.scanning.NoIndexingImageIndexer;
import com.ahsrcm.scanning.device.Feeder;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public enum IndexOptionEnum {
    None{

        @Override
        public void applySettings(Feeder feeder) {
        }

        @Override
        public ImageIndexer getImageIndexer() {
            return (ImageIndexer)DependencyInjector.getInstance(NoIndexingImageIndexer.class);
        }

        @Override
        public String getId() {
            return "None";
        }
    }
    ,
    BlankPage{

        @Override
        public void applySettings(Feeder feeder) {
            ((BlankPageIndexer)this.getImageIndexer()).isDuplex(Feeder.Duplex.equals((Object)feeder));
        }

        @Override
        public ImageIndexer getImageIndexer() {
            return (ImageIndexer)DependencyInjector.getInstance(BlankPageIndexer.class);
        }

        @Override
        public String getId() {
            return "Blank Page";
        }
    }
    ,
    OnePagePerPatientFile{

        @Override
        public void applySettings(Feeder feeder) {
            ((FixedPageCountIndexer)this.getImageIndexer()).setPagesPerPatientFile(1);
        }

        @Override
        public ImageIndexer getImageIndexer() {
            return (ImageIndexer)DependencyInjector.getInstance(FixedPageCountIndexer.class);
        }

        @Override
        public String getId() {
            return "1 Page per Patient File";
        }
    }
    ,
    TwoPagePerPatientFile{

        @Override
        public void applySettings(Feeder feeder) {
            ((FixedPageCountIndexer)this.getImageIndexer()).setPagesPerPatientFile(2);
        }

        @Override
        public ImageIndexer getImageIndexer() {
            return (ImageIndexer)DependencyInjector.getInstance(FixedPageCountIndexer.class);
        }

        @Override
        public String getId() {
            return "2 Page per Patient File";
        }
    }
    ,
    ThreePagePerPatientFile{

        @Override
        public void applySettings(Feeder feeder) {
            ((FixedPageCountIndexer)this.getImageIndexer()).setPagesPerPatientFile(3);
        }

        @Override
        public ImageIndexer getImageIndexer() {
            return (ImageIndexer)DependencyInjector.getInstance(FixedPageCountIndexer.class);
        }

        @Override
        public String getId() {
            return "3 Page per Patient File";
        }
    };

    private static final Logger logger;

    public abstract void applySettings(Feeder var1);

    public abstract ImageIndexer getImageIndexer();

    public abstract String getId();

    public static IndexOptionEnum enumFromSelectorString(String string) {
        IndexOptionEnum indexOptionEnum = null;
        if ("None".equalsIgnoreCase(string)) {
            indexOptionEnum = None;
        } else if ("Blank Page".equalsIgnoreCase(string)) {
            indexOptionEnum = BlankPage;
        } else if ("1 Page per Patient File".equalsIgnoreCase(string)) {
            indexOptionEnum = OnePagePerPatientFile;
        } else if ("2 Page per Patient File".equalsIgnoreCase(string)) {
            indexOptionEnum = TwoPagePerPatientFile;
        } else if ("3 Page per Patient File".equalsIgnoreCase(string)) {
            indexOptionEnum = ThreePagePerPatientFile;
        } else {
            logger.error((Object)("don't know how to handle '" + string + "'"));
        }
        return indexOptionEnum;
    }

    public static String[] getIdKeySet() {
        String[] stringArray = new String[IndexOptionEnum.values().length];
        int n = 0;
        for (IndexOptionEnum indexOptionEnum : IndexOptionEnum.values()) {
            stringArray[n] = indexOptionEnum.getId();
            ++n;
        }
        return stringArray;
    }

    static {
        logger = LoggerHelper.getLogger();
    }
}

