/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.CenteringLayout;
import com.ahsrcm.client.scanning.gui.Magnifier;
import com.ahsrcm.core.scanning.gui.BufferedImageProxy;
import com.ahsrcm.core.scanning.gui.ImageProxy;
import com.ahsrcm.core.scanning.gui.ImageProxyPopupFactory;
import com.ahsrcm.core.scanning.gui.ScannedImageProxy;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.util.ExtensionFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.model3.guice.DependencyInjector;
import net.model3.imaging.Size;
import net.model3.io.IOHelper;
import net.model3.lang.ClassX;
import net.model3.lang.SystemX;
import net.model3.logging.LogHelper;
import net.model3.logging.Logger;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.newfile.File;
import net.model3x.swing.uistate.FrameStateMarshaller;
import org.jdesktop.layout.GroupLayout;

public class ImageViewer
extends JPanel {
    private static final double ZOOM_COEFFICIENT = 1.5;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogHelper.getLog();
    private static final JFileChooser _fileChooser = new JFileChooser();
    private static final ExtensionFileFilter _jpegFileFilter;
    private static final ExtensionFileFilter _pngFileFilter;
    static Robot _roboto;
    private JButton _closeButton;
    private JButton _newPatientFileButton;
    private JButton _nextPage;
    private JLabel _pageCountLabel;
    private JButton _previousPage;
    private JButton _rotateClockwise;
    private JButton _rotateCounterClockwise;
    private JScrollPane _scrollpane;
    private JToolBar _toolbar;
    private JPanel _viewport;
    private JButton _workflowHistoryButton;
    private JButton _zoomIn;
    private JButton _zoomOut;
    private int _zoomFactor = 0;
    private int _defaultZoomFactor = 1;
    private ImageProxy _imageProxy;
    private Size _initialSize;
    private List<ImageProxy> _imageCollection;
    private Magnifier _imageMagnifier;
    private Point _dragMouseStart;
    private Point _dragViewportStart;
    private JFrame _parentFrame;
    private ImageProxyPopupFactory _popupFactory;
    private Font _pageXofYFont;
    private ScannedImageProxy.ProxyListener _proxyListener;
    private final Listener _listener;
    private NewPatientFileActionHandler _newPatientFileActionHandler = new NewPatientFileActionHandler(){

        @Override
        public void processNewPatientFile(int n) {
        }
    };
    private AdvancedPrintingActionHandler _advancedPrintingActionHandler = () -> {};

    static void installExecutable(String string, boolean bl) {
        try {
            int n;
            InputStream inputStream = ClassX.getResourceAsStream((String)string);
            String string2 = "c:/windows/" + string;
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((OutputStream)fileOutputStream).close();
            if (bl) {
                Runtime.getRuntime().exec(string2);
            }
        }
        catch (Exception exception) {
            logger.info((Object)exception);
        }
    }

    public static ImageViewer newInstance() {
        JFrame jFrame = new JFrame();
        ImageViewer imageViewer = new ImageViewer();
        jFrame.add(imageViewer);
        jFrame.setSize(800, 600);
        imageViewer.setParentFrame(jFrame);
        return imageViewer;
    }

    public static void main(String[] stringArray) {
        new SimpleLoggingConfigurator().addConsoleAppender();
        ImageViewer imageViewer = ImageViewer.showImage((ImageProxy)new BufferedImageProxy(new File("test.tif"), "test", "test", null), null, null);
        imageViewer._parentFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(1);
            }
        });
    }

    public JButton getCloseButton() {
        return this._closeButton;
    }

    public static ImageViewer showImage(ImageProxy imageProxy, List<ImageProxy> list, ImageProxyPopupFactory imageProxyPopupFactory) {
        JFrame jFrame = new JFrame();
        ImageViewer imageViewer = new ImageViewer();
        jFrame.add(imageViewer);
        jFrame.setSize(800, 600);
        imageViewer.setParentFrame(jFrame);
        imageViewer.setPopupFactory(imageProxyPopupFactory);
        imageViewer.setImageCollection(list);
        imageViewer.resetImage(imageProxy);
        jFrame.setName("image-viewer");
        ((FrameStateMarshaller)DependencyInjector.getInstance(FrameStateMarshaller.class)).attach((Window)jFrame);
        jFrame.setVisible(true);
        return imageViewer;
    }

    public static void saveImage(Component component, ImageProxy imageProxy) {
        File file = new File(_fileChooser.getCurrentDirectory(), imageProxy.getUuid());
        _fileChooser.setSelectedFile(file.asFile());
        int n = _fileChooser.showSaveDialog(component);
        if (n == 0) {
            File file2 = new File(_fileChooser.getSelectedFile());
            ExtensionFileFilter extensionFileFilter = _fileChooser.getFileFilter() instanceof ExtensionFileFilter ? (ExtensionFileFilter)_fileChooser.getFileFilter() : _jpegFileFilter;
            file2 = new File(extensionFileFilter.addExtensionIfNecessary(file2.asFile()));
            String string = extensionFileFilter == _pngFileFilter ? "png" : "jpeg";
            try {
                ImageIO.write((RenderedImage)imageProxy.getImage(), string, file2.asFile());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(component, "Unable to save image. " + exception.getMessage());
            }
        }
    }

    static void setToolbarIcon(JButton jButton, String string) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            logger.warn((Object)"unable to load image {}", (Object)string);
        } else {
            ImageIcon imageIcon = new ImageIcon(IOHelper.readFully((InputStream)inputStream));
            jButton.setToolTipText(jButton.getText());
            jButton.setText("");
            jButton.setIcon(imageIcon);
        }
        jButton.setFocusable(false);
    }

    public ImageViewer() {
        this(1, null);
    }

    public ImageViewer(Listener listener) {
        this(1, listener);
    }

    public ImageViewer(int n, Listener listener) {
        this._defaultZoomFactor = n;
        this._listener = listener;
        this.setBackground(Color.white);
        this.initComponents();
        this._workflowHistoryButton.setVisible(false);
        ImageViewer.setToolbarIcon(this._zoomIn, "zoom-in.png");
        ImageViewer.setToolbarIcon(this._zoomOut, "zoom-out.png");
        ImageViewer.setToolbarIcon(this._rotateClockwise, "rotate-cw.png");
        ImageViewer.setToolbarIcon(this._rotateCounterClockwise, "rotate-ccw.png");
        ImageViewer.setToolbarIcon(this._previousPage, "previous.png");
        ImageViewer.setToolbarIcon(this._nextPage, "next.png");
        ImageViewer.setToolbarIcon(this._workflowHistoryButton, "url-history-icon.png");
        ImageViewer.setToolbarIcon(this._newPatientFileButton, "File-New.png");
        this.getToolbar().addSeparator();
        this.getToolbar().add(this.createHotkeyToolbarButton(83, "Snap Windows to Preset Positions", "windows.png"));
        this.getToolbar().add(this.createHotkeyToolbarButton(65, "Save Window Positions", "save.png"));
        this.getToolbar().add(this.createHotkeyToolbarButton(67, "Clear Saved Window Positions", "delete.png"));
        this.getToolbar().addSeparator();
        this.getToolbar().add(this.createRedactingButton());
        this.getToolbar().add(this.createAdvancedPrintingButton());
        this.getToolbar().add(this.createCalculatorButton());
        this.getToolbar().addSeparator();
        this.getToolbar().add(this._newPatientFileButton);
        this._imageMagnifier = new Magnifier(null){
            private static final long serialVersionUID = 7297413406730082895L;

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Color color = graphics.getColor();
                Font font = graphics.getFont();
                if (ImageViewer.this._pageXofYFont == null) {
                    ImageViewer.this._pageXofYFont = new Font("Tahoma", 1, 12);
                }
                graphics.setFont(ImageViewer.this._pageXofYFont);
                graphics.drawString("Page", 10, 25);
                graphics.drawString(ImageViewer.this.getCurrentImageIndex() + 1 + " of " + ImageViewer.this.getPageCount(), 10, 40);
                graphics.drawString("File #", 10, 60);
                graphics.drawString("" + ImageViewer.this.getCurrentPatientFileNumber(), 10, 75);
                graphics.setColor(color);
                graphics.setFont(font);
            }
        };
        this._imageMagnifier.setOpaque(true);
        this._viewport.setLayout(new CenteringLayout());
        this._viewport.add(this._imageMagnifier);
        this._imageMagnifier.setCursor(new Cursor(12));
        this._imageMagnifier.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ImageViewer.this._dragViewportStart = ImageViewer.this._scrollpane.getViewport().getViewPosition();
                ImageViewer.this._dragMouseStart = mouseEvent.getLocationOnScreen();
            }
        });
        this._imageMagnifier.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n;
                Point point = new Point();
                point.x = ((ImageViewer)ImageViewer.this)._dragViewportStart.x + (((ImageViewer)ImageViewer.this)._dragMouseStart.x - mouseEvent.getXOnScreen());
                point.y = ((ImageViewer)ImageViewer.this)._dragViewportStart.y + (((ImageViewer)ImageViewer.this)._dragMouseStart.y - mouseEvent.getYOnScreen());
                Rectangle rectangle = ImageViewer.this._scrollpane.getViewport().getViewRect();
                int n2 = ImageViewer.this._imageMagnifier.getWidth() - rectangle.width;
                if (point.x > n2) {
                    point.x = n2;
                }
                if (point.y > (n = ImageViewer.this._imageMagnifier.getHeight() - rectangle.height)) {
                    point.y = n;
                }
                if (point.x < 0) {
                    point.x = 0;
                }
                if (point.y < 0) {
                    point.y = 0;
                }
                ImageViewer.this._scrollpane.getViewport().setViewPosition(point);
            }
        });
        this._imageMagnifier.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3 && ImageViewer.this._popupFactory != null) {
                    JPopupMenu jPopupMenu = ImageViewer.this._popupFactory.createPopup(ImageViewer.this._imageProxy);
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this._scrollpane.setBackground(Color.WHITE);
        this._viewport.setBackground(Color.WHITE);
        this._closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.getWindowAncestor(ImageViewer.this._closeButton).dispose();
            }
        });
        this._closeButton.setToolTipText("Close window");
        this._workflowHistoryButton.setToolTipText("Show workflow history");
        this._rotateClockwise.setToolTipText("Rotate image clockwise");
        this._rotateCounterClockwise.setToolTipText("Rotate image counter-clockwise");
        this._zoomIn.setToolTipText("Zoom into the image");
        this._zoomOut.setToolTipText("Zoom out from the image");
        this._newPatientFileButton.setToolTipText("Create New Patient File From This Image");
    }

    public void setDefaultZoomFactor(int n) {
        this._defaultZoomFactor = n;
    }

    public void showCreateNewPatientFileButton(boolean bl) {
        this._newPatientFileButton.setVisible(bl);
    }

    public void setCreateNewPatientFileButtonActionHandler(NewPatientFileActionHandler newPatientFileActionHandler) {
        this._newPatientFileActionHandler = newPatientFileActionHandler;
    }

    public void setAdvancedPrintingActionHandler(AdvancedPrintingActionHandler advancedPrintingActionHandler) {
        this._advancedPrintingActionHandler = advancedPrintingActionHandler;
    }

    public void snapWindowsToPresets() {
        this.pressHotkey(83);
    }

    final JButton createCalculatorButton() {
        JButton jButton = new JButton();
        jButton.setBackground(Color.WHITE);
        jButton.setIcon(new ImageIcon(ClassX.getResource((String)"calculator.png")));
        jButton.setToolTipText("Open Calculator");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Runtime.getRuntime().exec("calc.exe");
                }
                catch (Exception exception) {
                    logger.debug((Object)"unable to start calc.exe", (Object)exception);
                }
            }
        });
        return jButton;
    }

    final JButton createRedactingButton() {
        JButton jButton = new JButton();
        jButton.setBackground(Color.WHITE);
        jButton.setToolTipText("Print with redacting");
        jButton.setIcon(new ImageIcon(ClassX.getResource((String)"print.png")));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){
                    {
                        this.setName("redacting-" + this.getId());
                        this.start();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            ScannedImage scannedImage = (ScannedImage)ImageViewer.this._imageProxy.getReferent();
                            File file = scannedImage.getImageFile();
                            File file2 = new File(java.io.File.createTempFile("prefix", "temp.tiff"));
                            file.copyFileTo(file2);
                            String[] stringArray = new String[]{"c:\\windows\\run-imageviewer.exe", file2.getCanonicalPath()};
                            try {
                                Process process = Runtime.getRuntime().exec(stringArray);
                                int n = process.waitFor();
                                logger.debug((Object)"exit code = {}", (Object)n);
                            }
                            catch (Exception exception) {
                                logger.error((Object)exception);
                            }
                            finally {
                                file2.delete();
                            }
                        }
                        catch (Exception exception) {
                            logger.error((Object)exception);
                        }
                    }
                };
            }
        });
        return jButton;
    }

    final JButton createAdvancedPrintingButton() {
        JButton jButton = new JButton();
        jButton.setBackground(Color.WHITE);
        jButton.setToolTipText("Advanced Printing");
        jButton.setIcon(new ImageIcon(ClassX.getResource((String)"print-advanced.png")));
        jButton.addActionListener(actionEvent -> this._advancedPrintingActionHandler.processAdvancedPrinting());
        return jButton;
    }

    final JButton createHotkeyToolbarButton(final int n, String string, String string2) {
        JButton jButton = new JButton();
        jButton.setBackground(Color.white);
        jButton.setToolTipText(string);
        jButton.setIcon(new ImageIcon(ClassX.getResource((String)string2)));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.pressHotkey(n);
            }
        });
        return jButton;
    }

    void pressHotkey(int n) {
        _roboto.keyPress(16);
        _roboto.keyPress(17);
        _roboto.keyPress(n);
        _roboto.delay(300);
        _roboto.keyRelease(n);
        _roboto.keyRelease(17);
        _roboto.keyRelease(16);
    }

    public ImageViewer(ImageProxy imageProxy) {
        this();
        this._imageProxy = imageProxy;
    }

    public void setPopupFactory(ImageProxyPopupFactory imageProxyPopupFactory) {
        this._popupFactory = imageProxyPopupFactory;
    }

    private void initComponents() {
        this._toolbar = new JToolBar();
        this._zoomIn = new JButton();
        this._zoomOut = new JButton();
        this._rotateClockwise = new JButton();
        this._rotateCounterClockwise = new JButton();
        this._previousPage = new JButton();
        this._nextPage = new JButton();
        this._closeButton = new JButton();
        this._workflowHistoryButton = new JButton();
        this._pageCountLabel = new JLabel();
        this._newPatientFileButton = new JButton();
        this._scrollpane = new JScrollPane();
        this._viewport = new JPanel();
        this.setBackground(Color.white);
        this._toolbar.setBackground(Color.white);
        this._toolbar.setOrientation(1);
        this._zoomIn.setBackground(Color.white);
        this._zoomIn.setText("Zoom In");
        this._zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._zoomInActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._zoomIn);
        this._zoomOut.setBackground(Color.white);
        this._zoomOut.setText("Zoom Out");
        this._zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._zoomOutActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._zoomOut);
        this._rotateClockwise.setBackground(Color.white);
        this._rotateClockwise.setText("Rotate Clockwise");
        this._rotateClockwise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._rotateClockwiseActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._rotateClockwise);
        this._rotateCounterClockwise.setBackground(Color.white);
        this._rotateCounterClockwise.setText("Rotate Counter Clockwise");
        this._rotateCounterClockwise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._rotateCounterClockwiseActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._rotateCounterClockwise);
        this._previousPage.setBackground(Color.white);
        this._previousPage.setText("Previous Page");
        this._previousPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._previousPageActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._previousPage);
        this._nextPage.setBackground(Color.white);
        this._nextPage.setText("Next Page");
        this._nextPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._nextPageActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._nextPage);
        this._closeButton.setBackground(new Color(255, 255, 255));
        this._closeButton.setText("X");
        this._toolbar.add(this._closeButton);
        this._workflowHistoryButton.setBackground(new Color(255, 255, 255));
        this._workflowHistoryButton.setText("W");
        this._toolbar.add(this._workflowHistoryButton);
        this._pageCountLabel.setText("   page x of y");
        this._toolbar.add(this._pageCountLabel);
        this._newPatientFileButton.setText("New Patient File");
        this._newPatientFileButton.setFocusable(false);
        this._newPatientFileButton.setHorizontalTextPosition(0);
        this._newPatientFileButton.setVerticalTextPosition(3);
        this._newPatientFileButton.setVisible(false);
        this._newPatientFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._newPatientFileButtonActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._newPatientFileButton);
        this._scrollpane.setBackground(Color.white);
        this._scrollpane.setBorder(null);
        GroupLayout groupLayout = new GroupLayout((Container)this._viewport);
        this._viewport.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 537, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 448, Short.MAX_VALUE));
        this._scrollpane.setViewportView(this._viewport);
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this._toolbar, -2, 26, -2).addPreferredGap(0).add((Component)this._scrollpane, -1, 537, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this._toolbar, -2, 437, -2).addContainerGap(-1, Short.MAX_VALUE)).add(2, (Component)this._scrollpane, -2, 0, Short.MAX_VALUE));
    }

    private void _nextPageActionPerformed(ActionEvent actionEvent) {
        this.nextPage();
    }

    private void _previousPageActionPerformed(ActionEvent actionEvent) {
        this.previousPage();
    }

    private void _zoomInActionPerformed(ActionEvent actionEvent) {
        this.zoomIn();
    }

    private void _zoomOutActionPerformed(ActionEvent actionEvent) {
        this.zoomOut();
    }

    private void _rotateClockwiseActionPerformed(ActionEvent actionEvent) {
        this._imageProxy.setRotation(this._imageProxy.getRotation().rotateClockwise());
        if (this._proxyListener == null) {
            this.resetImage();
        }
    }

    private void _rotateCounterClockwiseActionPerformed(ActionEvent actionEvent) {
        this._imageProxy.setRotation(this._imageProxy.getRotation().rotateCounterClockwise());
        if (this._proxyListener == null) {
            this.resetImage();
        }
    }

    private void _newPatientFileButtonActionPerformed(ActionEvent actionEvent) {
        this._newPatientFileActionHandler.processNewPatientFile(this.getCurrentImageIndex());
    }

    void resetImage() {
        double d = this._zoomFactor > 0 ? Math.pow(1.5, this._zoomFactor) : (this._zoomFactor < 0 ? Math.pow(0.6666666666666666, Math.abs(this._zoomFactor)) : 1.0);
        Size size = this._initialSize.scale(d);
        this._imageMagnifier.setImageProxy(this._imageProxy);
        this._imageMagnifier.setSize(size.asDimension());
        this._imageMagnifier.setPreferredSize(size.asDimension());
        this._scrollpane.invalidate();
        this._scrollpane.repaint();
        this._scrollpane.getViewport().removeAll();
        this._scrollpane.getViewport().add(this._imageMagnifier);
        logger.debug((Object)"image size set to {}", (Object)size);
        boolean bl = this._imageCollection != null && this._imageCollection.indexOf(this._imageProxy) >= 0;
        this._nextPage.setVisible(bl);
        this._previousPage.setVisible(bl);
        if (this._parentFrame != null) {
            this._parentFrame.setTitle(this._imageProxy.getTitle());
        }
    }

    public void zoomIn() {
        ++this._zoomFactor;
        this.resetImage();
    }

    public void zoomOut() {
        --this._zoomFactor;
        this.resetImage();
    }

    public void nextPage() {
        this.incrementDecrementImage(1);
    }

    public void previousPage() {
        this.incrementDecrementImage(-1);
    }

    public void setImageCollection(List<ImageProxy> list) {
        this._imageCollection = list;
    }

    public int getCurrentImageIndex() {
        if (this._imageCollection == null) {
            return 0;
        }
        return this._imageCollection.indexOf(this._imageProxy);
    }

    public long getCurrentPatientFileNumber() {
        try {
            return (Long)((ScannedImage)this._imageProxy.getReferent()).patientFileId.get();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public int getPageCount() {
        if (this._imageCollection == null) {
            return 1;
        }
        return this._imageCollection.size();
    }

    void incrementDecrementImage(int n) {
        if (this._imageCollection == null) {
            return;
        }
        int n2 = this._imageCollection.indexOf(this._imageProxy);
        if (n2 == -1) {
            return;
        }
        int n3 = 0;
        int n4 = this._imageCollection.size() - 1;
        if ((n2 += n) < 0) {
            n2 = n4;
        } else if (n2 > n4) {
            n2 = n3;
        }
        this.resetImage(this._imageCollection.get(n2));
    }

    public final JToolBar getToolbar() {
        return this._toolbar;
    }

    public void resetImage(ImageProxy imageProxy) {
        Size size = imageProxy.getImageSize();
        if (size.getHeight() > 600 || size.getWidth() > 600) {
            size = new Size(600, 600);
        }
        this.resetImage(imageProxy, size);
        this._pageCountLabel.setVisible(false);
        this._scrollpane.getViewport().setViewPosition(new Point(0, 0));
    }

    int getCollectionSize() {
        if (this._imageCollection == null) {
            return 1;
        }
        return this._imageCollection.size();
    }

    void resetImage(ImageProxy imageProxy, Size size) {
        if (imageProxy != this._imageProxy) {
            if (this._proxyListener != null) {
                ((ScannedImageProxy)this._imageProxy).removeListener(this._proxyListener);
            }
            this._imageProxy = imageProxy;
            this._imageMagnifier.setImageProxy(this._imageProxy);
            this._proxyListener = null;
            if (this._imageProxy instanceof ScannedImageProxy) {
                this._proxyListener = new ScannedImageProxy.ProxyListener(){

                    public void imageHasChanged() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImageViewer.this.resetImage();
                            }
                        });
                    }
                };
                ((ScannedImageProxy)this._imageProxy).addListener(this._proxyListener);
            }
            if (this._listener != null) {
                this._listener.imageChanged();
            }
        }
        this._zoomFactor = this._defaultZoomFactor;
        this._initialSize = size == null ? imageProxy.getImageSize() : size;
        this.resetImage();
        imageProxy.fullSizeViewEvent();
    }

    public void flushImages() {
        if (this._imageMagnifier != null) {
            this._imageMagnifier.flushImages();
            this._imageMagnifier = null;
            try {
                this._viewport.remove(this._imageMagnifier);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setParentFrame(JFrame jFrame) {
        this._parentFrame = jFrame;
    }

    public ImageProxyPopupFactory getPopupFactory() {
        return this._popupFactory;
    }

    public ImageProxy getCurrentImage() {
        return this._imageProxy;
    }

    public JButton getWorkflowHistoryButton() {
        return this._workflowHistoryButton;
    }

    static {
        try {
            _roboto = new Robot();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        _jpegFileFilter = new ExtensionFileFilter("jpeg file");
        _jpegFileFilter.addExtension(".jpeg");
        _jpegFileFilter.addExtension(".jpg");
        _pngFileFilter = new ExtensionFileFilter("png file");
        _pngFileFilter.addExtension(".png");
        _fileChooser.addChoosableFileFilter((FileFilter)_jpegFileFilter);
        _fileChooser.addChoosableFileFilter((FileFilter)_pngFileFilter);
        if (SystemX.isWindows()) {
            ImageViewer.installExecutable("snapit.exe", true);
            ImageViewer.installExecutable("run-imageviewer.exe", false);
        }
    }

    public static interface Listener {
        public void imageChanged();
    }

    public static interface AdvancedPrintingActionHandler {
        public void processAdvancedPrinting();
    }

    public static interface NewPatientFileActionHandler {
        public void processNewPatientFile(int var1);
    }
}

