/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import net.model3.bean.converters.Converter;
import net.model3.bean.converters.ConverterAdapter;
import net.model3.collections.CollectionX;
import net.model3.collections.ListX;

public class EntityComboBoxModel<T>
extends AbstractListModel
implements ComboBoxModel {
    private static final long serialVersionUID = 1L;
    private static final String NULL_TEXT = "";
    private List<String> _visualItems = new ArrayList<String>();
    private List<T> _entities = new ArrayList<T>();
    private String _selectedItem;
    private T _selectedEntity;
    private Converter<T> _converter = new ConverterAdapter();
    private boolean _nullable;
    private int _nullableOffset;
    private T _default;
    private boolean _constructorCompleted = false;

    public static <U> EntityComboBoxModel<U> create() {
        return new EntityComboBoxModel(new ArrayList());
    }

    public EntityComboBoxModel(T[] TArray) {
        this(CollectionX.toList((Object[])TArray));
    }

    public EntityComboBoxModel() {
        this(ListX.create());
    }

    public EntityComboBoxModel(List<T> list) {
        this.setNullable(false);
        this.setItems(list);
        this._constructorCompleted = true;
        this.resetVisuals();
    }

    public void setConverter(Converter<T> converter) {
        this._converter = converter;
        this.resetVisuals();
        this.fireEverythingHasChanged();
    }

    public void addEntity(T t) {
        if (t != null) {
            this._entities.add(t);
        }
    }

    public List<T> getEntities() {
        return this._entities;
    }

    @Override
    public int getSize() {
        return this._entities.size() + this._nullableOffset;
    }

    public void setNullable(boolean bl) {
        this._nullable = bl;
        this._nullableOffset = this._nullable ? 1 : 0;
        this.resetVisuals();
    }

    public void setLiveItems(EventList<T> eventList) {
        this.setItems((Collection<T>)eventList);
        eventList.addListEventListener(new ListEventListener<T>(){

            public void listChanged(ListEvent<T> listEvent) {
                if (listEvent.getType() == 2) {
                    EntityComboBoxModel.this.addEntity(listEvent.getNewValue());
                } else if (listEvent.getType() == 1) {
                    int n = EntityComboBoxModel.this._entities.indexOf(listEvent.getOldValue());
                    if (n >= 0) {
                        EntityComboBoxModel.this._entities.set(n, listEvent.getNewValue());
                    }
                } else if (listEvent.getType() == 0) {
                    EntityComboBoxModel.this._entities.remove(listEvent.getOldValue());
                }
                EntityComboBoxModel.this.resetVisuals();
                EntityComboBoxModel.this.fireEverythingHasChanged();
            }
        });
    }

    public void setItems(Collection<T> collection) {
        this._entities.clear();
        if (collection != null) {
            for (T t : collection) {
                this.addEntity(t);
            }
            Comparator comparator = new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    String string = EntityComboBoxModel.this._converter.valueToString(t);
                    String string2 = EntityComboBoxModel.this._converter.valueToString(t2);
                    return string.compareTo(string2);
                }
            };
            Collections.sort(this._entities, comparator);
        }
        this.resetVisuals();
        this.fireEverythingHasChanged();
    }

    private void resetVisuals() {
        if (this._constructorCompleted) {
            this._visualItems.clear();
            for (T t : this._entities) {
                this._visualItems.add(this._converter.valueToString(t));
            }
        }
    }

    public T getEntityAt(int n) {
        if (n == 0 && this._nullable) {
            return null;
        }
        return this._entities.get(n - this._nullableOffset);
    }

    @Override
    public Object getElementAt(int n) {
        if (this._visualItems == null || this._visualItems.size() == 0 || n == 0 && this._nullable) {
            return NULL_TEXT;
        }
        return this._visualItems.get(n - this._nullableOffset);
    }

    @Override
    public void setSelectedItem(Object object) {
        String string = null;
        Object var3_3 = null;
        if (object != null && !object.equals(NULL_TEXT)) {
            int n = this._visualItems.indexOf(object);
            string = this._visualItems.get(n);
            var3_3 = this._entities.get(n);
        }
        this._selectedEntity = var3_3;
        this._selectedItem = string;
        this.fireEverythingHasChanged();
    }

    private void fireEverythingHasChanged() {
        if (this._constructorCompleted) {
            this.fireContentsChanged(this, 0, this._entities.size() + this._nullableOffset);
        }
    }

    public T getSelectedEntity() {
        return this._selectedEntity;
    }

    public void setSelectedEntity(T t) {
        String string = null;
        Object var3_3 = null;
        if (t != null) {
            int n = this._entities.indexOf(t);
            if (this._entities.size() != 0 && n >= 0) {
                string = this._visualItems.get(n);
                var3_3 = t;
            }
        }
        this._selectedEntity = var3_3;
        this._selectedItem = string;
        this.fireEverythingHasChanged();
    }

    @Override
    public Object getSelectedItem() {
        return this._selectedItem;
    }

    public void setDefault(T t) {
        this._default = t;
    }

    public T getDefault() {
        if (this._default == null && this._entities.size() == 1) {
            this._default = this._entities.get(0);
        }
        return this._default;
    }

    public void reset() {
        this.setSelectedEntity(this.getDefault());
    }
}

