/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.scanning.app.client.TaskPlugin;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.dao.DaoBackgroundExecutor;
import com.google.inject.Inject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.model3x.swing.M3Panel;

public class DeveloperHelperPanel
extends M3Panel {
    private static final long serialVersionUID = 5904571741492821923L;
    @Inject
    TaskPlugin _taskPlugin;
    @Inject
    ClientScanningDao _dao;
    JTextField _batchIdTF = new JTextField(10);
    JButton _createBatchButton = new JButton("Create Scan Batch");
    JButton _viewScanButton = new JButton("View Scan");
    JButton _scanDetailButton = new JButton("Indexing");
    JButton _codingButton = new JButton("Coding");
    JTextField _visitIdTF = new JTextField(10);

    @Inject
    private DeveloperHelperPanel() {
        this.add(new JLabel("Batch Id"), "right");
        this.add(this._batchIdTF, "wrap, spanx");
        this.add(new JLabel("Patient File Id"), "right");
        this.add(this._visitIdTF, "wrap, spanx");
        this.add(this._createBatchButton);
        this.add(this._viewScanButton);
        this.add(this._scanDetailButton);
        this.add(this._codingButton);
        this._createBatchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DaoBackgroundExecutor.executeInGuiBackground((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DeveloperHelperPanel.this._taskPlugin.showCreateScanBatch();
                    }
                });
            }
        });
        this._scanDetailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DeveloperHelperPanel.this._taskPlugin.showScanDetailPage(DeveloperHelperPanel.this.getBatchId().longValue(), true);
                    }
                });
            }
        });
        this._viewScanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DeveloperHelperPanel.this._taskPlugin.showScanDetailPage(DeveloperHelperPanel.this.getBatchId().longValue(), false);
                    }
                });
            }
        });
        this._codingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DeveloperHelperPanel.this._dao.resetSession();
                        DeveloperHelperPanel.this._taskPlugin.showCodingPage(DeveloperHelperPanel.this.getBatchId(), DeveloperHelperPanel.this.getVisitId());
                    }
                });
            }
        });
    }

    Long getBatchId() {
        try {
            String string = this._batchIdTF.getText().trim();
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    Long getVisitId() {
        try {
            String string = this._visitIdTF.getText().trim();
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

