/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.EntityComboBoxModel;
import com.ahsrcm.client.scanning.gui.IndexOptionEnum;
import com.ahsrcm.client.scanning.gui.IntegerField;
import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.BatchType;
import com.ahsrcm.corp.BusinessEntity;
import com.ahsrcm.corp.Company;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Doctor;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.scanning.app.client.beans.CorrespondenceScanningInfo;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.UserContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.model3.chrono.DateOnly;
import net.model3.collections.SetX;
import net.model3.lang.AbstractComparable;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.swing.GuiHelper;
import net.model3x.swing.M3Panel;
import net.model3x.swing.datechooser.TextFieldDateOnlyChooser;

public class CorrespondenceHeaderPanel {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 1L;
    EntityComboBoxModel<User> _nextUserModel = EntityComboBoxModel.create();
    User _user;
    M3Panel _mainPanel;
    JTextArea _commentTF;
    JTextField _companyTextField;
    JTextField _divisionTextField;
    TextFieldDateOnlyChooser _dateOfServiceDC;
    JLabel _dosMsg;
    IntegerField _numberOfPages;
    JLabel _numberOfPagesMsg;
    JTextField _patientNumber;
    JLabel _patientNumberMsg;
    JTextField _encounterNumber;
    JLabel _encounterMsg;
    JButton _createButton;
    JLabel _disabledMessage;
    CorrespondenceScanningInfo _correspondenceScanningInfo;
    private Listener _listener = new Listener(){

        @Override
        public void scanBatchCreated(ScanBatch scanBatch, IndexOptionEnum indexOptionEnum) {
        }
    };

    public static void main(String[] stringArray) throws Exception {
        new SimpleLoggingConfigurator().addEclipseConsoleAppender();
        UIManager.setLookAndFeel(new MetalLookAndFeel());
        CorrespondenceScanningInfo correspondenceScanningInfo = new CorrespondenceScanningInfo();
        CorrespondenceHeaderPanel correspondenceHeaderPanel = new CorrespondenceHeaderPanel(correspondenceScanningInfo, false);
        correspondenceHeaderPanel._user = new User();
        correspondenceHeaderPanel.init();
        GuiHelper.createFrame((JComponent)correspondenceHeaderPanel._mainPanel);
    }

    public CorrespondenceHeaderPanel(CorrespondenceScanningInfo correspondenceScanningInfo, boolean bl) {
        this._correspondenceScanningInfo = correspondenceScanningInfo;
        if (bl) {
            this.init();
        }
    }

    private void init() {
        this.initComponents();
        this.initPartTwo();
        this.setEnabled(true);
        this.initPartThree();
    }

    public User getUser() {
        if (this._user == null) {
            this._user = ((UserContext)UserContext.Impl.get()).getUser();
        }
        return this._user;
    }

    private void initPartTwo() {
        this._nextUserModel.setItems(new ArrayList());
        this._nextUserModel.setNullable(false);
        this._nextUserModel.setDefault(null);
        for (BusinessEntity businessEntity : this.getUser().getBusinessEntities()) {
            logger.debug((Object)"biz entities {}={}", businessEntity.entityId.get(), businessEntity.value.get());
        }
        this._dateOfServiceDC.setValue(new DateOnly());
        this._dosMsg.setVisible(false);
        this._numberOfPagesMsg.setVisible(false);
        this._createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CorrespondenceHeaderPanel.this.processCreateButtonAction();
            }
        });
        this._createButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    CorrespondenceHeaderPanel.this.processCreateButtonAction();
                }
            }
        });
        this.resetForm();
    }

    private Company getCompany() {
        String string = this._correspondenceScanningInfo.getCompany();
        Company company = null;
        if (StringX.isNotBlank((String)string)) {
            List list = this.getUser().allowedCompanies.get();
            for (int i = 0; i < list.size(); ++i) {
                Company company2 = (Company)list.get(i);
                if (!string.equalsIgnoreCase(company2.getId())) continue;
                company = company2;
            }
        }
        logger.debug((Object)"getCompanyFromSystemProperties -- company system parm ='{}' and resolved Company is {}", (Object)string, company);
        return company;
    }

    private Division getDivision() {
        String string = this._correspondenceScanningInfo.getDivision();
        Division division = null;
        if (StringX.isNotBlank((String)string)) {
            List list = this.getUser().allowedDivisions.get();
            for (int i = 0; i < list.size(); ++i) {
                Division division2 = (Division)list.get(i);
                if (!string.equalsIgnoreCase(division2.getId())) continue;
                division = division2;
            }
        }
        logger.debug((Object)"getDivisionFromSystemProperties -- division system parm ='{}' and resolved Division is {}", (Object)string, division);
        return division;
    }

    private Location getLocation() {
        String string = this._correspondenceScanningInfo.getLocation();
        List list = this.getUser().allowedLocations.get();
        Company company = this.getCompany();
        Division division = this.getDivision();
        Location location = null;
        for (int i = 0; i < list.size(); ++i) {
            Location location2 = (Location)list.get(i);
            CDLEntity cDLEntity = location2.getCDLEntity();
            Boolean bl = cDLEntity.getCompany().getId().equalsIgnoreCase(company.getId());
            Boolean bl2 = cDLEntity.getDivision().getId().equalsIgnoreCase(division.getId());
            Boolean bl3 = string.equalsIgnoreCase(location2.getId());
            if (!bl.booleanValue() || !bl2.booleanValue() || !bl3.booleanValue()) continue;
            location = location2;
        }
        logger.debug((Object)"getLocationFromSystemProperties -- location system parm ='{}' and resolved Location is {}", (Object)string, location);
        return location;
    }

    private BatchType getBatchType() {
        String string = this._correspondenceScanningInfo.getBatchType();
        BatchType batchType = null;
        if (StringX.isNotBlank((String)string)) {
            List list = this.getUser().batchTypes.get();
            for (int i = 0; i < list.size(); ++i) {
                BatchType batchType2 = (BatchType)list.get(i);
                if (!string.equalsIgnoreCase(batchType2.getId())) continue;
                batchType = batchType2;
            }
        }
        logger.debug((Object)"getBatchTypeFromSystemProperties -- batchType system parm ='{}' and resolved BatchType is {}", (Object)string, batchType);
        return batchType;
    }

    private Doctor getDoctor() {
        String string = this._correspondenceScanningInfo.getDoctor();
        Division division = null;
        if (StringX.isNotBlank((String)string)) {
            Set set = SetX.create();
            for (Division division2 : this.getUser().allowedDivisions) {
                set.addAll(division2.getActiveDoctors());
            }
            for (Division division2 : set) {
                if (!string.equalsIgnoreCase(division2.getId())) continue;
                division = division2;
            }
        }
        logger.debug((Object)"getDoctorFromSystemProperties -- doctor system parm ='{}' and resolved Doctor is {}", (Object)string, division);
        return division;
    }

    private void initPartThree() {
        String string = this._correspondenceScanningInfo.resolvePatientNumberString();
        String string2 = this._correspondenceScanningInfo.getEncounter();
        Company company = this.getCompany();
        this._companyTextField.setText(company.getId());
        this._companyTextField.setEnabled(false);
        Division division = this.getDivision();
        this._divisionTextField.setText(division.getId());
        this._divisionTextField.setEnabled(false);
        this._patientNumber.setText(string);
        this._patientNumber.setEnabled(false);
        this._encounterNumber.setText(string2);
        this._encounterNumber.setEnabled(false);
    }

    private void processCreateButtonAction() {
        if (!this.validateForm()) {
            return;
        }
        ScanBatch scanBatch = this.createScanBatch();
        this._listener.scanBatchCreated(scanBatch, IndexOptionEnum.None);
    }

    void resetErrorMessages() {
        JLabel[] jLabelArray;
        for (JLabel jLabel : jLabelArray = new JLabel[]{this._dosMsg, this._numberOfPagesMsg}) {
            jLabel.setText("");
            jLabel.setVisible(false);
            jLabel.setForeground(Color.RED);
        }
    }

    void initComponents() {
        this._mainPanel = new M3Panel("ins 10", "[][fill]");
        this._commentTF = new JTextArea();
        this._companyTextField = new JTextField();
        this._divisionTextField = new JTextField();
        this._createButton = new JButton("Create");
        this._dateOfServiceDC = new TextFieldDateOnlyChooser();
        this._disabledMessage = new JLabel();
        this._dosMsg = new JLabel();
        this._numberOfPages = new IntegerField();
        this._numberOfPagesMsg = new JLabel();
        this._patientNumber = new JTextField();
        this._patientNumberMsg = new JLabel();
        this._encounterNumber = new JTextField();
        this._encounterMsg = new JLabel();
        this._disabledMessage = new JLabel();
        JSeparator jSeparator = new JSeparator();
        jSeparator.setOrientation(0);
        jSeparator.setBackground(Color.black);
        jSeparator.setPreferredSize(new Dimension(2000, 1));
        this._mainPanel.setBackground(Color.white);
        this._disabledMessage.setText("<html>Can only create one batch at a time. Finish the current batch before starting a new one.</html>");
        this._dosMsg.setForeground(Color.red);
        this._numberOfPagesMsg.setForeground(Color.red);
        this._commentTF.setColumns(132);
        this._commentTF.setRows(5);
        this._commentTF.setBorder(new LineBorder(Color.gray));
        this._mainPanel.add((Component)this._disabledMessage, (Object)"wrap, spanx");
        this._mainPanel.add((Component)new JLabel("Company"), (Object)"right");
        this._mainPanel.add((Component)this._companyTextField, (Object)"wrap, growx");
        this._mainPanel.add((Component)new JLabel("Division"), (Object)"right");
        this._mainPanel.add((Component)this._divisionTextField, (Object)"wrap, growx");
        this._mainPanel.add((Component)new JLabel("Patient Number"), (Object)"right");
        this._mainPanel.add((Component)this._patientNumber, (Object)"wrap");
        this._mainPanel.add((Component)this._patientNumberMsg, (Object)"wrap, spanx");
        this._mainPanel.add((Component)new JLabel("Encounter"), (Object)"right");
        this._mainPanel.add((Component)this._encounterNumber, (Object)"wrap");
        this._mainPanel.add((Component)this._encounterMsg, (Object)"wrap, spanx");
        this._mainPanel.add((Component)jSeparator, (Object)"wrap, spanx");
        this._mainPanel.add((Component)new JLabel("Date"), (Object)"right");
        this._mainPanel.add((Component)this._dateOfServiceDC, (Object)"wrap");
        this._mainPanel.add((Component)this._dosMsg, (Object)"wrap, spanx");
        this._mainPanel.add((Component)new JLabel("Number of Pages"), (Object)"right");
        this._mainPanel.add((Component)((Object)this._numberOfPages), (Object)"wrap");
        this._mainPanel.add((Component)this._numberOfPagesMsg, (Object)"wrap, spanx");
        this._mainPanel.add((Component)new JLabel("Notes"), (Object)"right");
        this._mainPanel.add((Component)this._commentTF, (Object)"wrap");
        this._mainPanel.add((Component)this._createButton, (Object)"center, spanx");
    }

    public void setEnabled(boolean bl) {
        this._mainPanel.setEnabled(bl);
        this._companyTextField.setEnabled(bl);
        this._divisionTextField.setEnabled(bl);
        this._dateOfServiceDC.setEnabled(bl);
        this._numberOfPages.setEnabled(bl);
        this._disabledMessage.setVisible(!bl);
        this._createButton.setVisible(bl);
        this._commentTF.setEnabled(bl);
        this._patientNumber.setEnabled(bl);
        this._createButton.setEnabled(bl);
        GuiHelper.doLayoutHack((Component)this._mainPanel);
    }

    public boolean validateForm() {
        this.resetErrorMessages();
        boolean bl = true;
        DateOnly dateOnly = this._dateOfServiceDC.getValue();
        if (dateOnly != null && dateOnly.greaterThan((AbstractComparable)new DateOnly())) {
            this._dosMsg.setText("Date of service cannot be in the future");
            this._dosMsg.setVisible(true);
            bl = false;
        }
        if (this._numberOfPages.getValue() < 0) {
            this._numberOfPagesMsg.setText("Must enter a valid number for the expected number of pages");
            this._numberOfPagesMsg.setVisible(true);
            bl = false;
        }
        return bl;
    }

    private ScanBatch createScanBatch() {
        ScanBatch scanBatch = new ScanBatch();
        scanBatch.dateOfService.set((Object)new Date(this._dateOfServiceDC.getValue().inMillis()));
        Location location = this.getLocation();
        Doctor doctor = this.getDoctor();
        scanBatch.location.set((Object)location);
        if (doctor != null) {
            scanBatch.doctor.set((Object)doctor);
        }
        scanBatch.batchType.set((Object)this.getBatchType());
        scanBatch.expectedImageCount.set((Object)this._numberOfPages.getValue());
        scanBatch.expectedVisitCount.set((Object)1);
        scanBatch.comment.set((Object)this._commentTF.getText());
        scanBatch.id.set((Object)((ScanningDao)ScanningDao.Impl.get()).nextControlNumber(ScanBatch.class));
        scanBatch.stage.set((Object)((Stage)Stage.ScanningInProgress.get()));
        ((ScanningDao)ScanningDao.Impl.get()).insert((BaseBusinessBean)scanBatch);
        this.resetForm();
        return scanBatch;
    }

    public void resetForm() {
        this.resetErrorMessages();
        this._numberOfPages.setValue(0);
        this._nextUserModel.reset();
        this._commentTF.setText("");
    }

    public void setListener(Listener listener) {
        this._listener = listener;
    }

    public Component getMainPanel() {
        return this._mainPanel;
    }

    public static interface Listener {
        public void scanBatchCreated(ScanBatch var1, IndexOptionEnum var2);
    }
}

