/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.ButtonColumn;
import com.ahsrcm.client.scanning.gui.ChargeEntryPanel;
import com.ahsrcm.client.scanning.gui.CodingTitlePanel;
import com.ahsrcm.client.scanning.gui.DateCellRenderer;
import com.ahsrcm.client.scanning.gui.EntityComboBoxModel;
import com.ahsrcm.client.scanning.gui.ImageViewer;
import com.ahsrcm.client.scanning.gui.PanelPopupHelper;
import com.ahsrcm.client.scanning.gui.PatientSelector;
import com.ahsrcm.client.scanning.gui.UserStageChooserPanel;
import com.ahsrcm.client.scanning.gui.WorkflowNotePanel;
import com.ahsrcm.core.scanning.gui.ImageProxy;
import com.ahsrcm.core.scanning.gui.ImageProxyPopupFactory;
import com.ahsrcm.core.scanning.gui.ScannedImageProxy;
import com.ahsrcm.core.util.DeployEdgeProperties;
import com.ahsrcm.core.virtualmanager.PatientDTO;
import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.CodingCharge;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.PatientFileTransaction;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.WorkflowNote;
import com.ahsrcm.corp.WorkflowNoteType;
import com.ahsrcm.corp.dto.CompanyCPTCodes;
import com.ahsrcm.corp.dto.ScanBatchDTO;
import com.ahsrcm.corp.rules.Rule;
import com.ahsrcm.corp.rules.RuleManager;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.dao.DaoBackgroundExecutor;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.ChangeSet;
import com.ahsrcm.util.Formatters;
import com.ahsrcm.util.PrintingService;
import com.ahsrcm.util.TimeZoneFixer;
import com.ahsrcm.util.UserContext;
import css.CssHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.bean.converters.Converter;
import net.model3.bean.converters.ConverterAdapter;
import net.model3.chrono.DateOnly;
import net.model3.chrono.DateTime;
import net.model3.collections.ListX;
import net.model3.collections.SetX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ObjectX;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.swing.GuiHelper;
import net.model3.util.DateX;
import net.model3x.swing.AbstractColumnHandler;
import net.model3x.swing.BeanTableModel;
import net.model3x.swing.ColumnHandler;
import net.model3x.swing.M3Panel;
import net.model3x.swing.domviewer.ComponentTreeModelBuilder;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.JXTaskPane;

public final class CodingPanel {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 1L;
    private final DeployEdgeProperties _deployEdgeProperties = (DeployEdgeProperties)DependencyInjector.getInstance(DeployEdgeProperties.class);
    private final ClientScanningDao _dao = (ClientScanningDao)DependencyInjector.getInstance(ClientScanningDao.class);
    private final ScanBatchDTO _scanBatchDTO;
    private final ImageViewer _imageViewer = new ImageViewer(new ImageViewer.Listener(){

        @Override
        public void imageChanged() {
            CodingPanel.this.scheduleImageDownloading();
        }
    });
    private ScanBatch _scanBatch;
    private PatientFile _patientFile;
    private int _chargeSequenceCounter;
    private int _noteSequenceCounter;
    private EntityComboBoxModel<PatientFile> _visitsModel;
    private List<ScannedImage> _batchVisibleImages;
    private JTable _codingChargesTable;
    private BeanTableModel<CodingCharge> _codingChargesModel;
    private JScrollPane _codingChargesTableScrollPane;
    private JXTaskPane _chargesTaskPane;
    private JTable _notesTable;
    private BeanTableModel<Note> _notesModel;
    private JScrollPane _notesTableScrollPane;
    private JXTaskPane _notesTaskPane;
    private BeanTableModel<PatientFileTransaction> _historyModel;
    private JScrollPane _historyTableScrollPane;
    private WorkflowNotePanel _workflowNotePanel;
    private final ChargeEntryPanel _chargeEntryPanel;
    private ChangeSet<CodingCharge> _chargesChangeSet = ChangeSet.create();
    private ChangeSet<Note> _notesChangeSet = ChangeSet.create();
    private final CodingTitlePanel _codingTitlePanel = new CodingTitlePanel();
    private boolean _updatesPending = false;
    Set<PatientFile> _updatedPatientFiles = SetX.create();
    CompanyCPTCodes _cptCodes;
    private final M3Panel _root = new M3Panel("ins 20,fill", "", "[][][][][][grow]");
    private final M3Panel _scrollContainer = new M3Panel("fill, ins 0");
    private boolean _hourglassAdded = false;
    JLabel _ahsHourglass = new JLabel(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean contains(int n, int n2) {
            return false;
        }
    };
    private boolean _testing;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        CodingPanel codingPanel = new CodingPanel();
        jFrame.add(codingPanel.getPanel());
        ComponentTreeModelBuilder.addFrameMenus();
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public CodingPanel(PatientFile patientFile, CompanyCPTCodes companyCPTCodes, ScanBatchDTO scanBatchDTO) {
        this._ahsHourglass.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("ahs-hourglass.gif")));
        this._ahsHourglass.setSize(this._ahsHourglass.getPreferredSize());
        this._ahsHourglass.setVisible(false);
        this._testing = false;
        this._cptCodes = companyCPTCodes;
        this._scanBatchDTO = scanBatchDTO;
        this._chargeEntryPanel = new ChargeEntryPanel(this._cptCodes, this._scanBatchDTO);
        this._root.setBackground(Color.WHITE);
        this.initPartDeux();
        if (patientFile != null) {
            this.setPatientFile(patientFile);
        }
        this.initHotKeys();
    }

    private CodingPanel() {
        this._ahsHourglass.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("ahs-hourglass.gif")));
        this._ahsHourglass.setSize(this._ahsHourglass.getPreferredSize());
        this._ahsHourglass.setVisible(false);
        this._testing = false;
        this._testing = true;
        this._cptCodes = null;
        this._scanBatchDTO = null;
        this._chargeEntryPanel = new ChargeEntryPanel(null, null);
        this._root.setBackground(Color.WHITE);
        this.initPartDeux();
        this.initHotKeys();
    }

    private void initHotKeys() {
        this._root.putClientProperty((Object)"KeyEventDispatcher", (Object)new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                boolean bl = false;
                if (keyEvent.getKeyCode() == 119) {
                    bl = true;
                    CodingPanel.this.udpateAndGotoNextPatientFile();
                } else if (keyEvent.getKeyCode() == 33) {
                    bl = true;
                    CodingPanel.this._imageViewer.previousPage();
                } else if (keyEvent.getKeyCode() == 34) {
                    bl = true;
                    CodingPanel.this._imageViewer.nextPage();
                } else if (keyEvent.getKeyCode() == 107) {
                    bl = true;
                    CodingPanel.this._imageViewer.zoomIn();
                } else if (keyEvent.getKeyCode() == 109) {
                    bl = true;
                    CodingPanel.this._imageViewer.zoomOut();
                } else if (keyEvent.getKeyCode() == 115) {
                    logger.debug((Object)"User pressed F4. Submitting patient file split using chooseNextStageThenSplit.");
                    CodingPanel.this.submitPatientFileSplit(PatientFileSplitType.chooseNextStageThenSplit);
                } else if (keyEvent.getKeyCode() == 116) {
                    logger.debug((Object)"User pressed F5. Submitting patient file split using gotoNextStageThenSplit.");
                    CodingPanel.this.submitPatientFileSplit(PatientFileSplitType.gotoNextStageThenSplit);
                } else if (keyEvent.getKeyCode() == 117) {
                    logger.debug((Object)"User pressed F6. Submitting patient file split using splitAndClose.");
                    CodingPanel.this.submitPatientFileSplit(PatientFileSplitType.splitAndClose);
                }
                return bl;
            }
        });
    }

    public JPanel getPanel() {
        return this._scrollContainer;
    }

    void initPartDeux() {
        ButtonColumn buttonColumn;
        Object object;
        Object object2;
        this._scrollContainer.add((Component)this._root, (Object)"grow");
        String string = this._deployEdgeProperties.getDefaultZoom();
        try {
            logger.debug((Object)"Setting default zoom factor to {}", (Object)string);
            this._imageViewer.setDefaultZoomFactor(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            logger.error((Object)"Default zoom property has invalid config value | {}", (Object)string);
        }
        this._root.setName("RootPanel");
        this._scrollContainer.setName("ScrollContainer");
        this._workflowNotePanel = new WorkflowNotePanel(new WorkflowNotePanel.Listener(){

            @Override
            public void enterPressed() {
                CodingPanel.this._noteSequenceCounter++;
                Note note = new Note(CodingPanel.this._workflowNotePanel.getNoteTF().getText(), CodingPanel.this._workflowNotePanel.getNoteTypeModel().getSelectedEntity(), CodingPanel.this._noteSequenceCounter);
                CodingPanel.this._notesModel.addRow((Object)note);
                CodingPanel.this._notesModel.fireTableDataChanged();
                CodingPanel.this.updateTaskpaneTitles();
                CodingPanel.this._notesChangeSet.insert((BaseBusinessBean)note);
                CodingPanel.this._notesTaskPane.invalidate();
                CodingPanel.this._notesTaskPane.validate();
                CodingPanel.this._notesTaskPane.repaint();
                CodingPanel.this._root.invalidate();
                CodingPanel.this._root.validate();
                CodingPanel.this._root.repaint();
                CodingPanel.this._root.repaint();
            }

            @Override
            public void cancelPressed() {
            }
        });
        this._imageViewer.getCloseButton().setVisible(false);
        this._chargeEntryPanel.setChargeEntryPanelListener(new ChargeEntryPanel.Listener(){

            @Override
            public void applyCodingCharge(CodingCharge codingCharge, boolean bl) {
                logger.debug((Object)"applying coding charge {} update = {}", (Object)codingCharge.procedureCode, (Object)bl);
                if (bl) {
                    CodingPanel.this._chargesChangeSet.update((BaseBusinessBean)codingCharge);
                } else {
                    CodingPanel.this._chargeSequenceCounter++;
                    codingCharge.sequence.set((Object)CodingPanel.this._chargeSequenceCounter);
                    codingCharge.updateHeaderInfo(CodingPanel.this._patientFile);
                    codingCharge.image.set((Object)CodingPanel.this.getCurrentImage());
                    CodingPanel.this._chargesChangeSet.insert((BaseBusinessBean)codingCharge);
                    CodingPanel.this._codingChargesModel.addRow((Object)codingCharge);
                }
                CodingPanel.this._codingChargesModel.fireTableDataChanged();
                CodingPanel.this.updateTaskpaneTitles();
            }
        });
        this._codingChargesModel = new BeanTableModel();
        int n = 4;
        int n2 = 6;
        CodingCharge codingCharge = CodingCharge.Meta;
        this._codingChargesModel.addColumn((ColumnHandler)new AbstractColumnHandler<CodingCharge>("Date of Service", Date.class){

            public Object getColumnValue(CodingCharge codingCharge, int n) {
                return TimeZoneFixer.fixDate((Date)((Date)codingCharge.dateOfService.get()));
            }
        });
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.locationId);
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.doctorId);
        if (this._scanBatchDTO.showMedicalRecordNum) {
            this._codingChargesModel.addColumn((PropertyContextable)codingCharge.medicalRecordNum);
        }
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.sequence);
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.procedureCode);
        this._codingChargesModel.addColumn((ColumnHandler)new AbstractColumnHandler<CodingCharge>("BU", String.class){

            public Object getColumnValue(CodingCharge codingCharge, int n) {
                return "" + CodingPanel.this._cptCodes.lookupProcedure((String)codingCharge.procedureCode.get()).getTimesPerformed();
            }
        }).setPreferredWidth(Integer.valueOf(n));
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.timesPerformed);
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.asaProcedureCode);
        this._codingChargesModel.addColumn((ColumnHandler)new AbstractColumnHandler<CodingCharge>("BU", String.class){

            public Object getColumnValue(CodingCharge codingCharge, int n) {
                String string = (String)codingCharge.asaProcedureCode.get();
                if (StringX.isNotBlank((String)string)) {
                    return CodingPanel.this._cptCodes.lookupProcedure(string).getTimesPerformed();
                }
                return "";
            }
        }).setPreferredWidth(Integer.valueOf(n));
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.diagnosis1Code);
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.diagnosis2Code);
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.diagnosis3Code);
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.diagnosis4Code);
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.modifier1Code);
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.modifier2Code);
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.modifier3Code);
        this._codingChargesModel.addColumn((PropertyContextable)codingCharge.modifier4Code);
        this._codingChargesModel.addColumn((ColumnHandler)new AbstractColumnHandler<CodingCharge>("CC", String.class){

            public Object getColumnValue(CodingCharge codingCharge, int n) {
                List list = ListX.create();
                list.add((String)codingCharge.conditionCode1.get());
                list.add((String)codingCharge.conditionCode2.get());
                list.add((String)codingCharge.conditionCode3.get());
                list.add((String)codingCharge.conditionCode4.get());
                list.add((String)codingCharge.conditionCode5.get());
                return StringX.join((Iterable)list, (String)" ");
            }
        }).setPreferredWidth(Integer.valueOf(10));
        this._codingChargesModel.addColumn((ColumnHandler)new AbstractColumnHandler<CodingCharge>("TC", String.class){

            public Object getColumnValue(CodingCharge codingCharge, int n) {
                return codingCharge.transportationReason.get();
            }
        }).setPreferredWidth(Integer.valueOf(2));
        this._codingChargesModel.addColumn((ColumnHandler)new AbstractColumnHandler<CodingCharge>("Image", CodingCharge.class){

            public Object getColumnValue(CodingCharge codingCharge, int n) {
                if (codingCharge.image.get() == null) {
                    return "";
                }
                return ((ScannedImage)codingCharge.image.get()).id.get();
            }
        }).setPreferredWidth(Integer.valueOf(n2));
        int n3 = this._codingChargesModel.getColumnCount();
        if (this.allowEntry()) {
            object2 = new AbstractColumnHandler<CodingCharge>("", Integer.valueOf(10), String.class){

                public Object getColumnValue(CodingCharge codingCharge, int n) {
                    return "";
                }
            };
            this._codingChargesModel.addColumn((ColumnHandler)object2);
            object2.setEditable(true);
            object = new AbstractColumnHandler<CodingCharge>("", Integer.valueOf(10), String.class){

                public Object getColumnValue(CodingCharge codingCharge, int n) {
                    return "";
                }
            };
            this._codingChargesModel.addColumn((ColumnHandler)object);
            object.setEditable(true);
        }
        this._codingChargesTable = new JTable();
        this._codingChargesTable.setModel((TableModel)this._codingChargesModel);
        this._codingChargesModel.setPreferredWidths(this._codingChargesTable.getColumnModel());
        this._codingChargesTable.setDefaultRenderer(DateOnly.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -449080283273538707L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = Formatters.formatMonthDayYear((DateOnly)((DateOnly)object));
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        this._codingChargesTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 3114600830668161725L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = Formatters.formatMonthDayYear((Date)((Date)object));
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        if (this.allowEntry()) {
            object2 = new ButtonColumn(this._codingChargesTable, n3);
            object2.setButtonColumnListener(new ButtonColumn.ButtonColumnListener(){

                @Override
                public void buttonPressed(int n) {
                    n = CodingPanel.this._codingChargesTable.getRowSorter().convertRowIndexToModel(n);
                    CodingCharge codingCharge = (CodingCharge)CodingPanel.this._codingChargesModel.getRow(n);
                    CodingPanel.this.showEditCodingChargeDialog(codingCharge);
                }
            });
            object2.setText("edit");
            object = new ButtonColumn(this._codingChargesTable, n3 + 1);
            ((ButtonColumn)object).setButtonColumnListener(new ButtonColumn.ButtonColumnListener(){

                @Override
                public void buttonPressed(int n) {
                    n = CodingPanel.this._codingChargesTable.getRowSorter().convertRowIndexToModel(n);
                    CodingCharge codingCharge = (CodingCharge)CodingPanel.this._codingChargesModel.getRow(n);
                    int n2 = JOptionPane.showConfirmDialog(CodingPanel.this._codingChargesTable, "Are you sure you want to delete this coding charge?");
                    if (n2 == 0) {
                        CodingPanel.this._codingChargesModel.getRows().remove(codingCharge);
                        CodingPanel.this._codingChargesModel.fireTableDataChanged();
                        CodingPanel.this._chargesChangeSet.delete((BaseBusinessBean)codingCharge);
                    }
                    CodingPanel.this._codingChargesTable.getSelectionModel().setSelectionInterval(-1, -1);
                }
            });
            ((ButtonColumn)object).setText("remove");
        }
        this._chargesTaskPane = new JXTaskPane();
        this._codingChargesTableScrollPane = new JScrollPane(this._codingChargesTable);
        this._chargesTaskPane.add((Component)this._codingChargesTableScrollPane);
        this._codingChargesTable.setRowSorter(new TableRowSorter<BeanTableModel<CodingCharge>>(this._codingChargesModel));
        this._codingChargesTable.getSelectionModel().setSelectionMode(0);
        this._notesModel = new BeanTableModel();
        this._notesModel.addColumn((ColumnHandler)new AbstractColumnHandler<Note>("Type", Integer.valueOf(15), WorkflowNoteType.class){

            public Object getColumnValue(Note note, int n) {
                return note.type;
            }
        });
        this._notesModel.addColumn((ColumnHandler)new AbstractColumnHandler<Note>("Text", Integer.valueOf(40), String.class){

            public Object getColumnValue(Note note, int n) {
                return note.text;
            }
        });
        this._notesModel.addColumn((ColumnHandler)new AbstractColumnHandler<Note>("Created", Integer.valueOf(15), DateX.class){

            public Object getColumnValue(Note note, int n) {
                return note.getCreationTimestamp();
            }
        });
        this._notesTable = new JTable();
        this._notesTable.setDefaultRenderer(DateX.class, new DateCellRenderer());
        try {
            n3 = this._notesModel.getColumnCount();
            object2 = new AbstractColumnHandler<Note>("", Integer.valueOf(1), String.class){

                public Object getColumnValue(Note note, int n) {
                    return "";
                }
            };
            this._notesModel.addColumn((ColumnHandler)object2);
            object2.setEditable(true);
            object = new AbstractColumnHandler<Note>("", Integer.valueOf(1), String.class){

                public Object getColumnValue(Note note, int n) {
                    return "";
                }
            };
            this._notesModel.addColumn((ColumnHandler)object);
            object.setEditable(true);
            this._notesTable.setModel((TableModel)this._notesModel);
            buttonColumn = new ButtonColumn(this._notesTable, n3);
            buttonColumn.setButtonColumnListener(new ButtonColumn.ButtonColumnListener(){

                @Override
                public void buttonPressed(int n) {
                    n = CodingPanel.this._notesTable.getRowSorter().convertRowIndexToModel(n);
                    Note note = (Note)((Object)CodingPanel.this._notesModel.getRow(n));
                    CodingPanel.this.showEditWorkflowNoteDialog(note);
                }
            });
            buttonColumn.setText("edit");
            ButtonColumn buttonColumn2 = new ButtonColumn(this._notesTable, n3 + 1);
            buttonColumn2.setButtonColumnListener(new ButtonColumn.ButtonColumnListener(){

                @Override
                public void buttonPressed(int n) {
                    n = CodingPanel.this._notesTable.getRowSorter().convertRowIndexToModel(n);
                    Note note = (Note)((Object)CodingPanel.this._notesModel.getRow(n));
                    int n2 = JOptionPane.showConfirmDialog(CodingPanel.this._notesTable, "Are you sure you want to delete this note?");
                    if (n2 == 0) {
                        CodingPanel.this._notesModel.getRows().remove((Object)note);
                        CodingPanel.this._notesModel.fireTableDataChanged();
                        CodingPanel.this._notesChangeSet.delete((BaseBusinessBean)note);
                    }
                    CodingPanel.this._notesTable.getSelectionModel().setSelectionInterval(-1, -1);
                }
            });
            buttonColumn2.setText("remove");
        }
        catch (Exception exception) {
            logger.warn((Object)exception);
        }
        this._notesModel.setPreferredWidths(this._notesTable.getColumnModel());
        this._notesTaskPane = new JXTaskPane();
        this._notesTableScrollPane = new JScrollPane(this._notesTable);
        this._notesTaskPane.add((Component)this._notesTableScrollPane);
        this._notesTable.setRowSorter(new TableRowSorter<BeanTableModel<Note>>(this._notesModel));
        this._historyModel = new BeanTableModel();
        object2 = PatientFileTransaction.Meta;
        this._historyModel.addColumn((PropertyContextable)object2.creationUser);
        this._historyModel.addColumn((ColumnHandler)new AbstractColumnHandler<PatientFileTransaction>("Created", DateX.class){

            public Object getColumnValue(PatientFileTransaction patientFileTransaction, int n) {
                return patientFileTransaction.getCreationTimestamp();
            }
        });
        this._historyModel.addColumn((PropertyContextable)object2.stage);
        this._historyModel.addColumn((PropertyContextable)object2.reworker);
        this._historyModel.addColumn((PropertyContextable)object2.coder);
        this._historyModel.addColumn((PropertyContextable)object2.dataEntryUser);
        object = new JTable();
        ((JTable)object).setModel((TableModel)this._historyModel);
        this._historyModel.setPreferredWidths(((JTable)object).getColumnModel());
        this._historyTableScrollPane = new JScrollPane((Component)object);
        ((JTable)object).setRowSorter(new TableRowSorter<BeanTableModel<PatientFileTransaction>>(this._historyModel));
        this._visitsModel = new EntityComboBoxModel(new ArrayList());
        this._codingTitlePanel.getPatientFilesDropDown().setModel(this._visitsModel);
        this._visitsModel.setConverter((Converter<PatientFile>)new ConverterAdapter<PatientFile>(){

            public String valueToString(PatientFile patientFile) {
                Stage stage = (Stage)patientFile.stage.get();
                return "Patient File " + patientFile.id.get() + " - " + (String)stage.id.get();
            }
        });
        this._codingTitlePanel.getNextPatientFileButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug((Object)"Next patient file button clicked");
                CodingPanel.this.calcNextPrevButtonsState(1);
            }
        });
        this._codingTitlePanel.getPrevPatientFileButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug((Object)"Previous patient file button clicked");
                CodingPanel.this.calcNextPrevButtonsState(-1);
            }
        });
        this._codingTitlePanel.getPatientFilesDropDown().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CodingPanel.this._patientFile != null && CodingPanel.this._visitsModel.getSelectedEntity() != null && !CodingPanel.this._patientFile.getId().equals(((PatientFile)CodingPanel.this._visitsModel.getSelectedEntity()).getId())) {
                    if (CodingPanel.this.calcNextPrevButtonsState(0)) {
                        CodingPanel.this.setPatientFile((PatientFile)CodingPanel.this._visitsModel.getSelectedEntity());
                    } else {
                        CodingPanel.this._visitsModel.setSelectedEntity(CodingPanel.this._patientFile);
                    }
                }
            }
        });
        this._codingTitlePanel.getFinishButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug((Object)"Finish button clicked");
                CodingPanel.this.applyChanges(false, true, false);
            }
        });
        this._codingTitlePanel.getUpdateStageButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug((Object)"Update Stage button clicked");
                CodingPanel.this.applyChanges(true, false, false);
            }
        });
        this._codingTitlePanel.getReindexButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug((Object)"Reindex button clicked");
                DaoBackgroundExecutor.executeInGuiBackground((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((PanelPopupHelper)DependencyInjector.getInstance(PanelPopupHelper.class)).showScanDetail((ScanBatch)((CodingPanel)CodingPanel.this)._patientFile.batch.get(), true);
                    }
                });
            }
        });
        this._root.removeAll();
        this._root.add((Component)this._codingTitlePanel, (Object)"wrap, growx");
        if (this.allowEntry()) {
            buttonColumn = new JXTaskPane();
            buttonColumn.setTitle("Charge Entry");
            buttonColumn.setCollapsed(false);
            buttonColumn.add((Component)((Object)this._chargeEntryPanel));
            this._root.add((Component)((Object)buttonColumn), (Object)"wrap, growx");
            this._root.setRowConstraints("[][][][][][grow]");
        } else {
            this._root.setRowConstraints("[][][][][grow]");
        }
        buttonColumn = new JXTaskPane();
        buttonColumn.setTitle("Notes Entry");
        buttonColumn.setCollapsed(false);
        buttonColumn.add(this._workflowNotePanel);
        this._root.add((Component)((Object)buttonColumn), (Object)"wrap, growx");
        this._root.add((Component)this._chargesTaskPane, (Object)"wrap, growx");
        this._root.add((Component)this._notesTaskPane, (Object)"wrap, growx");
        this._imageViewer.getWorkflowHistoryButton().setVisible(true);
        this._imageViewer.getWorkflowHistoryButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final JDialog jDialog = new JDialog(SwingUtilities.getWindowAncestor((Component)CodingPanel.this._root));
                jDialog.setLayout(new BorderLayout());
                jDialog.add((Component)CodingPanel.this._historyTableScrollPane, "Center");
                JButton jButton = new JButton("Close");
                jDialog.add((Component)jButton, "South");
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jDialog.dispose();
                    }
                });
                jDialog.setBackground(Color.white);
                jDialog.setModal(true);
                jDialog.setSize(800, 300);
                jDialog.setVisible(true);
            }
        });
        this._imageViewer.setCreateNewPatientFileButtonActionHandler(new ImageViewer.NewPatientFileActionHandler(){

            @Override
            public void processNewPatientFile(int n) {
                logger.debug((Object)"ImageViewer new patient file button clicked. Submitting patient file split using splitAndClose.");
                CodingPanel.this.submitPatientFileSplit(PatientFileSplitType.splitAndClose);
            }
        });
        this._imageViewer.setAdvancedPrintingActionHandler(() -> ((PanelPopupHelper)DependencyInjector.getInstance(PanelPopupHelper.class)).showScanDetail((ScanBatch)this._patientFile.batch.get(), false));
        this._root.add((Component)this._imageViewer, (Object)"grow");
        this._root.invalidate();
        this._root.validate();
        this._root.repaint();
        this._imageViewer.setPopupFactory(new ImageProxyPopupFactory(){

            public JPopupMenu createPopup(final ImageProxy imageProxy) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem("Enter Patient #");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        PatientDTO patientDTO = PatientSelector.popupSelector((Location)((ScanBatch)((CodingPanel)CodingPanel.this)._patientFile.batch.get()).location.get(), (Component)CodingPanel.this._imageViewer);
                        if (patientDTO != null) {
                            logger.debug((Object)"Updating patient number and name");
                            ((CodingPanel)CodingPanel.this)._patientFile.patientNumber.set((Object)patientDTO.number);
                            ((CodingPanel)CodingPanel.this)._patientFile.patientFirstName.set((Object)patientDTO.first);
                            ((CodingPanel)CodingPanel.this)._patientFile.patientMiddleName.set((Object)patientDTO.middle);
                            ((CodingPanel)CodingPanel.this)._patientFile.patientLastName.set((Object)patientDTO.last);
                        }
                    }
                });
                jMenuItem = new JMenuItem("Print");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ScannedImage scannedImage = (ScannedImage)imageProxy.getReferent();
                        PrintingService.print((ScannedImage)scannedImage);
                    }
                });
                return jPopupMenu;
            }
        });
        ((Component)object).setName("historyTable");
        this._codingChargesTable.setName("codingChargesTable");
        this._notesTable.setName("notesTable");
    }

    void updateTaskpaneTitles() {
        this._chargesTaskPane.setTitle(this._codingChargesModel.getRowCount() + " Charges");
        this._notesTaskPane.setTitle(this._notesModel.getRowCount() + " Notes");
        this.resetTableHeights();
    }

    void showEditCodingChargeDialog(CodingCharge codingCharge) {
        final JDialog jDialog = new JDialog(SwingUtilities.getWindowAncestor((Component)this._root));
        ChargeEntryPanel chargeEntryPanel = new ChargeEntryPanel(this._cptCodes, this._scanBatchDTO);
        CssHelper.getStylesheet((Component)this._scrollContainer).applyTo((Component)((Object)chargeEntryPanel));
        chargeEntryPanel.setPatientFile(this._patientFile);
        chargeEntryPanel.setCodingCharge(codingCharge, true);
        chargeEntryPanel.setChargeEntryPanelListener(new ChargeEntryPanel.Listener(){

            @Override
            public void applyCodingCharge(CodingCharge codingCharge, boolean bl) {
                CodingPanel.this._chargesChangeSet.update((BaseBusinessBean)codingCharge);
                CodingPanel.this._codingChargesModel.fireTableDataChanged();
                jDialog.dispose();
            }
        });
        jDialog.setLocation(this._chargesTaskPane.getLocationOnScreen());
        jDialog.add((Component)((Object)chargeEntryPanel));
        jDialog.pack();
        jDialog.setVisible(true);
    }

    void showEditWorkflowNoteDialog(final Note note) {
        final JDialog jDialog = new JDialog(SwingUtilities.getWindowAncestor((Component)this._root));
        jDialog.setBackground(Color.white);
        jDialog.getContentPane().setBackground(Color.white);
        final WorkflowNotePanel workflowNotePanel = new WorkflowNotePanel(null);
        workflowNotePanel.setListener(new WorkflowNotePanel.Listener(){

            @Override
            public void enterPressed() {
                note.text = workflowNotePanel.getNoteTF().getText();
                note.type = workflowNotePanel.getNoteTypeModel().getSelectedEntity();
                CodingPanel.this._notesChangeSet.update((BaseBusinessBean)note);
                CodingPanel.this._notesModel.fireTableDataChanged();
                jDialog.dispose();
            }

            @Override
            public void cancelPressed() {
                jDialog.dispose();
            }
        });
        workflowNotePanel.getEnterNoteButton().setText("Update");
        workflowNotePanel.getCancelButton().setVisible(true);
        workflowNotePanel.getNoteTF().setText(StringX.trimRight((String)note.text));
        workflowNotePanel.getNoteTypeModel().setSelectedEntity(note.type);
        jDialog.setLocation(this._notesTaskPane.getLocationOnScreen());
        jDialog.add(workflowNotePanel);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    UserStageChooserPanel showUserStageChooserDialog(boolean bl) {
        boolean bl2;
        JDialog jDialog2;
        Object object;
        Object object22;
        User user;
        Object object3 = null;
        if (this._notesChangeSet.getInserts().size() > 0) {
            user = null;
            for (Object object22 : this._notesChangeSet.getInserts()) {
                if (user != null && ((String)((Note)((Object)object22)).type.id.get()).compareTo((String)user.id.get()) >= 0) continue;
                user = ((Note)((Object)object22)).type;
            }
            if (user != null) {
                object = SetX.create((Iterable)((Iterable)this._patientFile.currentRule().allowedToStages.get()));
                object.add((Stage)this._patientFile.currentRule().stage.get());
                for (final JDialog jDialog2 : Stage.getSortedStages()) {
                    if (!object.contains(jDialog2) || ((String)((Stage)jDialog2).id.get()).compareTo((String)user.id.get()) > 0) continue;
                    object3 = jDialog2;
                }
            }
        }
        if (object3 == null && this._patientFile.currentRule().nextRequiredRule() != null) {
            object3 = (Stage)this._patientFile.currentRule().nextRequiredRule().stage.get();
        }
        user = this._patientFile.getRuleManager().getDefaultUser(object3);
        object = this._patientFile.getRuleManager().getRule(object3);
        object22 = new UserStageChooserPanel(this._patientFile, (Stage)object3);
        jDialog2 = new JDialog(SwingUtilities.getWindowAncestor((Component)this._root));
        jDialog2.add((Component)object22);
        jDialog2.setBackground(Color.white);
        jDialog2.setModal(true);
        if (object3 != null && object3.equals((Object)Stage.ReworkOut.get()) && user == null) {
            user = ((UserContext)UserContext.Impl.get()).getUser();
            ((UserStageChooserPanel)object22).setUser(user);
        }
        final AtomicReference<Object> atomicReference = new AtomicReference<Object>();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        ((UserStageChooserPanel)object22).setListener(new UserStageChooserPanel.Listener((UserStageChooserPanel)object22){
            final /* synthetic */ UserStageChooserPanel val$panel;
            {
                this.val$panel = userStageChooserPanel;
            }

            @Override
            public void okayPressed(Stage stage, User user) {
                atomicBoolean.set(true);
                jDialog2.setVisible(false);
                atomicReference.set(this.val$panel);
            }

            @Override
            public void cancelPressed() {
                jDialog2.setVisible(false);
            }
        });
        boolean bl3 = bl2 = bl && object != null && (Boolean)((Rule)object).promptRequired.get() == false && ((Boolean)((Rule)object).userRequired.get() == false || user != null) && object3 != null;
        if (bl2) {
            atomicReference.set(object22);
            if (object3.equals(this._patientFile.stage.get())) {
                user = ((UserContext)UserContext.Impl.get()).getUser();
                ((UserStageChooserPanel)object22).setUser(user);
            }
        } else {
            jDialog2.setSize(390, 200);
            jDialog2.setVisible(true);
        }
        if (atomicBoolean.get()) {
            int n;
            if (((Stage)Stage.DataEntryQueue.get()).equals((Object)((UserStageChooserPanel)object22).getStage()) && ((RuleManager)((ScanBatch)this._patientFile.batch.get()).ruleManager.get()).getRuleSet().isCodingRequired() && this._patientFile.getCharges().isEmpty() && !this._chargesChangeSet.hasNewRecords() && (n = JOptionPane.showConfirmDialog(this._codingChargesTable, "You have chosen Data Entry for a Patient File that requires coding\nyet has no charges entered on it. Is this correct?")) != 0) {
                atomicReference.set(null);
            }
            if (atomicReference.get() == null && ((Stage)Stage.DataEntryComplete.get()).equals((Object)((UserStageChooserPanel)object22).getStage()) && !((UserContext)UserContext.Impl.get()).getUser().canDoDataEntry()) {
                JOptionPane.showMessageDialog(this._codingChargesTable, "You have chosen Data Entry Complete for a Patient File and only a user capable of doing data entry is authorized to do that.");
                atomicReference.set(null);
            }
        }
        return (UserStageChooserPanel)atomicReference.get();
    }

    boolean hasPendingChanges() {
        return this._chargesChangeSet.size() != 0 || this._notesChangeSet.size() != 0 || this._updatesPending;
    }

    private boolean applyChanges(boolean bl, boolean bl2, boolean bl3) {
        if (bl || this.hasPendingChanges()) {
            if (bl3 && this._updatedPatientFiles.contains(this._patientFile)) {
                JOptionPane.showMessageDialog(this._codingChargesTable, "This patient file (" + this._patientFile + ") has already been updated in this session.  Only one update per session is allowed.");
                return false;
            }
            UserStageChooserPanel userStageChooserPanel = this.showUserStageChooserDialog(bl3);
            if (userStageChooserPanel == null) {
                return false;
            }
            final Stage stage = userStageChooserPanel.getStage();
            final User user = userStageChooserPanel.getUser();
            final ChangeSet<CodingCharge> changeSet = this._chargesChangeSet;
            final ChangeSet<Note> changeSet2 = this._notesChangeSet;
            final PatientFile patientFile = this._patientFile;
            logger.debug((Object)"before submit async applyChanges in background finaledPatientFile = {}  finalStage = {}  finalUser = {}", (Object)patientFile, (Object)stage, (Object)user);
            if (stage == null) {
                JOptionPane.showMessageDialog((Component)this._root, "An error occurred (no stage) updating the stage please report this issue to support.");
                return false;
            }
            if (patientFile == null) {
                JOptionPane.showMessageDialog((Component)this._root, "An error occurred (no patient file) updating the stage please report this issue to support.");
                return false;
            }
            for (Object object : this._chargesChangeSet.getInserts()) {
                object.setPatientFile(patientFile);
                this._scanBatch.addCharge(object);
            }
            for (Object object : this._chargesChangeSet.getDeletes()) {
                this._scanBatch.removeCharge(object);
            }
            for (Object object : this._notesChangeSet.getDeletes()) {
                if (object.workflowNote == null) continue;
                this._scanBatch.removeNote(object.workflowNote);
            }
            DaoBackgroundExecutor.executeInGuiBackground((Runnable)new Runnable(){
                boolean _errors = false;

                @Override
                public void run() {
                    logger.debug((Object)"async applyChanges in background finaledPatientFile = {}  finalStage = {}  finalUser = {}", (Object)patientFile, (Object)stage, (Object)user);
                    try {
                        ScanningDao scanningDao = (ScanningDao)ScanningDao.Impl.get();
                        for (CodingCharge codingCharge : changeSet.getInserts()) {
                            try {
                                codingCharge.setPatientFile(patientFile);
                                scanningDao.insert((BaseBusinessBean)codingCharge);
                            }
                            catch (Exception exception) {
                                this._errors = true;
                                logger.error((Object)"error inserting {}", (Object)codingCharge, (Object)exception);
                            }
                        }
                        for (CodingCharge codingCharge : changeSet.getUpdates()) {
                            try {
                                codingCharge.setPatientFile(patientFile);
                                scanningDao.update((BaseBusinessBean)codingCharge);
                            }
                            catch (Exception exception) {
                                this._errors = true;
                                logger.error((Object)"error updating {}", (Object)codingCharge, (Object)exception);
                            }
                        }
                        for (CodingCharge codingCharge : changeSet.getDeletes()) {
                            try {
                                scanningDao.delete((BaseBusinessBean)codingCharge);
                            }
                            catch (Exception exception) {
                                this._errors = true;
                                logger.error((Object)"error deleting {}", (Object)codingCharge, (Object)exception);
                            }
                        }
                        CodingPanel.this.saveNotes((ChangeSet<Note>)changeSet2, patientFile);
                        try {
                            scanningDao.updateStage(patientFile, stage, user);
                        }
                        catch (Exception exception) {
                            this._errors = true;
                            logger.error((Object)"error updateStage on {}", (Object)patientFile, (Object)exception);
                        }
                        try {
                            scanningDao.update((BaseBusinessBean)patientFile);
                        }
                        catch (Exception exception) {
                            this._errors = true;
                            logger.error((Object)"error update on {}", (Object)patientFile, (Object)exception);
                        }
                    }
                    catch (Exception exception) {
                        this._errors = true;
                        logger.error((Object)exception);
                    }
                    if (this._errors) {
                        JOptionPane.showMessageDialog(CodingPanel.this._imageViewer, "Error updating patient file " + patientFile.id.get() + " please notify support.");
                    }
                }
            });
            this._updatedPatientFiles.add(this._patientFile);
            this._patientFile.updateStage(stage, user);
            this.updateTitleLabel();
            this._visitsModel.setItems(((ScanBatch)this._patientFile.batch.get()).patientFiles.get());
            this._visitsModel.setSelectedEntity(this._patientFile);
            this._codingTitlePanel.getPatientFilesDropDown().repaint();
            this.clearChangeTracking(false);
        }
        if (bl2) {
            this.disposeCodingPanelWindow();
        }
        return true;
    }

    void disposeCodingPanelWindow() {
        logger.debug((Object)"disposing the coding panel window for patientFileId = {}", (Object)this._patientFile.getId());
        SwingUtilities.getWindowAncestor((Component)this._root).dispose();
    }

    public void setPatientFile(PatientFile patientFile) {
        this.setPatientFile(patientFile, false);
    }

    public boolean isBatchTypeSplittable() {
        try {
            String string = this._patientFile.getBatch().getBatchType().getSplitting();
            return "Y".equals(string) || "A".equals(string);
        }
        catch (NullPointerException nullPointerException) {
            logger.error((Object)nullPointerException);
            return true;
        }
    }

    public boolean isBatchTypeAlwaysSplittable() {
        try {
            return "A".equals(this._patientFile.getBatch().getBatchType().getSplitting());
        }
        catch (NullPointerException nullPointerException) {
            logger.error((Object)nullPointerException);
            return false;
        }
    }

    public void setPatientFile(PatientFile patientFile, boolean bl) {
        Object object3;
        Object object22;
        if (patientFile == null) {
            return;
        }
        if (this._patientFile != null && this._patientFile.equals((Object)patientFile) && !bl) {
            return;
        }
        logger.debug((Object)"Switching to patient file {} for scan batch {}", (Object)patientFile.getId(), (Object)patientFile.getBatch().getId());
        if (!ObjectX.equals((Object)this._scanBatch, (Object)patientFile.batch.get())) {
            this._scanBatch = (ScanBatch)patientFile.batch.get();
            this._updatedPatientFiles.clear();
            this._batchVisibleImages = this._scanBatch.getVisibleImages();
            if (this._batchVisibleImages.size() <= this._deployEdgeProperties.getImagePrefetchThreshold()) {
                logger.debug((Object)"prefetch images for scan batch {}", this._scanBatch.id.get());
                patientFile.scheduleImageDownloading();
                for (Object object22 : ((ScanBatch)patientFile.batch.get()).patientFiles) {
                    if (object22.getId().equals(patientFile.getId())) continue;
                    object22.scheduleImageDownloading();
                }
            }
        }
        this._patientFile = patientFile;
        this._chargeSequenceCounter = this._patientFile.getMaxChargeSequence();
        this._noteSequenceCounter = this._patientFile.getMaxNoteSequence();
        List list = ListX.create();
        for (Object object3 : this._patientFile.getNotes()) {
            list.add(new Note((WorkflowNote)object3));
        }
        object22 = this._patientFile.getCharges();
        this._notesTaskPane.setCollapsed(list.isEmpty());
        this._chargesTaskPane.setCollapsed(object22.isEmpty());
        this.updateTitleLabel();
        object3 = this._patientFile.getVisibleImageProxies();
        this._imageViewer.setImageCollection((List<ImageProxy>)object3);
        if (object3.size() > 0) {
            this._imageViewer.resetImage((ImageProxy)object3.get(0));
        }
        this._imageViewer.showCreateNewPatientFileButton(this.isBatchTypeSplittable() && (this.isBatchTypeAlwaysSplittable() || ((Stage)Stage.CodingQueue.get()).equals((Object)this._patientFile.getStage()) || ((Stage)Stage.DataEntryQueue.get()).equals((Object)this._patientFile.getStage())));
        this._chargeEntryPanel.resetForm();
        this._codingChargesModel.setRows((List)object22);
        this._notesModel.setRows(list);
        this._notesTaskPane.setTitle(list.size() + " Notes");
        this._visitsModel.setItems(((ScanBatch)patientFile.batch.get()).patientFiles.get());
        this._visitsModel.setSelectedEntity(patientFile);
        this.setPatientFileHistory(patientFile);
        this._chargeEntryPanel.setPatientFile(this._patientFile);
        this.calcNextPrevButtonsState(0);
        this.clearChangeTracking(false);
        this.updateTaskpaneTitles();
        this.resetTableHeights();
    }

    private void updateTitleLabel() {
        String string = StringX.isNotBlank((String)((String)this._patientFile.patientNumber.get())) ? "Patient " + (String)this._patientFile.patientNumber.get() + " " + (String)this._patientFile.patientFirstName.get() + " " + (String)this._patientFile.patientMiddleName.get() + " " + (String)this._patientFile.patientLastName.get() : "";
        String string2 = "";
        if (this._patientFile.stage.get() != null) {
            string2 = (String)((Stage)this._patientFile.stage.get()).id.get();
        }
        this._codingTitlePanel.getTitleLabel().setText("Batch " + ((ScanBatch)this._patientFile.batch.get()).id.get() + " Patient File " + this._patientFile.id.get() + " Stage " + string2 + "  " + string);
    }

    void clearChangeTracking(boolean bl) {
        if (bl) {
            final PatientFile patientFile = this._patientFile;
            DaoBackgroundExecutor.executeInGuiBackground((Runnable)new Runnable(){

                @Override
                public void run() {
                    patientFile.refresh();
                }
            });
        }
        this._updatesPending = false;
        this._workflowNotePanel.getNoteTypeModel().setSelectedEntity(null);
        this._chargesChangeSet = ChangeSet.create();
        this._notesChangeSet = ChangeSet.create();
        this._notesChangeSet.setChangeListener((ChangeSet.ChangeListener)new ChangeSet.ChangeListener<Note>(){

            public void delete(Note note) {
                CodingPanel.this.updateTaskpaneTitles();
            }

            public void insert(Note note) {
                CodingPanel.this.updateTaskpaneTitles();
            }

            public void update(Note note) {
                CodingPanel.this.updateTaskpaneTitles();
            }
        });
        this._chargesChangeSet.setChangeListener((ChangeSet.ChangeListener)new ChangeSet.ChangeListener<CodingCharge>(){

            public void delete(CodingCharge codingCharge) {
                CodingPanel.this.updateTaskpaneTitles();
            }

            public void insert(CodingCharge codingCharge) {
                CodingPanel.this.updateTaskpaneTitles();
            }

            public void update(CodingCharge codingCharge) {
                CodingPanel.this.updateTaskpaneTitles();
            }
        });
    }

    boolean calcNextPrevButtonsState(int n) {
        return this.calcNextPrevButtonsState(n, false);
    }

    boolean calcNextPrevButtonsState(int n, boolean bl) {
        int n2;
        int n3;
        if (this.hasPendingChanges() || bl) {
            if (bl) {
                n3 = 0;
            } else {
                logger.debug((Object)"Displaying confirmation dialog for saving pending changes");
                n3 = JOptionPane.showOptionDialog((Component)this._root, "There are changes pending on the patient file. Would you like to apply them before proceeding? If you say no all changes will be lost.", "Apply Changes?", 1, 3, null, null, null);
            }
            if (n3 == 0) {
                logger.debug((Object)"User selected 'Yes'. Saving pending changes.");
                n2 = bl ? 1 : 0;
                if (!this.applyChanges(n2 != 0, false, bl)) {
                    return false;
                }
            } else if (n3 == 1) {
                logger.debug((Object)"User selected 'No'. Discarding pending changes.");
                this.clearChangeTracking(true);
            } else {
                logger.debug((Object)"User selected 'Cancel'. Remaining at current patient file.");
                return false;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < this._visitsModel.getSize(); ++n2) {
            if (!this._visitsModel.getEntityAt(n2).equals((Object)this._visitsModel.getSelectedEntity())) continue;
            n3 = n2;
            break;
        }
        if ((n3 += n) <= 0) {
            n3 = 0;
            this._codingTitlePanel.getPrevPatientFileButton().setEnabled(false);
        } else {
            this._codingTitlePanel.getPrevPatientFileButton().setEnabled(true);
        }
        if (n3 >= this._visitsModel.getSize() - 1) {
            n3 = this._visitsModel.getSize() - 1;
            this._codingTitlePanel.getNextPatientFileButton().setEnabled(false);
        } else {
            this._codingTitlePanel.getNextPatientFileButton().setEnabled(true);
        }
        this._visitsModel.setSelectedEntity(this._visitsModel.getEntityAt(n3));
        return true;
    }

    void resetTableHeights() {
        int n = 2 + Math.min(this._codingChargesModel.getRowCount(), 5);
        this._codingChargesTableScrollPane.setPreferredSize(new Dimension(400, n * 15));
        int n2 = 2 + Math.min(this._notesModel.getRowCount(), 5);
        this._notesTableScrollPane.setPreferredSize(new Dimension(400, n2 * 15));
        int n3 = 2 + Math.min(this._historyModel.getRowCount(), 5);
        this._historyTableScrollPane.setPreferredSize(new Dimension(400, n3 * 15));
    }

    public ScannedImage getCurrentImage() {
        List list = this._patientFile.getVisibleImages();
        if (list.size() > 0) {
            return (ScannedImage)list.get(this._imageViewer.getCurrentImageIndex());
        }
        return null;
    }

    public void udpateAndGotoNextPatientFile() {
        int n;
        if (this.isFirstStageAfterScanning() && (n = JOptionPane.showConfirmDialog((Component)this._root, "Are you sure you want to update this patient file (as opposed to update and splitting it)?", "Are you sure?", 0)) == 1) {
            return;
        }
        PatientFile patientFile = this._patientFile;
        if (this.calcNextPrevButtonsState(1, true) && patientFile == this._patientFile) {
            this.disposeCodingPanelWindow();
        }
    }

    public void setCptCodes(CompanyCPTCodes companyCPTCodes) {
        this._cptCodes = companyCPTCodes;
    }

    public ImageViewer getImageViewer() {
        return this._imageViewer;
    }

    boolean allowEntry() {
        return this._testing || ((UserContext)UserContext.Impl.get()).getAuthenticator().canEnterCharges();
    }

    private void submitPatientFileSplit(final PatientFileSplitType patientFileSplitType) {
        DaoBackgroundExecutor.executeInGuiBackground((Runnable)new Runnable(){

            @Override
            public void run() {
                CodingPanel.this.processPatientFileSplit(patientFileSplitType);
            }
        });
    }

    private void processPatientFileSplit(final PatientFileSplitType patientFileSplitType) {
        if (!this.isBatchTypeSplittable()) {
            return;
        }
        logger.debug((Object)("processPatientFileSplit(" + (Object)((Object)patientFileSplitType) + ")"));
        final ScannedImage scannedImage = (ScannedImage)this._imageViewer.getCurrentImage().getReferent();
        final Stage stage = this._patientFile.getStage();
        boolean bl = this.validatePatientFileSplit(patientFileSplitType);
        if (!bl) {
            return;
        }
        boolean bl2 = true;
        if (patientFileSplitType == PatientFileSplitType.chooseNextStageThenSplit) {
            bl2 = this.applyChanges(true, false, false);
        } else if (patientFileSplitType == PatientFileSplitType.gotoNextStageThenSplit) {
            bl2 = this.applyChanges(true, false, true);
        }
        if (!bl2) {
            return;
        }
        try {
            this.setBusyCursor();
            new Thread(){
                {
                    this.setName("NoteSavingThread");
                }

                @Override
                public void run() {
                    CodingPanel.this.saveNotes((ChangeSet<Note>)CodingPanel.this._notesChangeSet, CodingPanel.this._patientFile);
                }
            }.start();
            new Thread(){
                {
                    this.setName("NewPatientFileCreator");
                }

                @Override
                public void run() {
                    boolean bl = false;
                    try {
                        CodingPanel.this._dao.splitPatientFile(CodingPanel.this._patientFile, scannedImage.getPageNumber().intValue(), stage);
                        bl = true;
                        if (patientFileSplitType == PatientFileSplitType.splitAndClose || CodingPanel.this.closeWindowOnSplit(stage)) {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    logger.debug((Object)"split complete closing coding panel window");
                                    GuiHelper.getWindowAncestor((Component)CodingPanel.this._root).setVisible(false);
                                }
                            });
                        } else {
                            ScanBatch scanBatch = CodingPanel.this._dao.loadScanBatch(0L, CodingPanel.this._patientFile.getId().longValue());
                            CodingPanel.this.setPatientFile((PatientFile)scanBatch.getPatientFiles().get(scanBatch.getPatientFiles().size() - 1));
                        }
                    }
                    catch (Exception exception) {
                        if (bl) {
                            logger.error((Object)"error splitting patient file", (Object)exception);
                            JOptionPane.showMessageDialog((Component)CodingPanel.this._root, "Failed to start a new patient file", "Error", 0);
                        } else {
                            logger.error((Object)"error closing coding panel window", (Object)exception);
                            JOptionPane.showMessageDialog((Component)CodingPanel.this._root, "New patient file created, but there was an error closing the window. Close the window and try reopening this batch.", "Error", 0);
                        }
                    }
                    finally {
                        CodingPanel.this.setDefaultCursor();
                    }
                }
            }.start();
        }
        catch (Exception exception) {
            this.setDefaultCursor();
        }
    }

    boolean closeWindowOnSplit(Stage stage) {
        String string = this._patientFile.getBatch().getBatchType().getId();
        String string2 = stage.getId();
        boolean bl = string.equals("1") || string.equals("2") || string.equals("3") || string.equals("E");
        boolean bl2 = string2.equals("60");
        logger.debug(new Object[]{"closeWindowOnSplit()  bt = {}  stage = {}  closableBatch = {}  stage = {}", string, string2, bl, bl2});
        return bl2 && bl;
    }

    Stage getFirstStageAfterScanning() {
        return this._patientFile.getBatch().getRuleManager().getNextRequiredRule((Stage)Stage.ScanningInProgress.get()).getStage();
    }

    boolean isFirstStageAfterScanning() {
        return this.getFirstStageAfterScanning().equals((Object)this._patientFile.getStage());
    }

    private boolean validatePatientFileSplit(PatientFileSplitType patientFileSplitType) {
        int n = this._imageViewer.getCurrentImageIndex();
        Stage stage = this._patientFile.getStage();
        if (n == 0) {
            JOptionPane.showMessageDialog((Component)this._root, "Starting a new patient file from the first page is not allowed", "New Patient File Error", 0);
            return false;
        }
        if (!(patientFileSplitType != PatientFileSplitType.splitAndClose || this.isBatchTypeAlwaysSplittable() || (stage.equals((Object)Stage.CodingQueue.get()) || stage.equals((Object)Stage.DataEntryQueue.get())) && this.isBatchTypeSplittable())) {
            JOptionPane.showMessageDialog((Component)this._root, "Patient File splitting ignored if stage is not 30 or 60 and the batch is splittable, unless batch type is set to Always", "New Patient File Error", 0);
            return false;
        }
        if (n == -1) {
            logger.error((Object)"Attempting to process a patient file split, but the call to ImageViewer.getCurrentImageIndex() return -1", (Object)new RuntimeException());
            JOptionPane.showMessageDialog((Component)this._root, "Starting a new patient file unexpectedly failed. Try reopening the batch and attempting this operation again.", "New Patient File Error", 0);
            return false;
        }
        if (!this._patientFile.getBatch().getBatchType().allowPatientFileSplitting()) {
            JOptionPane.showMessageDialog((Component)this._root, "Patient File splitting is not permitted on this batch type", "New Patient File Error", 0);
            return false;
        }
        String string = patientFileSplitType == PatientFileSplitType.splitAndClose ? "This will split the patient file and the window will close after the split is\ncomplete.  The new patient file will appear in VM." : "This will split the patient file and bring up the new patient file in the window when the split is complete.";
        int n2 = JOptionPane.showConfirmDialog((Component)this._root, "Create a new patient file starting from the current image you are viewing?\n\n" + string, "New Patient File Confirmation", 0);
        return n2 != 1;
    }

    public void setBusyCursor() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setBusyCursorImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodingPanel.this.setBusyCursorImpl();
                }
            });
        }
    }

    private void setBusyCursorImpl() {
        if (!this._hourglassAdded) {
            GuiHelper.getRootLayeredPane((Component)this._root).add((Component)this._ahsHourglass, JLayeredPane.DRAG_LAYER);
            this._hourglassAdded = true;
        }
        this._ahsHourglass.setVisible(true);
    }

    public void setDefaultCursor() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setBusyCursorImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodingPanel.this.setDefaultCursorImpl();
                }
            });
        }
    }

    private void setDefaultCursorImpl() {
        this._ahsHourglass.setVisible(false);
    }

    public JComponent getWrappedLayer() {
        AbstractLayerUI<JComponent> abstractLayerUI = new AbstractLayerUI<JComponent>(){
            private static final long serialVersionUID = 1L;

            protected void paintLayer(Graphics2D graphics2D, JXLayer<? extends JComponent> jXLayer) {
                super.paintLayer(graphics2D, jXLayer);
            }

            protected void processMouseMotionEvent(MouseEvent mouseEvent, JXLayer<? extends JComponent> jXLayer) {
                int n = -2;
                Point point = GuiHelper.getRootLayeredPane((Component)CodingPanel.this._root).getLocationOnScreen();
                Point point2 = mouseEvent.getLocationOnScreen();
                CodingPanel.this._ahsHourglass.setLocation(point2.x - point.x + n, point2.y - point.y + n);
                CodingPanel.this._root.repaint();
            }
        };
        JXLayer jXLayer = new JXLayer((Component)this._root);
        jXLayer.setUI((LayerUI)abstractLayerUI);
        return jXLayer;
    }

    private void saveNotes(ChangeSet<Note> changeSet, PatientFile patientFile) {
        ScanningDao scanningDao = (ScanningDao)ScanningDao.Impl.get();
        for (Note note : changeSet.getInserts()) {
            try {
                WorkflowNote workflowNote = patientFile.addNote(note.text, note.type, note.sequence);
                scanningDao.insert((BaseBusinessBean)workflowNote);
            }
            catch (Exception exception) {
                logger.error((Object)"error inserting {}", (Object)note, (Object)exception);
            }
        }
        for (Note note : changeSet.getUpdates()) {
            try {
                note.workflowNote.setText(note.text);
                note.workflowNote.setType(note.type);
                scanningDao.update((BaseBusinessBean)note.workflowNote);
            }
            catch (Exception exception) {
                logger.error((Object)"error updating {}", (Object)note, (Object)exception);
            }
        }
        for (Note note : changeSet.getDeletes()) {
            try {
                scanningDao.delete((BaseBusinessBean)note.workflowNote);
            }
            catch (Exception exception) {
                logger.error((Object)"error deleting {}", (Object)note, (Object)exception);
            }
        }
    }

    private void scheduleImageDownloading() {
        if (this._batchVisibleImages.size() > this._deployEdgeProperties.getImagePrefetchThreshold()) {
            int n;
            ScannedImageProxy scannedImageProxy = (ScannedImageProxy)this._imageViewer.getCurrentImage();
            Long l = scannedImageProxy.getScannedImage().getId();
            int n2 = 0;
            for (n = 0; n < this._batchVisibleImages.size(); ++n) {
                if (!l.equals(this._batchVisibleImages.get(n).getId())) continue;
                n2 = n;
                break;
            }
            for (n = n2; n <= n2 + this._deployEdgeProperties.getImagePrefetchRange(); ++n) {
                if (n >= this._batchVisibleImages.size()) continue;
                this._batchVisibleImages.get(n).getImageProxy().scheduleDownload();
            }
            for (n = n2 - 1; n >= n2 - this._deployEdgeProperties.getImagePrefetchRange(); --n) {
                if (n < 0) continue;
                this._batchVisibleImages.get(n).getImageProxy().scheduleDownload();
            }
        }
    }

    private void setPatientFileHistory(PatientFile patientFile) {
        List list = patientFile.getTransactions();
        ArrayList<PatientFileTransaction> arrayList = new ArrayList<PatientFileTransaction>();
        String string = null;
        for (PatientFileTransaction patientFileTransaction : list) {
            if (patientFileTransaction.getStage().getId().equals(string)) continue;
            arrayList.add(patientFileTransaction);
            string = patientFileTransaction.getStage().getId();
        }
        this._historyModel.setRows(arrayList);
    }

    public ChargeEntryPanel getChargeEntryPanel() {
        return this._chargeEntryPanel;
    }

    private static class Note
    extends BaseBusinessBean<Note> {
        String text;
        WorkflowNoteType type;
        int sequence;
        WorkflowNote workflowNote;

        public Note(String string, WorkflowNoteType workflowNoteType, int n) {
            this.text = string;
            this.type = workflowNoteType;
            this.sequence = n;
        }

        public Note(WorkflowNote workflowNote) {
            this.text = workflowNote.getText();
            this.type = workflowNote.getType();
            this.sequence = workflowNote.getSequence();
            this.workflowNote = workflowNote;
        }

        DateTime getCreationTimestamp() {
            return this.workflowNote == null ? null : this.workflowNote.getCreationTimestamp();
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.sequence});
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public String toString() {
            return "Note(uid=" + (this.workflowNote == null ? "null" : this.workflowNote.getUid()) + ", text=" + this.text + ", type=" + this.type.toString() + ", sequence=" + this.sequence + ")";
        }
    }

    static enum PatientFileSplitType {
        splitAndClose,
        gotoNextStageThenSplit,
        chooseNextStageThenSplit;

    }
}

