/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.DefaultRowSorter;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.java.dev.properties.RProperty;
import net.java.dev.properties.container.IPropertyContext;
import net.model3x.swing.BeanTableModel;

public class CheckBoxFilterComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BeanTableModel<Object> _tableModel;
    private IPropertyContext _column;
    private Set<Object> _values = new HashSet<Object>();
    private Map<Object, JCheckBox> _checkBoxes = new HashMap<Object, JCheckBox>();
    private RowFilter<BeanTableModel<Object>, Integer> _rowFilter;
    private Set<Object> _allowedValues = new HashSet<Object>();

    public CheckBoxFilterComponent(BeanTableModel beanTableModel, IPropertyContext iPropertyContext) {
        this._tableModel = beanTableModel;
        this._column = iPropertyContext;
        this.setLayout(new BoxLayout(this, 1));
        this._tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                CheckBoxFilterComponent.this.refreshCheckBoxes();
            }
        });
        this.refreshCheckBoxes();
        CheckBoxFilterComponent.addFilterToRowSorter(this._tableModel.getRowSorter(), this.getRowFilter());
    }

    public static void addFilterToRowSorter(DefaultRowSorter defaultRowSorter, final RowFilter rowFilter) {
        if (defaultRowSorter.getRowFilter() == null) {
            defaultRowSorter.setRowFilter(rowFilter);
        } else {
            final RowFilter rowFilter2 = defaultRowSorter.getRowFilter();
            RowFilter<BeanTableModel, Integer> rowFilter3 = new RowFilter<BeanTableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends BeanTableModel, ? extends Integer> entry) {
                    return rowFilter2.include(entry) && rowFilter.include(entry);
                }
            };
            defaultRowSorter.setRowFilter(rowFilter3);
        }
    }

    void refreshCheckBoxes() {
        Object object;
        this._values.clear();
        for (Object object2 : this._tableModel.getRows()) {
            object = ((RProperty)this._column.getProperty(object2)).get();
            this._values.add(object);
        }
        Iterator<Object> iterator = this._values.iterator();
        while (iterator.hasNext()) {
            Object object2;
            object = object2 = iterator.next();
            JCheckBox jCheckBox = this._checkBoxes.get(object2);
            if (jCheckBox != null) continue;
            final JCheckBox jCheckBox2 = jCheckBox = new JCheckBox();
            jCheckBox.setSelected(true);
            jCheckBox.setText(object2.toString());
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (jCheckBox2.isSelected()) {
                        CheckBoxFilterComponent.this._allowedValues.add(object);
                    } else {
                        CheckBoxFilterComponent.this._allowedValues.remove(object);
                    }
                    CheckBoxFilterComponent.this.filterChanged();
                }
            });
            this._allowedValues.add(object2);
            this._checkBoxes.put(object2, jCheckBox);
            this.add(jCheckBox);
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void filterChanged() {
        this._tableModel.getRowSorter().sort();
    }

    public RowFilter<BeanTableModel<Object>, Integer> getRowFilter() {
        if (this._rowFilter == null) {
            this._rowFilter = new RowFilter<BeanTableModel<Object>, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends BeanTableModel<Object>, ? extends Integer> entry) {
                    Object object = CheckBoxFilterComponent.this._tableModel.getRow(entry.getIdentifier().intValue());
                    Object object2 = ((RProperty)CheckBoxFilterComponent.this._column.getProperty(object)).get();
                    return CheckBoxFilterComponent.this._allowedValues.contains(object2);
                }
            };
        }
        return this._rowFilter;
    }
}

