/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import com.ahsrcm.client.scanning.gui.BeanpropsPopperUpper;
import com.ahsrcm.client.scanning.gui.FormHelper;
import com.ahsrcm.client.scanning.gui.IntegerField;
import com.ahsrcm.client.scanning.gui.ReferralSelector;
import com.ahsrcm.client.scanning.gui.ResettableForm;
import com.ahsrcm.client.scanning.gui.SelectionPopup;
import com.ahsrcm.client.scanning.gui.TextFieldWithPopup;
import com.ahsrcm.core.virtualmanager.ReferralDTO;
import com.ahsrcm.corp.CodingCharge;
import com.ahsrcm.corp.Division;
import com.ahsrcm.corp.Doctor;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.cdl.CDLEntity;
import com.ahsrcm.corp.dto.CompanyCPTCodes;
import com.ahsrcm.corp.dto.CptAsaProcedure;
import com.ahsrcm.corp.dto.CptCode;
import com.ahsrcm.corp.dto.CptDiagnosis;
import com.ahsrcm.corp.dto.CptModifier;
import com.ahsrcm.corp.dto.CptProcedure;
import com.ahsrcm.corp.dto.ScanBatchDTO;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.TimeZoneFixer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.java.dev.properties.Property;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.ObservableIndexed;
import net.model3.chrono.DateOnly;
import net.model3.chrono.Month;
import net.model3.collections.ListX;
import net.model3.imaging.Size;
import net.model3.lang.AbstractComparable;
import net.model3.lang.ClassX;
import net.model3.lang.Pair;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.swing.GuiHelper;
import net.model3x.swing.AbstractColumnHandler;
import net.model3x.swing.BeanListener;
import net.model3x.swing.ColumnHandler;
import net.model3x.swing.M3Panel;
import net.model3x.swing.datechooser.TextFieldDateOnlyChooser;
import net.model3x.swing.domviewer.ComponentTreeModelBuilder;

public class ChargeEntryPanel
extends M3Panel
implements ResettableForm {
    private static final Log logger = LogHelper.getLog();
    private static final int COLUMNS_PROC = 6;
    private static final int COLUMNS_DIA = 8;
    private static final int COLUMNS_MOD = 3;
    private static final int COLUMNS_TRANSPORT_REASON = 4;
    private static final int COLUMNS_CONDITION_CODE = 4;
    private static final long serialVersionUID = 1L;
    private final TextFieldWithPopup _priorProcedureTF = new TextFieldWithPopup(6);
    private final TextFieldWithPopup _procedureTF = new TextFieldWithPopup(6);
    private int _procedureTpf;
    private final JLabel _procedureTpfLabel = new JLabel("X");
    private final TextFieldWithPopup _asaProcedureTF;
    private int _asaProcedureTpf;
    private final JLabel _asaProcedureTpfLabel;
    private final TextFieldWithPopup _transportReasonTF;
    private final List<JComponent> _conditionCodeComponents;
    private final JCheckBox _reuseDiagnosisCB;
    private final TextFieldWithPopup[] _conditionCodeTFs;
    private final TextFieldWithPopup[] _diagnosisTFs;
    private final TextFieldWithPopup[] _modifierTFs;
    private final JButton _enterButton;
    private CptProcedure _currentProcedure;
    CompanyCPTCodes _companyCPTCodes;
    private boolean _update;
    private CodingCharge _codingCharge;
    private CodingCharge _previousCodingCharge;
    private final JPanel _errorMessagesPanel;
    private SelectionPopup<?> _selectionPopup;
    private PatientFile _patientFile;
    private Listener _chargeEntryPanelListener;
    boolean _cptCodeLoadingStarted;
    TextFieldWithPopup _locationTF;
    TextFieldWithPopup _doctorTF;
    TextFieldWithPopup _referralTF;
    JTextField _accessionNumberTF;
    IntegerField _tpfTF;
    JTextField _medicalRecordNumTF;
    final ScanBatchDTO _scanBatchDTO;
    TextFieldDateOnlyChooser _dateOfServiceDC;

    public static void main(String[] stringArray) throws Exception {
        new SimpleLoggingConfigurator().addConsoleAppender();
        System.setProperty("app.name", "ahs");
        UIManager.setLookAndFeel(new MetalLookAndFeel());
        ChargeEntryPanel chargeEntryPanel = new ChargeEntryPanel(new CompanyCPTCodes(), new ScanBatchDTO());
        chargeEntryPanel._errorMessagesPanel.add(new JLabel("blah blah blah blah blah blah blah blah blah blah blah blah blah blah"));
        GuiHelper.createFrame((JComponent)((Object)chargeEntryPanel));
        ComponentTreeModelBuilder.addFrameMenus();
    }

    public ChargeEntryPanel(CompanyCPTCodes companyCPTCodes, ScanBatchDTO scanBatchDTO) {
        TextFieldWithPopup textFieldWithPopup;
        int n;
        this._procedureTpfLabel.setVisible(false);
        this._asaProcedureTF = new TextFieldWithPopup(6);
        this._asaProcedureTpfLabel = new JLabel("X");
        this._asaProcedureTpfLabel.setText("X");
        this._asaProcedureTpfLabel.setVisible(false);
        this._transportReasonTF = new TextFieldWithPopup(4);
        this._conditionCodeComponents = ListX.create();
        this._reuseDiagnosisCB = new JCheckBox();
        this._conditionCodeTFs = new TextFieldWithPopup[5];
        this._diagnosisTFs = new TextFieldWithPopup[4];
        this._modifierTFs = new TextFieldWithPopup[4];
        this._enterButton = new JButton();
        this._errorMessagesPanel = new JPanel();
        this._chargeEntryPanelListener = new Listener(){

            @Override
            public void applyCodingCharge(CodingCharge codingCharge, boolean bl) {
            }
        };
        this._cptCodeLoadingStarted = false;
        this._locationTF = new TextFieldWithPopup(4);
        this._doctorTF = new TextFieldWithPopup(5);
        this._referralTF = new TextFieldWithPopup(5);
        this._accessionNumberTF = new JTextField(20);
        this._tpfTF = new IntegerField(3);
        this._medicalRecordNumTF = new JTextField(20);
        this._dateOfServiceDC = new TextFieldDateOnlyChooser();
        Dimension dimension = this._dateOfServiceDC.getPreferredSize();
        dimension.width = 115;
        this._dateOfServiceDC.setPreferredSize(dimension);
        this._companyCPTCodes = companyCPTCodes;
        this._scanBatchDTO = scanBatchDTO;
        this.setBackground(Color.white);
        this.clearErrors();
        this._errorMessagesPanel.setOpaque(false);
        this._errorMessagesPanel.removeAll();
        this._errorMessagesPanel.setLayout(new BoxLayout(this._errorMessagesPanel, 1));
        this.add(new JLabel("DOS"), "right");
        this.add((Component)this._dateOfServiceDC, "");
        this.addEnterKeyListener((JComponent)this._dateOfServiceDC);
        this.add(new JLabel("LOS"), "right, spanx 3");
        this.add(this._locationTF, "left, spanx 2");
        this.addEnterKeyListener(this._locationTF);
        this.add(new JLabel("Doctor"), "right, spanx 4");
        this.add(this._doctorTF, "");
        this.addEnterKeyListener(this._doctorTF);
        this.add(new JLabel("Ref Doctor"), "right");
        this.add(this._referralTF, "");
        this.addEnterKeyListener(this._referralTF);
        this.add(new JLabel("Accession#"), "right, spanx 2");
        this.add(this._accessionNumberTF, "wrap, spanx");
        this.addEnterKeyListener(this._accessionNumberTF);
        this.add(new JLabel("Proc"), "right");
        this.add(this._procedureTF);
        this.addEnterKeyListener(this._procedureTF);
        this.add(new JLabel("BU"), "right");
        this.add(this._procedureTpfLabel, "");
        this.add(new JLabel("ASA"), "right");
        this.add(this._asaProcedureTF, "");
        this.addEnterKeyListener(this._asaProcedureTF);
        this.add(new JLabel("BU"), "right");
        this.add(this._asaProcedureTpfLabel, "");
        this.add(new JLabel("Reuse"), "right");
        this.add(this._reuseDiagnosisCB, "");
        this._reuseDiagnosisCB.setBackground(Color.white);
        this.add(new JLabel("Dia"), "right");
        for (n = 0; n < this._diagnosisTFs.length; ++n) {
            textFieldWithPopup = this._diagnosisTFs[n] = new TextFieldWithPopup(8);
            this.addEnterKeyListener(textFieldWithPopup);
            this.add(textFieldWithPopup, "");
            textFieldWithPopup.setPopperUpper(new TextFieldWithPopup.PopperUpper(){

                @Override
                public void showPopup(TextFieldWithPopup textFieldWithPopup2) {
                    ChargeEntryPanel.this.showDiagnosisPopup(textFieldWithPopup);
                }
            });
        }
        this.add(new JLabel("Mod"), "right");
        for (n = 0; n < this._modifierTFs.length; ++n) {
            textFieldWithPopup = this._modifierTFs[n] = new TextFieldWithPopup(3);
            this.add(textFieldWithPopup, "");
            this.addEnterKeyListener(textFieldWithPopup);
            textFieldWithPopup.setPopperUpper(new TextFieldWithPopup.PopperUpper(){

                @Override
                public void showPopup(TextFieldWithPopup textFieldWithPopup2) {
                    ChargeEntryPanel.this.showModifierPopup(textFieldWithPopup);
                }
            });
        }
        this.add(new JLabel("TPF"), "right");
        this.add((Component)((Object)this._tpfTF), "wrap");
        this.add(new JLabel("Prior Proc"), "right");
        this.add(this._priorProcedureTF, "");
        this.addEnterKeyListener(this._priorProcedureTF);
        if (this._scanBatchDTO.showMedicalRecordNum) {
            this.add(new JLabel("MRN"), "right, spanx 2");
            this.add(this._medicalRecordNumTF, "wrap, spanx");
            this.addEnterKeyListener(this._medicalRecordNumTF);
        }
        JLabel jLabel = new JLabel("Condition Code");
        this._conditionCodeComponents.add(jLabel);
        this.add(jLabel, "right, skip 6, span 3");
        for (int i = 0; i < this._conditionCodeTFs.length; ++i) {
            this._conditionCodeTFs[i] = new TextFieldWithPopup(4);
            JComponent jComponent = this._conditionCodeTFs[i];
            this.addEnterKeyListener(jComponent);
            this._conditionCodeComponents.add(jComponent);
            if (i == 0) {
                this.add(jComponent, "span 4, split 5");
            } else {
                this.add(jComponent, "");
            }
            ((TextFieldWithPopup)jComponent).setPopperUpper(new TextFieldWithPopup.PopperUpper((TextFieldWithPopup)jComponent){
                final /* synthetic */ TextFieldWithPopup val$tf;
                {
                    this.val$tf = textFieldWithPopup;
                }

                @Override
                public void showPopup(TextFieldWithPopup textFieldWithPopup) {
                    ChargeEntryPanel.this.showConditionCodePopup(this.val$tf);
                }
            });
        }
        this.add(this._enterButton, "aligny top, skip 3, spanx, width pref*2, height pref*1.2, spany, wrap");
        jLabel = new JLabel("Transport Reason");
        this._conditionCodeComponents.add(jLabel);
        this.add(jLabel, "right, skip 8, span 3");
        this._conditionCodeComponents.add(this._transportReasonTF);
        this.add(this._transportReasonTF, "");
        this._transportReasonTF.setPopperUpper(new TextFieldWithPopup.PopperUpper(){

            @Override
            public void showPopup(TextFieldWithPopup textFieldWithPopup) {
                ChargeEntryPanel.this.showTransportReasonPopup(ChargeEntryPanel.this._transportReasonTF);
            }
        });
        this.add(this._errorMessagesPanel, "newline, spanx 20");
        this._enterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChargeEntryPanel.this.applyEnterButton();
            }
        });
        this._procedureTF.getTextField().getDocument().addDocumentListener(new CodingDocumentListener(){

            @Override
            void validateIt(String string) {
                ChargeEntryPanel.this.setCurrentProcedure(ChargeEntryPanel.this._companyCPTCodes.lookupProcedure(string));
            }
        });
        this._asaProcedureTF.getTextField().getDocument().addDocumentListener(new CodingDocumentListener(){

            @Override
            void validateIt(String string) {
                CptAsaProcedure cptAsaProcedure;
                ChargeEntryPanel.this._asaProcedureTpfLabel.setText("X");
                ChargeEntryPanel.this._asaProcedureTpfLabel.setVisible(false);
                ChargeEntryPanel.this._asaProcedureTpf = 0;
                if (ChargeEntryPanel.this._currentProcedure != null && (cptAsaProcedure = ChargeEntryPanel.this._currentProcedure.getAsaProcedure(string, ChargeEntryPanel.this.getDateOfService())) != null) {
                    ChargeEntryPanel.this._asaProcedureTpfLabel.setText("" + cptAsaProcedure.getTimesPerformed());
                    ChargeEntryPanel.this._asaProcedureTpfLabel.setVisible(true);
                    ChargeEntryPanel.this._asaProcedureTpf = cptAsaProcedure.getTimesPerformed();
                }
            }
        });
        this._referralTF.setPopperUpper(new TextFieldWithPopup.PopperUpper(){

            @Override
            public void showPopup(TextFieldWithPopup textFieldWithPopup) {
                ReferralDTO referralDTO = ReferralSelector.popupSelector((Location)((ScanBatch)((ChargeEntryPanel)ChargeEntryPanel.this)._patientFile.batch.get()).location.get(), (Component)ChargeEntryPanel.this._referralTF);
                if (referralDTO != null) {
                    ChargeEntryPanel.this._referralTF.setText(referralDTO.id);
                }
            }
        });
        this._doctorTF.setPopperUpper(new BeanpropsPopperUpper<Doctor>(){

            @Override
            public List<IPropertyContext> columns() {
                return ListX.create((Object[])new IPropertyContext[]{Doctor.$id, Doctor.$lastName, Doctor.$firstName});
            }

            @Override
            public void rowSelected(Doctor doctor, TextFieldWithPopup textFieldWithPopup) {
                textFieldWithPopup.setText((String)doctor.id.get());
            }

            @Override
            public List<Doctor> possibleValues() {
                return ChargeEntryPanel.this._patientFile.getCDLEntity().getDivision().getActiveDoctors();
            }
        });
        this._locationTF.setPopperUpper(new BeanpropsPopperUpper<Location>(){

            @Override
            public List<IPropertyContext> columns() {
                return ListX.create((Object[])new IPropertyContext[]{Location.$id, Location.$name});
            }

            @Override
            public void rowSelected(Location location, TextFieldWithPopup textFieldWithPopup) {
                textFieldWithPopup.setText((String)location.id.get());
            }

            @Override
            public List<Location> possibleValues() {
                return ChargeEntryPanel.this._patientFile.getCDLEntity().getDivision().getActiveLocations();
            }
        });
        this._locationTF.setPopperUpper(new BeanpropsPopperUpper<Location>(){

            @Override
            public List<IPropertyContext> columns() {
                return ListX.create((Object[])new IPropertyContext[]{Location.$id, Location.$name});
            }

            @Override
            public void rowSelected(Location location, TextFieldWithPopup textFieldWithPopup) {
                textFieldWithPopup.setText((String)location.id.get());
            }

            @Override
            public List<Location> possibleValues() {
                return ChargeEntryPanel.this._patientFile.getCDLEntity().getDivision().getActiveLocations();
            }
        });
        this._procedureTF.setPopperUpper(new TextFieldWithPopup.PopperUpper(){

            @Override
            public void showPopup(TextFieldWithPopup textFieldWithPopup) {
                ChargeEntryPanel.this.showProcedurePopup(textFieldWithPopup);
            }
        });
        this._priorProcedureTF.setPopperUpper(new TextFieldWithPopup.PopperUpper(){

            @Override
            public void showPopup(TextFieldWithPopup textFieldWithPopup) {
                ChargeEntryPanel.this.showProcedurePopup(textFieldWithPopup);
            }
        });
        this._asaProcedureTF.setPopperUpper(new TextFieldWithPopup.PopperUpper(){

            @Override
            public void showPopup(TextFieldWithPopup textFieldWithPopup) {
                ChargeEntryPanel.this.showAsaProcedurePopup();
            }
        });
        this._reuseDiagnosisCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChargeEntryPanel.this._reuseDiagnosisCB.isSelected() && ChargeEntryPanel.this._previousCodingCharge != null) {
                    ChargeEntryPanel.this._diagnosisTFs[0].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.diagnosis1Code.get());
                    ChargeEntryPanel.this._diagnosisTFs[1].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.diagnosis2Code.get());
                    ChargeEntryPanel.this._diagnosisTFs[2].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.diagnosis3Code.get());
                    ChargeEntryPanel.this._diagnosisTFs[3].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.diagnosis4Code.get());
                    ChargeEntryPanel.this._accessionNumberTF.setText(ChargeEntryPanel.this._previousCodingCharge.getAccessionNumber());
                    ChargeEntryPanel.this._transportReasonTF.setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.transportationReason.get());
                    ChargeEntryPanel.this._doctorTF.setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.doctorId.get());
                    ChargeEntryPanel.this._conditionCodeTFs[0].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.conditionCode1.get());
                    ChargeEntryPanel.this._conditionCodeTFs[1].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.conditionCode2.get());
                    ChargeEntryPanel.this._conditionCodeTFs[2].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.conditionCode3.get());
                    ChargeEntryPanel.this._conditionCodeTFs[3].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.conditionCode4.get());
                    ChargeEntryPanel.this._modifierTFs[0].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.modifier1Code.get());
                    ChargeEntryPanel.this._modifierTFs[1].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.modifier2Code.get());
                    ChargeEntryPanel.this._modifierTFs[2].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.modifier3Code.get());
                    ChargeEntryPanel.this._modifierTFs[3].setText((String)((ChargeEntryPanel)ChargeEntryPanel.this)._previousCodingCharge.modifier4Code.get());
                }
            }
        });
        this.setCodingCharge(new CodingCharge(true), false);
        this.hardCodeFocusTraversal();
        for (JComponent jComponent : this._conditionCodeComponents) {
            jComponent.setVisible(this._scanBatchDTO.showAmbulanceFields);
        }
    }

    private void hardCodeFocusTraversal() {
        final List list = ListX.create();
        list.add(this._procedureTF.getTextField());
        list.add(this._asaProcedureTF.getTextField());
        list.add(this._reuseDiagnosisCB);
        for (TextFieldWithPopup textFieldWithPopup : this._diagnosisTFs) {
            list.add(textFieldWithPopup.getTextField());
        }
        for (TextFieldWithPopup textFieldWithPopup : this._modifierTFs) {
            list.add(textFieldWithPopup.getTextField());
        }
        list.add(this._tpfTF.getTextField());
        list.add(this._enterButton);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container container, Component component) {
                try {
                    return (Component)list.get(list.indexOf(component) + 1);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                try {
                    return (Component)list.get(list.indexOf(component) - 1);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            @Override
            public Component getDefaultComponent(Container container) {
                return (Component)list.get(0);
            }

            @Override
            public Component getFirstComponent(Container container) {
                return (Component)list.get(0);
            }

            @Override
            public Component getLastComponent(Container container) {
                return (Component)list.get(list.size() - 1);
            }
        });
    }

    public final void addEnterKeyListener(JComponent jComponent) {
        jComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ChargeEntryPanel.this.applyEnterButton();
                }
            }
        });
    }

    public final void setCodingCharge(CodingCharge codingCharge, boolean bl) {
        this.setCodingCharge(codingCharge, bl, false);
    }

    private void setCodingCharge(CodingCharge codingCharge, boolean bl, boolean bl2) {
        if (!bl2) {
            this._previousCodingCharge = this._codingCharge;
        }
        this._update = bl;
        if (this._update) {
            this._enterButton.setText("Update");
        } else {
            this._enterButton.setText("Enter");
        }
        this._codingCharge = codingCharge;
        this.codingChargeToGui();
    }

    void codingChargeToGui() {
        this.resetForm();
        Date date = (Date)this._codingCharge.dateOfService.get();
        if (date != null) {
            this._dateOfServiceDC.setValue(new DateOnly(this.fixDate(date)));
        }
        this._priorProcedureTF.setText((String)this._codingCharge.priorProcedureCode.get());
        this._procedureTF.setText((String)this._codingCharge.procedureCode.get());
        this._asaProcedureTF.setText((String)this._codingCharge.asaProcedureCode.get());
        this._diagnosisTFs[0].setText((String)this._codingCharge.diagnosis1Code.get());
        this._diagnosisTFs[1].setText((String)this._codingCharge.diagnosis2Code.get());
        this._diagnosisTFs[2].setText((String)this._codingCharge.diagnosis3Code.get());
        this._diagnosisTFs[3].setText((String)this._codingCharge.diagnosis4Code.get());
        this._modifierTFs[0].setText((String)this._codingCharge.modifier1Code.get());
        this._modifierTFs[1].setText((String)this._codingCharge.modifier2Code.get());
        this._modifierTFs[2].setText((String)this._codingCharge.modifier3Code.get());
        this._modifierTFs[3].setText((String)this._codingCharge.modifier4Code.get());
        this._conditionCodeTFs[0].setText((String)this._codingCharge.conditionCode1.get());
        this._conditionCodeTFs[1].setText((String)this._codingCharge.conditionCode2.get());
        this._conditionCodeTFs[2].setText((String)this._codingCharge.conditionCode3.get());
        this._conditionCodeTFs[3].setText((String)this._codingCharge.conditionCode4.get());
        this._conditionCodeTFs[4].setText((String)this._codingCharge.conditionCode5.get());
        this._transportReasonTF.setText((String)this._codingCharge.transportationReason.get());
        this._locationTF.setText((String)this._codingCharge.locationId.get());
        this._doctorTF.setText((String)this._codingCharge.doctorId.get());
        this._referralTF.setText((String)this._codingCharge.referralId.get());
        this._accessionNumberTF.setText((String)this._codingCharge.accessionNumber.get());
        this._tpfTF.setValue((Integer)this._codingCharge.timesPerformed.get());
    }

    @Override
    public void resetForm() {
        FormHelper.resetForm((Container)((Object)this));
        this._reuseDiagnosisCB.setSelected(false);
        this._tpfTF.setValue(0);
        this._accessionNumberTF.setText("");
        this._transportReasonTF.setText("");
        for (TextFieldWithPopup textFieldWithPopup : this._conditionCodeTFs) {
            textFieldWithPopup.setText("");
        }
    }

    public void setPatientFile(PatientFile patientFile) {
        if (patientFile == null) {
            logger.warn((Object)"Setting null patient file on the ChargeEntryPanel");
        }
        this._patientFile = patientFile;
        this._dateOfServiceDC.setValue(new DateOnly(this.fixDate((Date)((ScanBatch)this._patientFile.batch.get()).dateOfService.get())));
        Location location = this._patientFile.getCDLEntity().getLocation();
        if (location != null) {
            this._locationTF.setText((String)location.id.get());
        } else {
            this._locationTF.setText("");
        }
        Doctor doctor = (Doctor)((ScanBatch)this._patientFile.batch.get()).doctor.get();
        if (doctor != null) {
            this._doctorTF.setText((String)doctor.id.get());
        } else {
            this._doctorTF.setText("");
        }
    }

    void validateCodingCharge() {
        boolean bl;
        CptProcedure cptProcedure;
        this.clearErrors();
        this.validateCPTCodingField(this._procedureTF, null, CptProcedure.class, (Property<String>)this._codingCharge.procedureCode, true, 5);
        this.validateCPTCodingField(this._priorProcedureTF, "Prior Procedure", CptProcedure.class, (Property<String>)this._codingCharge.priorProcedureCode, false, 5);
        if (StringX.isNotBlank((String)this._asaProcedureTF.getText()) && (cptProcedure = this._companyCPTCodes.lookupProcedure((String)this._codingCharge.procedureCode.get())) != null && cptProcedure.getAsaProcedure(this._asaProcedureTF.getText(), this.getDateOfService()) == null) {
            this.addError(this._asaProcedureTF.getText() + " is not a valid ASA code for procedure " + this._procedureTF.getText());
        }
        if (this._scanBatchDTO.mandatoryDoctor && StringX.isBlank((String)this._doctorTF.getText())) {
            this.addError("doctor is required");
        }
        this.validateASACode(this._asaProcedureTF, (Property<String>)this._codingCharge.asaProcedureCode);
        this.validateCPTCodingField(this._diagnosisTFs[0], null, CptDiagnosis.class, (Property<String>)this._codingCharge.diagnosis1Code, false, 8);
        this.validateCPTCodingField(this._diagnosisTFs[1], null, CptDiagnosis.class, (Property<String>)this._codingCharge.diagnosis2Code, false, 8);
        this.validateCPTCodingField(this._diagnosisTFs[2], null, CptDiagnosis.class, (Property<String>)this._codingCharge.diagnosis3Code, false, 8);
        this.validateCPTCodingField(this._diagnosisTFs[3], null, CptDiagnosis.class, (Property<String>)this._codingCharge.diagnosis4Code, false, 8);
        this.validateCPTCodingField(this._modifierTFs[0], null, CptModifier.class, (Property<String>)this._codingCharge.modifier1Code, false, 2);
        this.validateCPTCodingField(this._modifierTFs[1], null, CptModifier.class, (Property<String>)this._codingCharge.modifier2Code, false, 2);
        this.validateCPTCodingField(this._modifierTFs[2], null, CptModifier.class, (Property<String>)this._codingCharge.modifier3Code, false, 2);
        this.validateCPTCodingField(this._modifierTFs[3], null, CptModifier.class, (Property<String>)this._codingCharge.modifier4Code, false, 2);
        this._codingCharge.procedureBaseUnits.set((Object)this._procedureTpf);
        this._codingCharge.asaProcedureBaseUnits.set((Object)this._asaProcedureTpf);
        cptProcedure = this._dateOfServiceDC.getValue();
        if (cptProcedure == null) {
            this.addError("DOS is required");
        } else if (cptProcedure.greaterThan((AbstractComparable)new DateOnly())) {
            this.addError("DOS cannot be in the future");
        } else if (cptProcedure.lessThan((AbstractComparable)new DateOnly().add(1, -5))) {
            this.addError("DOS cannot be prior to five years in the past");
        } else {
            this._codingCharge.dateOfService.set((Object)new Date(cptProcedure.inMillis()));
        }
        this.validateDoctor();
        this.validateLocationOfService();
        if (this._scanBatchDTO.validatePracticeGroup && !(bl = ((ScanningDao)ClientScanningDao.Impl.get()).practiceGroupExists(this._patientFile.getBatch().getId().longValue(), this._doctorTF.getText(), this._locationTF.getText()))) {
            this.addError("LOS / Doctor combination is not valid");
        }
        if (this._scanBatchDTO.mandatoryAccessionNum && StringX.isBlank((String)this._accessionNumberTF.getText())) {
            this.addError("Accession# is required");
        }
        if (this._scanBatchDTO.showMedicalRecordNum) {
            if (StringX.isBlank((String)this._medicalRecordNumTF.getText())) {
                this.addError("MRN is required");
            } else {
                this._codingCharge.medicalRecordNum.set((Object)this._medicalRecordNumTF.getText());
            }
        }
        this._codingCharge.accessionNumber.set((Object)this._accessionNumberTF.getText());
        this._codingCharge.referralId.set((Object)this._referralTF.getText());
        this._codingCharge.timesPerformed.set((Object)this._tpfTF.getValue());
        this._codingCharge.conditionCode1.set((Object)this._conditionCodeTFs[0].getText());
        this._codingCharge.conditionCode2.set((Object)this._conditionCodeTFs[1].getText());
        this._codingCharge.conditionCode3.set((Object)this._conditionCodeTFs[2].getText());
        this._codingCharge.conditionCode4.set((Object)this._conditionCodeTFs[3].getText());
        this._codingCharge.conditionCode5.set((Object)this._conditionCodeTFs[4].getText());
        this._codingCharge.transportationReason.set((Object)this._transportReasonTF.getText());
        GuiHelper.doLayoutHack((Component)this.getParent());
    }

    void validateDoctor() {
        String string = this._doctorTF.getText().trim();
        if (StringX.isNotBlank((String)string)) {
            for (Doctor doctor : this._patientFile.getCDLEntity().getDivision().doctors.get()) {
                if (!((String)doctor.id.get()).equals(string)) continue;
                this._codingCharge.doctorId.set((Object)((String)doctor.id.get()));
                return;
            }
            this.addError("Doctor " + string + " not found.");
        } else {
            this._codingCharge.doctorId.set((Object)"");
        }
    }

    void validateLocationOfService() {
        String string = this._locationTF.getText().trim();
        if (StringX.isNotBlank((String)string)) {
            CDLEntity cDLEntity = this._patientFile.getCDLEntity();
            Division division = cDLEntity.getDivision();
            ObservableIndexed observableIndexed = division.locations;
            for (Location location : observableIndexed.get()) {
                if (!((String)location.id.get()).equals(string)) continue;
                this._codingCharge.locationId.set((Object)((String)location.id.get()));
                return;
            }
            this.addError("Location " + string + " not found.");
        } else {
            this._codingCharge.locationId.set((Object)"");
        }
    }

    final void clearErrors() {
        this._errorMessagesPanel.removeAll();
    }

    void addError(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBackground(Color.white);
        jLabel.setForeground(Color.RED);
        this._errorMessagesPanel.add(jLabel);
    }

    void validateASACode(TextFieldWithPopup textFieldWithPopup, Property<String> property) {
        if (this._currentProcedure == null) {
            return;
        }
        if (StringX.isBlank((String)textFieldWithPopup.getText())) {
            property.set((Object)"");
            return;
        }
        CptAsaProcedure cptAsaProcedure = this._currentProcedure.getAsaProcedure(textFieldWithPopup.getText(), this.getDateOfService());
        if (cptAsaProcedure == null) {
            this.addError("ASA Code " + textFieldWithPopup.getText() + " not found.");
            return;
        }
        property.set((Object)cptAsaProcedure.getCode());
    }

    <T extends CptCode> void validateCPTCodingField(TextFieldWithPopup textFieldWithPopup, String string, Class<T> clazz, Property<String> property, boolean bl, int n) {
        if (string == null && (string = ClassX.getShortName(clazz)).startsWith("Cpt")) {
            string = string.substring(3);
        }
        if (StringX.isBlank((String)textFieldWithPopup.getText())) {
            if (bl) {
                this.addError(string + " must be entered");
                return;
            }
        } else {
            String string2 = StringX.padRight((Object)textFieldWithPopup.getText(), (int)n);
            CptCode cptCode = this._companyCPTCodes.lookup(clazz, string2);
            if (cptCode == null) {
                this.addError(string + " " + textFieldWithPopup.getText() + " not found.");
                return;
            }
        }
        property.set((Object)textFieldWithPopup.getText());
    }

    private java.util.Date fixDate(Date date) {
        return TimeZoneFixer.fixDate((Date)date);
    }

    Object[] getCptCodingKey(String string) {
        return new Object[]{this._companyCPTCodes.getCompanyCode(), 1};
    }

    void showAsaProcedurePopup() {
        if (this._currentProcedure == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a procedure before looking up an asa code", "Message", 1);
            return;
        }
        if (this._currentProcedure.getAsaProcedureCount(this.getDateOfService()) == 0) {
            String string = "Procedure " + this._currentProcedure.getCode() + " has no asa procedure codes";
            JOptionPane.showMessageDialog(this._asaProcedureTF, string, "No asa codes to show", -1);
            return;
        }
        if (this._selectionPopup != null) {
            this._selectionPopup.close();
            this._selectionPopup = null;
        }
        SelectionPopup<CptAsaProcedure> selectionPopup = new SelectionPopup<CptAsaProcedure>("Select Procedure", "asaProcedurePopup", CptAsaProcedure.class);
        this._selectionPopup = selectionPopup;
        selectionPopup.addColumn((ColumnHandler<CptAsaProcedure>)new AbstractColumnHandler<CptAsaProcedure>("code", String.class){

            public Object getColumnValue(CptAsaProcedure cptAsaProcedure, int n) {
                return cptAsaProcedure.getCode();
            }
        });
        selectionPopup.addColumn((ColumnHandler<CptAsaProcedure>)new AbstractColumnHandler<CptAsaProcedure>("BU", Integer.class){

            public Object getColumnValue(CptAsaProcedure cptAsaProcedure, int n) {
                return cptAsaProcedure.getTimesPerformed();
            }
        });
        selectionPopup.addColumn((ColumnHandler<CptAsaProcedure>)new AbstractColumnHandler<CptAsaProcedure>("description", String.class){

            public Object getColumnValue(CptAsaProcedure cptAsaProcedure, int n) {
                return cptAsaProcedure.getDescription();
            }
        });
        selectionPopup.setSelectionListener(new BeanListener<CptAsaProcedure>(){

            public void beanEvent(CptAsaProcedure cptAsaProcedure) {
                ChargeEntryPanel.this._asaProcedureTF.setText(cptAsaProcedure.getCode());
                ChargeEntryPanel.this._selectionPopup.close();
                ChargeEntryPanel.this._selectionPopup = null;
            }
        });
        selectionPopup.getModel().setRows(this._currentProcedure.getAsaProcedureList(this.getDateOfService()));
        selectionPopup.show();
    }

    void showProcedurePopup(final TextFieldWithPopup textFieldWithPopup) {
        if (this._selectionPopup != null) {
            this._selectionPopup.close();
            this._selectionPopup = null;
        }
        SelectionPopup<CptProcedure> selectionPopup = new SelectionPopup<CptProcedure>("Select Procedure", "procedurePopup", CptProcedure.class);
        this._selectionPopup = selectionPopup;
        selectionPopup.addColumn((ColumnHandler<CptProcedure>)new AbstractColumnHandler<CptProcedure>("code", String.class){

            public Object getColumnValue(CptProcedure cptProcedure, int n) {
                return cptProcedure.getCode();
            }
        });
        selectionPopup.addColumn((ColumnHandler<CptProcedure>)new AbstractColumnHandler<CptProcedure>("description", Integer.valueOf(40), String.class){

            public Object getColumnValue(CptProcedure cptProcedure, int n) {
                return cptProcedure.getDescription();
            }
        });
        selectionPopup.addColumn((ColumnHandler<CptProcedure>)new AbstractColumnHandler<CptProcedure>("gender", Integer.valueOf(12), String.class){

            public Object getColumnValue(CptProcedure cptProcedure, int n) {
                return cptProcedure.getGender();
            }
        });
        selectionPopup.addColumn((ColumnHandler<CptProcedure>)new AbstractColumnHandler<CptProcedure>("BU", Integer.class){

            public Object getColumnValue(CptProcedure cptProcedure, int n) {
                return cptProcedure.getTimesPerformed();
            }
        });
        selectionPopup.addColumn((ColumnHandler<CptProcedure>)new AbstractColumnHandler<CptProcedure>("TOS", String.class){

            public Object getColumnValue(CptProcedure cptProcedure, int n) {
                return cptProcedure.getTypeOfService();
            }
        });
        selectionPopup.setSelectionListener(new BeanListener<CptProcedure>(){

            public void beanEvent(CptProcedure cptProcedure) {
                textFieldWithPopup.setText(cptProcedure.getCode());
                ChargeEntryPanel.this._selectionPopup.close();
                ChargeEntryPanel.this._selectionPopup = null;
            }
        });
        selectionPopup.getModel().setRows(this._companyCPTCodes.getProcedures());
        selectionPopup.setSize(new Size(600, 500));
        selectionPopup.show();
    }

    void showModifierPopup(final TextFieldWithPopup textFieldWithPopup) {
        if (this._selectionPopup != null) {
            this._selectionPopup.close();
            this._selectionPopup = null;
        }
        SelectionPopup<CptModifier> selectionPopup = new SelectionPopup<CptModifier>("Select Modifier", "modifierPopup", CptModifier.class);
        this._selectionPopup = selectionPopup;
        selectionPopup.addColumn((ColumnHandler<CptModifier>)new AbstractColumnHandler<CptModifier>("code", String.class){

            public Object getColumnValue(CptModifier cptModifier, int n) {
                return cptModifier.getCode();
            }
        });
        selectionPopup.addColumn((ColumnHandler<CptModifier>)new AbstractColumnHandler<CptModifier>("description", Integer.valueOf(40), String.class){

            public Object getColumnValue(CptModifier cptModifier, int n) {
                return cptModifier.getDescription();
            }
        });
        selectionPopup.setSelectionListener(new BeanListener<CptModifier>(){

            public void beanEvent(CptModifier cptModifier) {
                textFieldWithPopup.setText(cptModifier.getCode());
                if (ChargeEntryPanel.this._selectionPopup != null) {
                    ChargeEntryPanel.this._selectionPopup.close();
                    ChargeEntryPanel.this._selectionPopup = null;
                }
            }
        });
        selectionPopup.getModel().setRows(this._companyCPTCodes.getModifiers());
        selectionPopup.show();
    }

    void showDiagnosisPopup(final TextFieldWithPopup textFieldWithPopup) {
        if (this._selectionPopup != null) {
            this._selectionPopup.close();
            this._selectionPopup = null;
        }
        SelectionPopup<CptDiagnosis> selectionPopup = new SelectionPopup<CptDiagnosis>("Select Diagnosis", "diagnosisPopup", CptDiagnosis.class);
        this._selectionPopup = selectionPopup;
        selectionPopup.addColumn((ColumnHandler<CptDiagnosis>)new AbstractColumnHandler<CptDiagnosis>("code", String.class){

            public Object getColumnValue(CptDiagnosis cptDiagnosis, int n) {
                return cptDiagnosis.getCode();
            }
        });
        selectionPopup.addColumn((ColumnHandler<CptDiagnosis>)new AbstractColumnHandler<CptDiagnosis>("description", Integer.valueOf(40), String.class){

            public Object getColumnValue(CptDiagnosis cptDiagnosis, int n) {
                return cptDiagnosis.getDescription();
            }
        });
        selectionPopup.addColumn((ColumnHandler<CptDiagnosis>)new AbstractColumnHandler<CptDiagnosis>("gender", String.class){

            public Object getColumnValue(CptDiagnosis cptDiagnosis, int n) {
                return cptDiagnosis.getGender();
            }
        });
        selectionPopup.setSelectionListener(new BeanListener<CptDiagnosis>(){

            public void beanEvent(CptDiagnosis cptDiagnosis) {
                textFieldWithPopup.setText(cptDiagnosis.getCode());
                ChargeEntryPanel.this._selectionPopup.close();
                ChargeEntryPanel.this._selectionPopup = null;
            }
        });
        DateOnly dateOnly = new DateOnly(2015, Month.October, 1);
        boolean bl = this.getDateOfService().before(dateOnly);
        List list = ListX.create();
        for (CptDiagnosis cptDiagnosis : this._companyCPTCodes.getDiagnosis()) {
            if (cptDiagnosis.isIcd9() != bl) continue;
            list.add(cptDiagnosis);
        }
        selectionPopup.getModel().setRows(list);
        selectionPopup.show();
    }

    void showConditionCodePopup(TextFieldWithPopup textFieldWithPopup) {
        this.showPairPopup(textFieldWithPopup, "Select Condition Code", "conditionCodePopup", this._scanBatchDTO.conditionCodes);
    }

    void showTransportReasonPopup(TextFieldWithPopup textFieldWithPopup) {
        this.showPairPopup(textFieldWithPopup, "Select Transport Reason", "transportReasonPopup", this._scanBatchDTO.transportReasons);
    }

    void showPairPopup(final TextFieldWithPopup textFieldWithPopup, String string, String string2, List<Pair<String, String>> list) {
        if (this._selectionPopup != null) {
            this._selectionPopup.close();
            this._selectionPopup = null;
        }
        SelectionPopup<Pair<String, String>> selectionPopup = new SelectionPopup<Pair<String, String>>(string, string2, Pair.class);
        this._selectionPopup = selectionPopup;
        selectionPopup.addColumn((ColumnHandler<Pair<String, String>>)new AbstractColumnHandler<Pair<String, String>>("code", String.class){

            public Object getColumnValue(Pair<String, String> pair, int n) {
                return pair.getLeft();
            }
        });
        selectionPopup.addColumn((ColumnHandler<Pair<String, String>>)new AbstractColumnHandler<Pair<String, String>>("description", Integer.valueOf(40), String.class){

            public Object getColumnValue(Pair<String, String> pair, int n) {
                return pair.getRight();
            }
        });
        selectionPopup.setSelectionListener(new BeanListener<Pair<String, String>>(){

            public void beanEvent(Pair<String, String> pair) {
                textFieldWithPopup.setText((String)pair.getLeft());
                ChargeEntryPanel.this._selectionPopup.close();
                ChargeEntryPanel.this._selectionPopup = null;
            }
        });
        selectionPopup.getModel().setRows(list);
        selectionPopup.show();
    }

    public void setChargeEntryPanelListener(Listener listener) {
        this._chargeEntryPanelListener = listener;
    }

    DateOnly getDateOfService() {
        return this._dateOfServiceDC.getValue();
    }

    public void setCurrentProcedure(CptProcedure cptProcedure) {
        this._currentProcedure = cptProcedure;
        if (this._currentProcedure != null) {
            this._procedureTpf = this._currentProcedure.getTimesPerformed();
            this._procedureTpfLabel.setText("" + this._currentProcedure.getTimesPerformed());
            this._procedureTpfLabel.setVisible(true);
            logger.debug((Object)"setting current procedure to {} asa count = {}", (Object)cptProcedure.getCode(), (Object)cptProcedure.getAsaProcedureCount(this.getDateOfService()));
        } else {
            this._procedureTpf = 0;
            this._procedureTpfLabel.setText("X");
            this._procedureTpfLabel.setVisible(false);
            logger.debug((Object)"setting current procedure null");
        }
        if (this._currentProcedure != null && this._currentProcedure.getAsaProcedureCount(this.getDateOfService()) == 1 && ((CptAsaProcedure)this._currentProcedure.getAsaProcedureList(this.getDateOfService()).get(0)).getTimesPerformed() != 0) {
            this._asaProcedureTF.getTextField().setText(((CptAsaProcedure)this._currentProcedure.getAsaProcedureList(this.getDateOfService()).get(0)).getCode());
        } else {
            this._asaProcedureTF.setText("");
        }
    }

    private void applyEnterButton() {
        try {
            this.validateCodingCharge();
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)"Error occurred on update of {}", (Object)this._patientFile, (Object)runtimeException);
            JOptionPane.showMessageDialog((Component)((Object)this), "An unexpected error occurred and this patient file has failed to update.", "Update Error", 0);
        }
        if (this._errorMessagesPanel.getComponentCount() == 0) {
            this._previousCodingCharge = this._codingCharge;
            this._chargeEntryPanelListener.applyCodingCharge(this._codingCharge, this._update);
            String string = this._referralTF.getText();
            this.resetForm();
            this.setCodingCharge(new CodingCharge(true), false);
            this.setPatientFile(this._patientFile);
            this._referralTF.setText(string);
            this._procedureTF.getTextField().requestFocus();
        }
    }

    public static interface Listener {
        public void applyCodingCharge(CodingCharge var1, boolean var2);
    }

    abstract class CodingDocumentListener
    implements DocumentListener {
        CodingDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.processChange(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.processChange(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.processChange(documentEvent);
        }

        abstract void validateIt(String var1);

        void processChange(DocumentEvent documentEvent) {
            try {
                String string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()).toUpperCase();
                logger.debug((Object)"validating code={}", (Object)string);
                this.validateIt(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

