/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.model3.lang.Visitor;
import net.model3.logging.LoggerHelper;
import net.model3.swing.GuiHelper;

public class BusyCursorHelper {
    final Cursor _blankCursor;
    final JLabel _ahsHourglass;
    JRootPane _rootPane;

    public BusyCursorHelper() {
        BufferedImage bufferedImage = new BufferedImage(32, 32, 6);
        this._blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(0, 0), "blank");
        this._ahsHourglass = new JLabel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean contains(int n, int n2) {
                return false;
            }
        };
        this._ahsHourglass.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("ahs-hourglass.gif")));
        this._ahsHourglass.setSize(this._ahsHourglass.getPreferredSize());
        this._ahsHourglass.setVisible(false);
    }

    public void setBusyCursor() {
        LoggerHelper.getLogger().debug((Object)"setBusyCursor()");
        this._ahsHourglass.setVisible(true);
        this.setCursor(this._blankCursor);
    }

    protected void setCursor(final Cursor cursor) {
        if (this._rootPane != null) {
            GuiHelper.visitComponentAndDescendants((Component)this._rootPane.getContentPane(), (Visitor)new Visitor<JComponent>(){

                public void visit(JComponent jComponent) {
                    jComponent.setCursor(cursor);
                }
            });
        }
    }

    public void setDefaultCursor() {
        LoggerHelper.getLogger().debug((Object)"setDefaultCursor()");
        this._ahsHourglass.setVisible(false);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this._rootPane == null) {
            this._rootPane = SwingUtilities.getRootPane(mouseEvent.getComponent());
            this._rootPane.getLayeredPane().add((Component)this._ahsHourglass, JLayeredPane.DRAG_LAYER);
        }
        int n = -2;
        Point point = this._rootPane.getLayeredPane().getLocationOnScreen();
        Point point2 = mouseEvent.getLocationOnScreen();
        this._ahsHourglass.setLocation(point2.x - point.x + n, point2.y - point.y + n);
        this._ahsHourglass.repaint();
    }
}

