/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImageData;
import com.ahsrcm.client.scanning.ImageSource;
import com.ahsrcm.client.scanning.ImageSourceCallback;
import com.ahsrcm.client.scanning.ImportProcessor;
import com.ahsrcm.client.scanning.TiffSplitException;
import com.ahsrcm.core.util.DeployEdgeProperties;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.model3.guice.DependencyInjector;
import net.model3.lang.Executor;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.newfile.Path;

public class TiffImageSource
implements ImageSource {
    Logger logger = LoggerHelper.getLogger();
    @Inject
    DeployEdgeProperties _deployEdgeProperties;
    Path<?> _tiff;
    boolean _duplex;
    ImportProcessor _importProcessor;
    ImageSourceCallback _imageSourceCallback;

    public TiffImageSource(Path<?> path, boolean bl) {
        this._tiff = path;
        this._duplex = bl;
        DependencyInjector.inject((Object)this);
    }

    @Override
    public boolean isDuplex() {
        return this._duplex;
    }

    @Override
    public void startImport(ImageSourceCallback imageSourceCallback) {
        this._imageSourceCallback = imageSourceCallback;
        this._importProcessor.onImageProcessingStarted();
        this.tiffSplit(this._tiff);
    }

    @Override
    public void setImportProcessor(ImportProcessor importProcessor) {
        this._importProcessor = importProcessor;
    }

    public void tiffSplit(Path<?> path) {
        if (path.isDirectory()) {
            this.tiffSplitDir((Directory)path);
        } else {
            this.tiffSplitFile((File)path, false);
        }
    }

    public void tiffSplitDir(Directory directory) {
        this.logger.debug((Object)("Starting split on directory " + directory.getCanonicalPath()));
        for (File file : this.sortFiles(directory.files())) {
            this.tiffSplitFile(file, false);
        }
    }

    private List<File> sortFiles(List<File> list) {
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return file.getName().compareTo(file2.getName());
            }
        });
        return list;
    }

    void tiffSplitFile(File file, boolean bl) {
        this.logger.debug((Object)("PDF_DEBUG: Starting split on " + file.getCanonicalPath()));
        this.logger.debug((Object)("PDF_DEBUG: wasOriginallyPdf = " + bl));
        Executor executor = new Executor();
        boolean bl2 = this._deployEdgeProperties.getIsLocalTest();
        Directory directory = this._importProcessor.getWorkDirectory().subDirectory(file.getBaseFilename() + "-dir");
        directory.makeDirectories();
        this.logger.debug((Object)("Splitting to " + directory));
        executor.setCurrentDirectory(directory);
        String string = this._deployEdgeProperties.getTiffSplit();
        File file2 = new File(string);
        if (!file2.exists()) {
            throw new TiffSplitException("tiffSplitFile -- tiffSplit process not found. tiffSplit=" + string);
        }
        string = file2.getCanonicalPath();
        String string2 = bl2 ? "\"" + string + "\" \"" + file.getCanonicalPath() + "\" " + file.getBaseFilename() + "_%d." + file.getExtension() : "\"" + string + "\" \"" + file.getCanonicalPath() + "\" ts";
        this.logger.debug((Object)("tiffSplitFile -- cmdStr=" + string2));
        executor.setCommandLine(string2);
        executor.execute();
        String string3 = executor.getLastError();
        if (StringX.isNotBlank((String)string3)) {
            this.logger.debug((Object)("Std Err -> " + string3));
        }
        this.logger.debug((Object)("Std Out -> " + executor.getLastOutput()));
        this.logger.debug((Object)("Exit Code -> " + executor.getLastResult()));
        if (executor.getLastResult() != 0) {
            throw new TiffSplitException("Error splitting tif file.  failed to execute -- " + executor.getCommandLine());
        }
        this.logger.debug((Object)("PDF_DEBUG: Number of files after split: " + directory.files().size()));
        this.logger.debug((Object)("PDF_DEBUG: doBlankImageCheck for original doc: " + !bl));
        this._imageSourceCallback.newOriginalDocument(new ImageData.OriginalDocumentData(file, directory.files().size()), !bl);
        int n = 0;
        for (File file3 : this.sortFiles(directory.files())) {
            this.logger.debug((Object)("PDF_DEBUG: Processing page " + ++n + ": " + file3.getName() + ", doBlankImageCheck=" + !bl));
            ImageData.TiffFileImageData tiffFileImageData = new ImageData.TiffFileImageData(file3);
            this._imageSourceCallback.newImage(tiffFileImageData, !bl);
        }
        this.logger.debug((Object)"PDF_DEBUG: Finished processing all pages");
        this._imageSourceCallback.resetOriginalDocument();
    }
}

