/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImportStep;
import com.ahsrcm.client.scanning.ImportedImage;
import com.ahsrcm.core.crypto.CryptoEngine;
import com.ahsrcm.core.crypto.DecryptedData;
import com.ahsrcm.core.crypto.EncryptedData;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.scanning.app.client.ImageUploadService;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.ahsrcm.util.Md5Helper;
import com.google.inject.Inject;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.File;

public class SaveImageStep
extends ImportStep {
    private static final Logger logger = LoggerHelper.getLogger();
    @Inject
    ImageUploadService _imageUploadService;
    @Inject
    CryptoEngine _cryptoEngine;
    @Inject
    ScanningDao _scanningDao;

    @Inject
    private SaveImageStep() {
    }

    @Override
    public void processImage(ImportedImage importedImage) {
        ScannedImage scannedImage = importedImage.getScannedImage();
        if (importedImage.isValidImage() && scannedImage != null) {
            File file = scannedImage.getImageFile();
            byte[] byArray = importedImage.getImageData().getBytes();
            logger.debug((Object)("SaveImageStep -- useEncryption=" + this._scanningDao.useImageEncryption()));
            if (this._scanningDao.useImageEncryption().booleanValue()) {
                EncryptedData encryptedData = this._cryptoEngine.encrypt(new DecryptedData(byArray));
                file.write(encryptedData.getBytes());
            }
            scannedImage.setFileExtension(importedImage.getImageData().getFileExtension());
            scannedImage.setSize(Long.valueOf(byArray.length));
            scannedImage.setMd5(Md5Helper.getMd5((byte[])byArray));
            scannedImage.update();
            this._imageUploadService.queue(scannedImage.getBatch().getId().longValue(), scannedImage.getId().longValue(), scannedImage.getVersion().intValue(), byArray);
        }
        this.send(importedImage);
    }
}

