/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImportStep;
import com.ahsrcm.client.scanning.ImportedImage;
import com.ahsrcm.client.scanning.RescanImportProcessor;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.corp.orm.Status;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.dao.ScanningDao;
import com.google.inject.Inject;

public class RescanDatabaseStep
extends ImportStep {
    @Inject
    ClientScanningDao _dao;

    @Inject
    private RescanDatabaseStep() {
    }

    @Override
    public void processImage(ImportedImage importedImage) {
        if (importedImage.isOriginalDocument()) {
            this.logger.debug((Object)"importedImage.import source image");
            ScannedImage scannedImage = new ScannedImage();
            scannedImage.setBatch(this._importProcessor.getScanBatch());
            scannedImage.setId(Long.valueOf(((ScanningDao)ScanningDao.Impl.get()).nextControlNumber(ScannedImage.class)));
            scannedImage.setFileName(importedImage.getImageData().getFileName());
            importedImage.setScannedImage(scannedImage);
        } else {
            ScannedImage scannedImage = ((RescanImportProcessor)this.getImportProcessor()).imageBeingRescanned;
            scannedImage.setStatus(Status.Superceded);
            scannedImage.update();
            ScannedImage scannedImage2 = scannedImage.getPatientFile().newScannedImage(false);
            scannedImage2.setPreviousVersion(scannedImage.getId());
            scannedImage2.setPageNumber(scannedImage.getPageNumber());
            scannedImage2.setDocumentType(scannedImage.getDocumentType());
            importedImage.setScannedImage(scannedImage2);
            scannedImage2.insert();
            this.send(importedImage);
        }
    }
}

