/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImageSourceCallback;
import com.ahsrcm.client.scanning.TiffImageSource;
import com.ahsrcm.client.tools.ServerUrlProvider;
import com.ahsrcm.client.tools.SessionIdProvider;
import com.ahsrcm.core.util.DeployEdgeProperties;
import com.ahsrcm.util.PdfFileFilter;
import com.ahsrcm.util.guice.Directories;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.model3.collections.ListX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.net.UrlX;
import net.model3.newfile.Directory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class PdfChooserImageSource
extends TiffImageSource {
    private static final Log logger = LogHelper.getLog(PdfChooserImageSource.class);
    @Inject
    Directories _clientDirectories;
    @Inject
    ServerUrlProvider _serverUrlProvider;
    @Inject
    SessionIdProvider _sessionIdProvider;
    @Inject
    DeployEdgeProperties _deployEdgeProperties;
    SimpleDateFormat _simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");

    public PdfChooserImageSource() {
        super(null, false);
    }

    @Override
    public void startImport(ImageSourceCallback imageSourceCallback) {
        this._imageSourceCallback = imageSourceCallback;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter((FileFilter)new PdfFileFilter());
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog(null);
        if (0 == n) {
            this._importProcessor.onImageProcessingStarted();
            File[] fileArray = jFileChooser.getSelectedFiles();
            List<net.model3.newfile.File> list = this.convertPdfsToTifs(fileArray);
            for (net.model3.newfile.File file : list) {
                this.tiffSplitFile(file, false);
            }
        }
    }

    public List<net.model3.newfile.File> convertPdfsToTifs(File[] fileArray) {
        List list = ListX.create();
        try {
            String string = this._simpleDateFormat.format(new Date());
            Directory directory = this._clientDirectories.conversionTemp().subdir(string);
            directory.makeDirectories();
            for (File file : fileArray) {
                net.model3.newfile.File file2 = this.convertPdfToTif(file, directory);
                if (file2 == null) continue;
                list.add(file2);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"unable to convert pdf files to a tifs");
        }
        return list;
    }

    public net.model3.newfile.File convertPdfToTif(File file, Directory directory) throws IOException {
        net.model3.newfile.File file2 = null;
        logger.debug((Object)("convertPdfToTif -- tempDir=" + directory.getCanonicalPath()));
        try {
            net.model3.newfile.File file3 = new net.model3.newfile.File(file.getCanonicalPath());
            logger.debug((Object)("convertPdfToTif -- pdfFile=" + file3.getCanonicalPath()));
            String string = file3.getBaseFilename().replaceAll(" ", "");
            file2 = directory.file(string + ".tif");
            logger.debug((Object)("convertPdfToTif -- tifFile=" + file2.getCanonicalPath()));
            file2.write(this.sendFileForConversion(file3));
        }
        catch (Exception exception) {
            logger.error((Object)"unable to convert to file {} to a tif", (Object)file.getCanonicalPath());
        }
        return file2;
    }

    public InputStream sendFileForConversion(net.model3.newfile.File file) {
        try {
            HttpClient httpClient = new HttpClient();
            UrlX urlX = this.getConversionServerUrl(httpClient);
            String string = file.getName().replaceAll(" ", "");
            if (urlX != null) {
                UrlX urlX2 = urlX.subPath("/api/image/convert");
                PutMethod putMethod = new PutMethod(urlX2 + "?pdfFileName=" + string + "&profileName=" + this._deployEdgeProperties.getTiffConversionProfileName());
                return this.executeConvertRequest(httpClient, putMethod, file);
            }
            UrlX urlX3 = ((UrlX)this._serverUrlProvider.get()).subPath("/api/image/convert");
            PutMethod putMethod = new PutMethod(urlX3 + "?sess=" + (String)this._sessionIdProvider.get() + "&pdfFileName=" + string);
            return this.executeConvertRequest(httpClient, putMethod, file);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private UrlX getConversionServerUrl(HttpClient httpClient) {
        try {
            UrlX urlX = ((UrlX)this._serverUrlProvider.get()).subPath("/api/image/conversionserverurl");
            GetMethod getMethod = new GetMethod(urlX.toString());
            logger.debug((Object)"calling {}", (Object)getMethod.getURI());
            httpClient.executeMethod((HttpMethod)getMethod);
            if (getMethod.getStatusCode() == 200) {
                String string = getMethod.getResponseBodyAsString();
                return new UrlX(string);
            }
            return null;
        }
        catch (IOException iOException) {
            logger.error((Object)"unable to get conversion server url", (Object)iOException);
            return null;
        }
    }

    private InputStream executeConvertRequest(HttpClient httpClient, PutMethod putMethod, net.model3.newfile.File file) throws IOException {
        putMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)file.createInputStream()));
        logger.debug((Object)"sending {} to {}", (Object)file, (Object)putMethod.getURI());
        httpClient.executeMethod((HttpMethod)putMethod);
        if (putMethod.getStatusCode() != 200) {
            logger.error((Object)"unable to send pdf files for conversion\n{} - {}", (Object)putMethod.getStatusCode(), (Object)putMethod.getStatusText());
        }
        return putMethod.getResponseBodyAsStream();
    }
}

