/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.JTwainImageSource;
import com.ahsrcm.core.util.DeployEdgeProperties;
import com.ahsrcm.util.guice.Directories;
import com.asprise.util.jtwain.Source;
import com.asprise.util.jtwain.SourceManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.model3.lang.SystemX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.File;

@Singleton
public class JTwainManager {
    final Logger logger = LoggerHelper.getLogger();
    private ExecutorService _scanningExecutor;
    final DeployEdgeProperties _deployEdgeProperties;

    @Inject
    private JTwainManager(final Directories directories, DeployEdgeProperties deployEdgeProperties) {
        this._deployEdgeProperties = deployEdgeProperties;
        try {
            if (this._scanningExecutor != null) {
                return;
            }
            if (!this.isJTwainEnabled()) {
                return;
            }
            this._scanningExecutor = Executors.newSingleThreadExecutor();
            this.invokeOnScanningThreadAndWait(new Runnable(){

                @Override
                public void run() {
                    String string = JTwainImageSource.class.getName() + "-init";
                    if (System.getProperty(string) == null) {
                        System.setProperty(string, "done");
                        Thread thread = Thread.currentThread();
                        thread.setName("JTwain-" + thread.getId());
                        try {
                            SourceManager.instance().getAllSources();
                        }
                        catch (Exception exception) {
                            JTwainManager.this.logger.info((Object)exception);
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            JTwainManager.this.logger.info((Object)"Unsatisfied link error | {}", (Object)unsatisfiedLinkError.getMessage());
                        }
                        String string2 = "AspriseJTwain.dll";
                        File file = directories.appHome().file(string2);
                        SourceManager.setLibraryPath((String)file.getCanonicalPath());
                    }
                }
            });
        }
        catch (Exception exception) {
            this.logger.error((Object)"error starting up jtwain scanner", (Object)exception);
        }
    }

    protected void invokeOnScanningThreadAndWait(final Runnable runnable) {
        Future<Object> future = this._scanningExecutor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                runnable.run();
                return null;
            }
        });
        try {
            future.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected <T> T invokeOnScanningThreadAndWait(Callable<T> callable) {
        Future<T> future = this._scanningExecutor.submit(callable);
        try {
            return future.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public List<JTwainImageSource> getAllScanners() {
        if (!this.isJTwainEnabled()) {
            this.logger.debug((Object)"jtwain scanners are disabled");
            return Collections.emptyList();
        }
        return this.invokeOnScanningThreadAndWait(new Callable<List<JTwainImageSource>>(){

            @Override
            public List<JTwainImageSource> call() throws Exception {
                ArrayList<JTwainImageSource> arrayList = new ArrayList<JTwainImageSource>();
                try {
                    for (Source source : SourceManager.instance().getAllSources()) {
                        arrayList.add(new JTwainImageSource(JTwainManager.this, source, source.getSourceName()));
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    JTwainManager.this.logger.error((Object)"unable to load jtwain dll will continue without it no scanning devices will be supported", (Object)unsatisfiedLinkError);
                }
                catch (Exception exception) {
                    JTwainManager.this.logger.error((Object)"unable to load jtwain", (Object)exception);
                }
                return arrayList;
            }
        });
    }

    public boolean isJTwainEnabled() {
        return SystemX.isWindows() && this._deployEdgeProperties.getUseJtwain() != false;
    }

    public void shutdown() {
        this.invokeOnScanningThreadAndWait(new Runnable(){

            @Override
            public void run() {
                SourceManager.closeSourceManager();
                SourceManager.unloadSourceManager();
            }
        });
        this._scanningExecutor.shutdown();
        this._scanningExecutor = null;
    }
}

