/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImageData;
import com.ahsrcm.client.scanning.ImageSourceCallback;
import com.ahsrcm.client.scanning.JTwainManager;
import com.ahsrcm.client.scanning.ScannedImageSource;
import com.ahsrcm.scanning.device.Feeder;
import com.asprise.util.jtwain.Source;
import com.asprise.util.jtwain.SourceManager;
import java.awt.image.BufferedImage;
import java.util.concurrent.Callable;
import net.model3.collections.Queue;
import net.model3.lang.ExceptionPropagator;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.log4j.ThreadLocalAppender;

public class JTwainImageSource
extends ScannedImageSource {
    Logger logger = LoggerHelper.getLogger();
    final JTwainManager _manager;
    Source _source;
    String _name;

    JTwainImageSource(JTwainManager jTwainManager) {
        this._manager = jTwainManager;
        this._manager.invokeOnScanningThreadAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    JTwainImageSource.this._source = SourceManager.instance().getDefaultSource();
                    JTwainImageSource.this._name = JTwainImageSource.this._source.getSourceName();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    JTwainImageSource(JTwainManager jTwainManager, Source source, String string) {
        this._manager = jTwainManager;
        this._source = source;
        this._name = string;
    }

    @Override
    public boolean isDuplex() {
        return this.getFeeder() == Feeder.Duplex;
    }

    @Override
    public void startImport(final ImageSourceCallback imageSourceCallback) {
        this._importProcessor.onImageProcessingStarted();
        final Queue queue = new Queue();
        this._manager.invokeOnScanningThreadAndWait(new Runnable(){

            @Override
            public void run() {
                ThreadLocalAppender.get().withAppender(JTwainImageSource.this._importProcessor.getAppender(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            JTwainImageSource.this.logger.debug((Object)"openning jtwain source");
                            JTwainImageSource.this._source.open();
                            JTwainImageSource.this._source.setIndicators(true);
                            JTwainImageSource.this._source.setUIEnabled(JTwainImageSource.this._showOptionsDialog);
                            if (JTwainImageSource.this.getFeeder() == Feeder.Duplex || JTwainImageSource.this.getFeeder() == Feeder.Simplex) {
                                JTwainImageSource.this._source.setFeederEnabled(true);
                                JTwainImageSource.this._source.setAutoFeed(true);
                                JTwainImageSource.this._source.setTransferCount(-1);
                            } else {
                                JTwainImageSource.this._source.setTransferCount(1);
                                JTwainImageSource.this._source.setFeederEnabled(false);
                                JTwainImageSource.this._source.setAutoFeed(false);
                            }
                            JTwainImageSource.this._source.setDuplexEnabled(JTwainImageSource.this.getFeeder() == Feeder.Duplex);
                            do {
                                JTwainImageSource.this.logger.debug((Object)"acquiring image from jtwain scanner");
                                BufferedImage bufferedImage = JTwainImageSource.this._source.acquireImageAsBufferedImage();
                                JTwainImageSource.this.logger.debug((Object)"acquired image from jtwain scanner");
                                imageSourceCallback.newImage(new ImageData.BufferedImageData(bufferedImage, null), true);
                            } while (JTwainImageSource.this._source.hasMoreImages());
                            queue.put((Object)Boolean.TRUE);
                        }
                        catch (Throwable throwable) {
                            queue.put((Object)throwable);
                            JTwainImageSource.this._importProcessor.logFatalError("Scanning Error", "error in jtwain scanning thread", throwable);
                            throw ExceptionPropagator.throwUnchecked((Throwable)throwable);
                        }
                        finally {
                            try {
                                JTwainImageSource.this._source.close();
                            }
                            catch (Exception exception) {}
                        }
                        return null;
                    }
                });
            }
        });
        Object object = queue.take();
        if (object instanceof Throwable) {
            throw ExceptionPropagator.throwUnchecked((Throwable)((Throwable)object));
        }
        if (!(object instanceof Boolean) || !((Boolean)object).booleanValue()) {
            throw new RuntimeException("unexpected response " + object);
        }
    }

    @Override
    public String getName() {
        return this._name + " (jtwain)";
    }
}

