/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImportProcessor;
import com.ahsrcm.client.scanning.ImportedImage;
import com.ahsrcm.client.scanning.QueueMessage;
import com.ahsrcm.client.scanning.TerminateProcessingMessage;
import com.ahsrcm.corp.orm.ClientSideSessionContext;
import java.util.concurrent.Callable;
import net.java.dev.properties.jdbc.Session;
import net.model3.collections.Queue;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ClassX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.log4j.ThreadLocalAppender;

public abstract class ImportStep
implements Runnable {
    final Logger logger = LoggerHelper.getLogger();
    ImportProcessor _importProcessor;
    Queue<QueueMessage> _incomingQueue;
    Queue<QueueMessage> _outgoingQueue;
    Throwable _error;
    Session _session;
    Thread _thread;

    public void start(ImportProcessor importProcessor, Queue<QueueMessage> queue, Queue<QueueMessage> queue2, Session session) {
        this._importProcessor = importProcessor;
        this._incomingQueue = queue;
        this._outgoingQueue = queue2;
        this._session = session;
        this._thread = new Thread(this);
        this._thread.setName(this.getName() + "-" + this._thread.getId());
        this._thread.start();
    }

    public String getName() {
        return ClassX.getShortName(this.getClass());
    }

    public ImportProcessor getImportProcessor() {
        return this._importProcessor;
    }

    @Override
    public final void run() {
        ThreadLocalAppender.get().withAppender(this._importProcessor.getAppender(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ImportStep.this.runImpl();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runImpl() {
        ClientSideSessionContext clientSideSessionContext = (ClientSideSessionContext)DependencyInjector.getInstance(ClientSideSessionContext.class);
        try {
            clientSideSessionContext.setSessionForThread(this._session);
            this.logger.debug((Object)"starting");
            boolean bl = true;
            while (bl) {
                QueueMessage queueMessage = this.receive();
                if (queueMessage instanceof TerminateProcessingMessage) {
                    this.processTermination((TerminateProcessingMessage)queueMessage);
                    bl = false;
                    continue;
                }
                if (queueMessage instanceof ImportedImage) {
                    this.processImage((ImportedImage)queueMessage);
                    continue;
                }
                this.logger.debug((Object)("don't know how to handle " + queueMessage.getClass() + " - " + queueMessage));
            }
            this.logger.debug((Object)("terminating naturally running = " + bl));
        }
        catch (Throwable throwable) {
            this.processFatalError(throwable);
        }
        finally {
            clientSideSessionContext.setSessionForThread(null);
        }
    }

    protected void processFatalError(Throwable throwable) {
        this.processFatalError(null, throwable);
    }

    protected void processFatalError(String string, Throwable throwable) {
        this._error = throwable;
        this._importProcessor.logFatalError(string, "fatal error in import step " + this, throwable);
        this.send(new TerminateProcessingMessage(throwable));
    }

    public Throwable getError() {
        return this._error;
    }

    protected void processTermination(TerminateProcessingMessage terminateProcessingMessage) {
        this.send(terminateProcessingMessage);
    }

    protected void processImage(ImportedImage importedImage) {
        this.send(importedImage);
    }

    protected void send(QueueMessage queueMessage) {
        this.logger.debug((Object)("sending " + queueMessage));
        this._outgoingQueue.put((Object)queueMessage);
    }

    private QueueMessage receive() {
        QueueMessage queueMessage = (QueueMessage)this._incomingQueue.take();
        this.logger.debug((Object)("received " + queueMessage));
        return queueMessage;
    }

    public boolean isRunning() {
        return this._thread.isAlive();
    }
}

