/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.BlankPageIndexer;
import com.ahsrcm.client.scanning.ImageIndexer;
import com.ahsrcm.client.scanning.ImportProcessor;
import com.ahsrcm.client.scanning.ImportProcessorImpl;
import com.ahsrcm.client.scanning.TiffImageSource;
import com.ahsrcm.client.tools.ServerUrlProvider;
import com.ahsrcm.client.tools.SessionIdProvider;
import com.ahsrcm.client.tools.login.LoginTool;
import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.BatchType;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.rpc.UpStreamServerUrlProvider;
import com.ahsrcm.util.UserContext;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.sql.Date;
import java.util.Map;
import java.util.Properties;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.net.UrlX;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.newfile.Path;

public class ImportProcessorDemo {
    private static final Logger logger = LoggerHelper.getLogger();
    String _serverUrl = "https://deployedge.ahsrcm.com/rpc";
    String _cacheServerUrl = "https://scan.ahsrcm.com/";
    Properties _buildProperties;
    @Inject
    SessionIdProvider _sessionIdProvider;
    @Inject
    ServerUrlProvider _serverUrlProvider;
    @Inject
    UpStreamServerUrlProvider _upStreamServerUrlProvider;
    @Inject
    LoginTool _loginTool;
    @Inject
    Injector _injector;
    @Inject
    ClientScanningDao _dao;
    @Inject
    UserContext _userContext;

    public static void main(String[] stringArray) throws Exception {
        new SimpleLoggingConfigurator().addEclipseConsoleAppender();
        ((ImportProcessorDemo)DependencyInjector.getInstance(ImportProcessorDemo.class)).run();
    }

    String login() {
        String string = this.getProperty("eaxUser");
        String string2 = this.getProperty("eaxPassword");
        return this._loginTool.login(string, string2);
    }

    void loadProperties(Directory directory) {
        File file;
        Directory directory2 = directory.getParent();
        if (directory2 != null) {
            this.loadProperties(directory2);
        }
        if ((file = new File(directory, "build.properties")).exists()) {
            try {
                logger.debug((Object)"loading properties {}", (Object)file.getCanonicalPath());
                this._buildProperties.load(file.createInputStream());
            }
            catch (Exception exception) {
                LoggerHelper.getLogger().warn((Object)exception);
            }
        }
    }

    String getProperty(String string) {
        if (this._buildProperties == null) {
            this._buildProperties = new Properties();
            this._buildProperties.putAll((Map<?, ?>)System.getProperties());
            this.loadProperties(new Directory("."));
        }
        return this._buildProperties.getProperty(string);
    }

    void run() throws Exception {
        this.init();
        TiffImageSource tiffImageSource = new TiffImageSource((Path<?>)new File("/Users/glen/code/ahs/core/core/images/test.tiff"), false);
        Date date = new Date(System.currentTimeMillis());
        Location location = Location.fetchByPk((String)"CHAM", (String)"AAL", (String)"HAIP");
        BatchType batchType = BatchType.fetchByPk((String)"1");
        String string = "";
        int n = 1;
        int n2 = 1;
        ScanBatch scanBatch = this.createScanBatch(date, location, batchType, string, n, n2);
        ImageIndexer imageIndexer = (ImageIndexer)this._injector.getInstance(BlankPageIndexer.class);
        ImportProcessorImpl importProcessorImpl = new ImportProcessorImpl(this._injector, scanBatch, tiffImageSource, imageIndexer, null, true, new ImportProcessor.ListenerAdapter(){

            @Override
            public void complete(boolean bl) {
                logger.debug((Object)("we are done booyaka -- success = " + bl));
                System.exit(1);
            }
        });
        importProcessorImpl.process();
    }

    private void init() throws Exception {
        this._sessionIdProvider.set((Object)this.login());
        if (this._cacheServerUrl != null) {
            this._upStreamServerUrlProvider.set((Object)new UrlX(this._cacheServerUrl));
        }
        this._serverUrlProvider.set((Object)new UrlX(this._serverUrl).getRootUrl());
    }

    private ScanBatch createScanBatch(Date date, Location location, BatchType batchType, String string, int n, int n2) {
        ScanBatch scanBatch = new ScanBatch();
        scanBatch.setLocation(location);
        scanBatch.setBatchType(batchType);
        scanBatch.setCoder(this._userContext.getUser());
        scanBatch.setCodingRequired(Boolean.valueOf(true));
        scanBatch.setComment(string);
        scanBatch.setDateOfService(date);
        scanBatch.setExpectedImageCount(Integer.valueOf(n));
        scanBatch.setExpectedVisitCount(Integer.valueOf(n2));
        scanBatch.setId(Long.valueOf(this._dao.nextControlNumber(ScanBatch.class)));
        scanBatch.setStage((Stage)Stage.ScanningInProgress.get());
        this._dao.insert((BaseBusinessBean)scanBatch);
        return scanBatch;
    }
}

