/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImageSource;
import com.ahsrcm.client.scanning.ImportedImage;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.ScannedImage;
import net.model3.chrono.DateTime;
import net.model3.lang.ThrowableX;
import net.model3.newfile.Directory;
import net.model3.swing.EventManager;
import org.apache.log4j.Appender;

public interface ImportProcessor {
    public ImportedImage newImportedImage();

    public void process();

    public ScanBatch getScanBatch();

    public EventManager<Listener> getListeners();

    public Appender getAppender();

    public ImageSource getImageSource();

    public void logFatalError(String var1, String var2, Throwable var3);

    public boolean hasErrors();

    public boolean complete();

    public Status getStatus();

    public Directory getWorkDirectory();

    public Directory getCompletionDirectory();

    public void onImageProcessingStarted();

    public static enum Status {
        NotStarted,
        Processing,
        Success,
        Failure;

    }

    public static class LogMessage {
        public final String threadName = Thread.currentThread().getName();
        public final DateTime created = new DateTime();
        public final String message;
        public final Throwable throwable;

        public LogMessage(String string) {
            this.message = string;
            this.throwable = null;
        }

        public LogMessage(Throwable throwable) {
            this.throwable = throwable;
            this.message = null;
        }

        public LogMessage(String string, Throwable throwable) {
            this.message = string;
            this.throwable = throwable;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.created);
            stringBuilder.append(" - ");
            stringBuilder.append(this.threadName);
            if (this.message != null) {
                stringBuilder.append(" - ");
                stringBuilder.append(this.message);
            }
            if (this.throwable != null) {
                stringBuilder.append("\n");
                stringBuilder.append(ThrowableX.getStackTrace((Throwable)this.throwable));
            }
            return stringBuilder.toString();
        }
    }

    public static class ListenerAdapter
    implements Listener {
        @Override
        public void start() {
        }

        @Override
        public void newScannedImage(ScannedImage scannedImage) {
        }

        @Override
        public void success() {
        }

        @Override
        public void error() {
        }

        @Override
        public void complete(boolean bl) {
        }

        @Override
        public void logFatalError(String string, String string2, Throwable throwable) {
        }
    }

    public static interface Listener {
        public void start();

        public void newScannedImage(ScannedImage var1);

        public void success();

        public void error();

        public void complete(boolean var1);

        public void logFatalError(String var1, String var2, Throwable var3);
    }
}

