/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImageData;
import com.ahsrcm.client.scanning.ImageSource;
import com.ahsrcm.client.scanning.ImageSourceCallback;
import com.ahsrcm.client.scanning.ImportProcessor;
import com.ahsrcm.client.scanning.ImportStep;
import com.ahsrcm.client.scanning.ImportedImage;
import com.ahsrcm.client.scanning.TerminateProcessingMessage;
import com.ahsrcm.client.scanning.TiffSplitException;
import javax.swing.JOptionPane;

public class ImageSourceStep
extends ImportStep {
    final ImageSource _imageSource;
    final boolean _acceptSingleImageOnly;
    boolean alreadyProcessedAnImage = false;
    ImportedImage _originalDocument;
    int _pageNumberInOriginal;
    ImageSourceCallback _imageSourceCallback = new ImageSourceCallback(){

        @Override
        public void newImage(ImageData imageData, boolean bl) {
            ImageSourceStep.this.newImage(imageData, bl);
        }

        @Override
        public void newOriginalDocument(ImageData.OriginalDocumentData originalDocumentData, boolean bl) {
            ImageSourceStep.this.newOriginalDocument(originalDocumentData, bl);
        }

        @Override
        public void resetOriginalDocument() {
            ImageSourceStep.this.resetOriginalDocument();
        }
    };

    public ImageSourceStep(ImageSource imageSource) {
        this(imageSource, false);
    }

    public ImageSourceStep(ImageSource imageSource, boolean bl) {
        this._imageSource = imageSource;
        this._acceptSingleImageOnly = bl;
    }

    @Override
    public void processImage(ImportedImage importedImage) {
    }

    @Override
    void runImpl() {
        try {
            this.logger.debug((Object)"starting");
            this._imageSource.startImport(this._imageSourceCallback);
            this.logger.debug((Object)"terminating naturally running = true");
            this.send(new TerminateProcessingMessage(ImportProcessor.Status.Success));
        }
        catch (TiffSplitException tiffSplitException) {
            JOptionPane.showMessageDialog(null, tiffSplitException.getMessage(), "Tiff Error", 0);
            this.processFatalError(tiffSplitException);
        }
        catch (Throwable throwable) {
            this.processFatalError(null, throwable);
        }
    }

    protected void newOriginalDocument(ImageData imageData, boolean bl) {
        if (this.alreadyProcessedAnImage && this._acceptSingleImageOnly) {
            this.logger.debug((Object)"error - newSourceImage() received another image but this should only accept a single image, ignoring remaining images");
            return;
        }
        this._originalDocument = this._importProcessor.newImportedImage();
        this._originalDocument.setDoBlankImageCheck(bl);
        this._originalDocument.setImageData(imageData);
        this.send(this._originalDocument);
    }

    void resetOriginalDocument() {
        this._originalDocument = null;
        this._pageNumberInOriginal = 0;
    }

    void newImage(ImageData imageData, boolean bl) {
        this.logger.debug((Object)("PDF_DEBUG: ImageSourceStep.newImage() called, doBlankImageCheck=" + bl + ", filename=" + imageData.getFileName()));
        this.logger.debug((Object)("PDF_DEBUG: alreadyProcessedAnImage=" + this.alreadyProcessedAnImage + ", _acceptSingleImageOnly=" + this._acceptSingleImageOnly));
        if (this.alreadyProcessedAnImage && this._acceptSingleImageOnly) {
            this.logger.debug((Object)"error - newImage() received another image but this should only accept a single image, ignoring remaining images");
            return;
        }
        if (this._acceptSingleImageOnly) {
            this.alreadyProcessedAnImage = true;
        }
        ImportedImage importedImage = this._importProcessor.newImportedImage();
        importedImage.setDoBlankImageCheck(bl);
        importedImage.setImageData(imageData);
        if (this._originalDocument != null) {
            ++this._pageNumberInOriginal;
            importedImage.setPageNumberInOriginal(this._pageNumberInOriginal);
            importedImage.setOriginalDocument(this._originalDocument);
            this.logger.debug((Object)("PDF_DEBUG: Set page " + this._pageNumberInOriginal + " with original document"));
        }
        this.logger.debug((Object)"PDF_DEBUG: Sending image to next step");
        this.send(importedImage);
    }
}

