/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.scanning.device.ImageReaderWriter;
import java.awt.image.BufferedImage;
import net.model3.newfile.File;

public interface ImageData {
    public boolean providesBufferedImage();

    public void save(File var1);

    public byte[] getBytes();

    public BufferedImage asBufferedImage();

    public String getFileExtension();

    public int getNumberOfPages();

    public String getFileName();

    public static class TiffFileImageData
    extends AbstractImageData {
        File _tiffFile;

        public TiffFileImageData(File file) {
            this._tiffFile = file;
            this.setFileExtension("tiff");
        }

        @Override
        public boolean providesBufferedImage() {
            return true;
        }

        @Override
        public void save(File file) {
            this._tiffFile.copyFileTo(file);
        }

        @Override
        public byte[] getBytes() {
            return this._tiffFile.readBytes();
        }

        @Override
        public BufferedImage asBufferedImage() {
            return ((ImageReaderWriter)ImageReaderWriter.instance.get()).loadImage(this._tiffFile);
        }

        public String toString() {
            return "TiffFileImageData[" + this._tiffFile.getCanonicalPath() + "]";
        }

        @Override
        public String getFileName() {
            return this._tiffFile.getBaseFilename();
        }
    }

    public static class BufferedImageData
    extends AbstractImageData {
        BufferedImage _bufferedImage;

        public BufferedImageData(BufferedImage bufferedImage, String string) {
            this._bufferedImage = bufferedImage;
            this.setFileExtension(string);
        }

        @Override
        public int getNumberOfPages() {
            return 1;
        }

        @Override
        public boolean providesBufferedImage() {
            return true;
        }

        @Override
        public void save(File file) {
            ((ImageReaderWriter)ImageReaderWriter.instance.get()).saveImage(this._bufferedImage, file);
        }

        @Override
        public byte[] getBytes() {
            return ((ImageReaderWriter)ImageReaderWriter.instance.get()).getImageBytes(this._bufferedImage);
        }

        @Override
        public BufferedImage asBufferedImage() {
            return this._bufferedImage;
        }

        public String fileExtension() {
            return this._fileExtension;
        }

        public String toString() {
            return "BufferedImageData[]";
        }

        @Override
        public String getFileName() {
            return null;
        }
    }

    public static class OriginalDocumentData
    extends AbstractImageData {
        File _file;

        public OriginalDocumentData(File file, int n) {
            this._file = file;
            this.setFileExtension(this._file.getExtension());
            this.setNumberOfPages(n);
        }

        @Override
        public int getNumberOfPages() {
            return this._numberOfPages;
        }

        @Override
        public boolean providesBufferedImage() {
            return false;
        }

        @Override
        public void save(File file) {
            this._file.copyFileTo(file);
        }

        @Override
        public byte[] getBytes() {
            return this._file.readBytes();
        }

        @Override
        public BufferedImage asBufferedImage() {
            return null;
        }

        public String toString() {
            return "OriginalDocumentData[" + this._file.getCanonicalPath() + "]";
        }

        @Override
        public String getFileName() {
            return this._file.getBaseFilename();
        }
    }

    public static abstract class AbstractImageData
    implements ImageData {
        int _numberOfPages;
        String _fileExtension;

        @Override
        public int getNumberOfPages() {
            return this._numberOfPages;
        }

        @Override
        public String getFileExtension() {
            return this._fileExtension;
        }

        public void setFileExtension(String string) {
            this._fileExtension = string;
        }

        public void setNumberOfPages(int n) {
            this._numberOfPages = n;
        }
    }
}

