/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.BlankPageIndexer;
import com.ahsrcm.client.scanning.FixedPageCountIndexer;
import com.ahsrcm.client.scanning.ImageIndexer;
import com.ahsrcm.client.scanning.ImageSource;
import com.ahsrcm.client.scanning.ImportProcessor;
import com.ahsrcm.client.scanning.ImportProcessorImpl;
import com.ahsrcm.client.scanning.ImporterDirectories;
import com.ahsrcm.client.scanning.NoIndexingImageIndexer;
import com.ahsrcm.client.scanning.PatientFileImportProcessor;
import com.ahsrcm.client.scanning.TiffImageSource;
import com.ahsrcm.client.scanning.gui.autoimport.ProgessMonitorUI;
import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.BatchType;
import com.ahsrcm.corp.Doctor;
import com.ahsrcm.corp.Location;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.User;
import com.ahsrcm.corp.rules.RuleManager;
import com.ahsrcm.corp.rules.Stage;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.util.guice.Directories;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.guice.LifeCycleListeners;
import net.model3.guice.bootstrap.ConfigurationDirectory;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.ThrowableX;
import net.model3.lang.TimeDuration;
import net.model3.lang.Visitor;
import net.model3.logging.LogHelper;
import net.model3.logging.Logger;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.newfile.Path;
import net.model3.swing.EventManager;
import net.model3.text.ThreadSafeSimpleDateFormat;

@Singleton
public class FileMonitor
implements LifeCycleListeners.Config {
    private final Object DirectoryCreationMutex = new Object();
    private static final Logger logger = LogHelper.getLog(FileMonitor.class);
    Lock _processingLock = new ReentrantLock();
    boolean _running = false;
    SimpleDateFormat _dateFormat = new SimpleDateFormat("yyMMdd");
    List<User> _coders;
    public final EventManager<ProgessMonitorUI> progressMonitors = EventManager.create((boolean)true);
    @Inject
    ClientScanningDao _dao;
    @Inject
    Injector _injector;
    @Inject
    Directories _directories;
    @Inject
    ImporterDirectories _importerDirectories;
    @Inject
    ThreadScheduler _scheduler;
    public static final DateFormat THREADSAFE_DATE_FORMATTER = new ThreadSafeSimpleDateFormat("yyyy-MM-dd-EEE_HH-mm-ss-SSS");

    public static boolean isImage(File file) {
        String string = file.getName().toLowerCase();
        if (string.endsWith(".tif")) {
            return true;
        }
        return string.endsWith(".tiff");
    }

    public static Directory getConfigDir() {
        return (Directory)((ConfigurationDirectory)DependencyInjector.getInstance(ConfigurationDirectory.class)).get();
    }

    @Inject
    private FileMonitor() {
    }

    public void configComplete() {
        this.start();
    }

    public void start() {
        if (!this._running) {
            this._running = true;
            this.submitFileCountsUpdate();
        }
    }

    public void setCoders(List<User> list) {
        this._coders = list;
        this._importerDirectories.makeDirectories();
        for (User user : this._coders) {
            Directory directory = this._importerDirectories.createBatchQueue.subDirectory(user.getLoginName());
            if (directory.exists()) continue;
            directory.makeDirectories();
        }
    }

    void submitFileCountsUpdate() {
        this._scheduler.schedule("import-file-counts-updater", new TimeDuration("15 seconds"), new Runnable(){

            @Override
            public void run() {
                try {
                    FilesToProcess filesToProcess = new FilesToProcess();
                    filesToProcess.updateCounts();
                    if (filesToProcess.hasImports()) {
                        FileMonitor.this.submitMainProcessor();
                    }
                }
                finally {
                    FileMonitor.this.submitFileCountsUpdate();
                }
            }
        });
    }

    void submitMainProcessor() {
        this._scheduler.submit("import-main-processor", new Runnable(){

            @Override
            public void run() {
                if (FileMonitor.this.tryToAquireLock()) {
                    try {
                        FilesToProcess filesToProcess;
                        while ((filesToProcess = new FilesToProcess()).hasImports()) {
                            filesToProcess.process();
                        }
                    }
                    finally {
                        FileMonitor.this.releaseLock();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Directory createDirectory(Directory directory) {
        Object object = this.DirectoryCreationMutex;
        synchronized (object) {
            Directory directory2 = directory.subDirectory(FileMonitor.getFileSystemCompatibleTimestamp());
            while (directory2.exists()) {
                logger.debug((Object)"createDirectory() directory {} exists waiting to try again", (Object)directory2);
                directory2 = directory.subDirectory(FileMonitor.getFileSystemCompatibleTimestamp());
            }
            logger.debug((Object)"createDirectory() returning {}", (Object)directory2);
            directory2.makeDirectories();
            return directory2;
        }
    }

    void move(Path<?> path, Directory directory) {
        if (path.isDirectory()) {
            logger.debug((Object)"moving directory {} to {}", path, (Object)directory);
            ((Directory)path).moveTo(directory.subDirectory(path.getName()));
        } else {
            File file = (File)path;
            logger.debug((Object)"moving file {} to {}", (Object)file, (Object)directory);
            file.moveTo(directory);
        }
    }

    void runProcessor(ImportProcessor importProcessor, Path<?> path) {
        importProcessor.process();
        this.move(path, importProcessor.getCompletionDirectory());
    }

    boolean tryToAquireLock() {
        boolean bl = this._processingLock.tryLock();
        logger.debug((Object)"_processingLock => {}", (Object)bl);
        return bl;
    }

    void releaseLock() {
        this._processingLock.unlock();
        logger.debug((Object)"_processingLock released");
    }

    void processError(Path<?> path, Throwable throwable) {
        logger.error((Object)"error processing {}", path, (Object)throwable);
        Directory directory = this.createDirectory(this._importerDirectories.errors);
        this.move(path, directory);
        File file = directory.file("errors.log");
        file.write(ThrowableX.getStackTrace((Throwable)throwable));
    }

    public static String getFileSystemCompatibleTimestamp() {
        return FileMonitor.getFileSystemCompatibleTimestamp(new java.util.Date());
    }

    public static String getFileSystemCompatibleTimestamp(java.util.Date date) {
        return THREADSAFE_DATE_FORMATTER.format(date);
    }

    public class FilesToProcess {
        public final List<Path<?>> stragglers = ListX.create();
        public final List<Path<?>> batches = ListX.create();

        public FilesToProcess() {
            for (Directory directory : FileMonitor.this._importerDirectories.createBatchQueue.subDirectories()) {
                this.batches.addAll(directory.files());
                this.batches.addAll(directory.subDirectories());
            }
            for (Directory directory : FileMonitor.this._importerDirectories.stragglerQueue.files()) {
                if (!FileMonitor.isImage((File)directory)) continue;
                this.stragglers.add((Path<?>)directory);
            }
            this.stragglers.addAll(FileMonitor.this._importerDirectories.stragglerQueue.subDirectories());
        }

        void updateCounts() {
            FileMonitor.this.progressMonitors.safeDispatch((Visitor)new Visitor<ProgessMonitorUI>(){

                public void visit(ProgessMonitorUI progessMonitorUI) {
                    progessMonitorUI.updateCounts(FilesToProcess.this.batches.size(), FilesToProcess.this.stragglers.size(), FileMonitor.this._directories.scannedImageUploadQueue().files().size());
                }
            });
        }

        boolean hasImports() {
            return !this.stragglers.isEmpty() || !this.batches.isEmpty();
        }

        void process() {
            for (Path<?> path : this.stragglers) {
                try {
                    this.processStraggler(path);
                }
                catch (Throwable throwable) {
                    FileMonitor.this.processError(path, throwable);
                }
            }
            for (Path<?> path : this.batches) {
                try {
                    this.processBatch(path);
                }
                catch (Throwable throwable) {
                    FileMonitor.this.processError(path, throwable);
                }
            }
        }

        public void processStraggler(Path<?> path) {
            logger.debug((Object)"Process the straggler file {}", (Object)path.getPath());
            String[] stringArray = path.getName().split("--");
            int n = 1;
            if (stringArray.length == 1) {
                n = 0;
            }
            String[] stringArray2 = stringArray[n].split("_");
            Long l = Long.valueOf(stringArray2[1]);
            PatientFile patientFile = PatientFile.fetchByPk((Long)l);
            TiffImageSource tiffImageSource = new TiffImageSource(path, false);
            final ScanBatch scanBatch = patientFile.getBatch();
            PatientFileImportProcessor patientFileImportProcessor = new PatientFileImportProcessor(FileMonitor.this._injector, patientFile, tiffImageSource, new ImportProcessor.ListenerAdapter(){

                @Override
                public void error() {
                    logger.info((Object)"Scan failed. Ready to cancel batch ({}) and error out the file.", (Object)scanBatch.getId());
                    FileMonitor.this._dao.cancelScanBatch(scanBatch);
                }
            });
            FileMonitor.this.runProcessor(patientFileImportProcessor, path);
        }

        public void processBatch(Path<?> path) throws Exception {
            ImageIndexer imageIndexer;
            Object object2;
            logger.debug((Object)"Process the batch {}", (Object)path.getPath());
            String string = path.getBaseFilename();
            String[] stringArray = string.split("--");
            int n = 1;
            if (stringArray.length == 1) {
                n = 0;
            }
            String[] stringArray2 = stringArray[n].split("_");
            final ScanBatch scanBatch = new ScanBatch();
            scanBatch.location.set((Object)Location.fetchByPk((String)stringArray2[2], (String)stringArray2[3], (String)stringArray2[4]));
            scanBatch.dateOfService.set((Object)new Date(FileMonitor.this._dateFormat.parse(stringArray2[5]).getTime()));
            scanBatch.batchType.set((Object)BatchType.fetchByPk((String)stringArray2[6]));
            if (stringArray2.length == 8) {
                scanBatch.doctor.set((Object)Doctor.fetchByPk((String)stringArray2[2], (String)stringArray2[3], (String)stringArray2[7]));
            }
            User user = null;
            for (Object object2 : FileMonitor.this._coders) {
                if (!((String)object2.loginName.get()).equals(path.getParent().getName())) continue;
                user = object2;
                break;
            }
            Iterator<User> iterator = user;
            scanBatch.coder.set(iterator);
            scanBatch.id.set((Object)FileMonitor.this._dao.nextControlNumber(ScanBatch.class));
            scanBatch.stage.set((Object)((Stage)Stage.ScanningInProgress.get()));
            logger.debug((Object)"inserting scan batch {}", scanBatch.id.get());
            FileMonitor.this._dao.insert((BaseBusinessBean)scanBatch);
            object2 = new TiffImageSource(path, false);
            if ("B".equalsIgnoreCase(stringArray2[0])) {
                imageIndexer = (ImageIndexer)FileMonitor.this._injector.getInstance(BlankPageIndexer.class);
                ((BlankPageIndexer)imageIndexer).isDuplex("DUPLEX".equalsIgnoreCase(stringArray2[1]));
            } else if ("1".equalsIgnoreCase(stringArray2[0])) {
                imageIndexer = (ImageIndexer)FileMonitor.this._injector.getInstance(FixedPageCountIndexer.class);
                ((FixedPageCountIndexer)imageIndexer).setPagesPerPatientFile(1);
            } else if ("2".equalsIgnoreCase(stringArray2[0])) {
                imageIndexer = (ImageIndexer)FileMonitor.this._injector.getInstance(FixedPageCountIndexer.class);
                ((FixedPageCountIndexer)imageIndexer).setPagesPerPatientFile(2);
            } else if ("3".equalsIgnoreCase(stringArray2[0])) {
                imageIndexer = (ImageIndexer)FileMonitor.this._injector.getInstance(FixedPageCountIndexer.class);
                ((FixedPageCountIndexer)imageIndexer).setPagesPerPatientFile(3);
            } else {
                imageIndexer = (ImageIndexer)FileMonitor.this._injector.getInstance(NoIndexingImageIndexer.class);
            }
            ImportProcessorImpl importProcessorImpl = new ImportProcessorImpl(FileMonitor.this._injector, scanBatch, (ImageSource)object2, imageIndexer, null, true, new ImportProcessor.ListenerAdapter((User)iterator){
                final /* synthetic */ User val$coder;
                {
                    this.val$coder = user;
                }

                @Override
                public void success() {
                    logger.debug((Object)"Scan was completed for scan batch {}. Ready to finish scanning and complete the file.", scanBatch.id.get());
                    scanBatch.expectedVisitCount.set((Object)scanBatch.patientFiles.size());
                    FileMonitor.this._dao.update((BaseBusinessBean)scanBatch);
                    FileMonitor.this._dao.finishScanning(scanBatch, (Stage)((RuleManager)scanBatch.ruleManager.get()).getNextRequiredRule((Stage)((Stage)Stage.ScanningInProgress.get())).stage.get(), this.val$coder);
                }

                @Override
                public void error() {
                    logger.info((Object)"Scan failed. Ready to cancel batch ({}) and error out the file.", scanBatch.id.get());
                    FileMonitor.this._dao.cancelScanBatch(scanBatch);
                }
            });
            FileMonitor.this.runProcessor(importProcessorImpl, path);
        }
    }
}

