/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImportProcessor;
import com.ahsrcm.client.scanning.ImportStep;
import com.ahsrcm.client.scanning.ImportedImage;
import com.ahsrcm.client.scanning.QueueMessage;
import com.ahsrcm.corp.BaseBusinessBean;
import com.ahsrcm.corp.PatientFile;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.ScannedImage;
import com.ahsrcm.scanning.app.client.beans.CorrespondenceScanningInfo;
import com.ahsrcm.scanning.dao.ClientScanningDao;
import com.ahsrcm.scanning.dao.ScanningDao;
import net.java.dev.properties.jdbc.Session;
import net.model3.collections.Queue;

public class DatabaseStep
extends ImportStep {
    PatientFile _currentPatientFile;
    ScanBatch _scanBatch;
    private final ClientScanningDao _dao;
    private final CorrespondenceScanningInfo _correspondenceScanningInfo;

    public DatabaseStep(ClientScanningDao clientScanningDao, CorrespondenceScanningInfo correspondenceScanningInfo) {
        this._dao = clientScanningDao;
        this._correspondenceScanningInfo = correspondenceScanningInfo != null ? correspondenceScanningInfo : new CorrespondenceScanningInfo();
    }

    @Override
    public void start(ImportProcessor importProcessor, Queue<QueueMessage> queue, Queue<QueueMessage> queue2, Session session) {
        super.start(importProcessor, queue, queue2, session);
        this._scanBatch = importProcessor.getScanBatch();
    }

    @Override
    public void processImage(ImportedImage importedImage) {
        String string = importedImage.getImageData().getFileName();
        this.logger.debug((Object)("PDF_DEBUG: DatabaseStep.processImage() for " + string));
        this.logger.debug((Object)("PDF_DEBUG: isOriginalDocument=" + importedImage.isOriginalDocument() + ", isValidImage=" + importedImage.isValidImage() + ", startNewPatientFile=" + importedImage.getStartNewPatientFile()));
        if (importedImage.isOriginalDocument()) {
            this.logger.debug((Object)"importedImage.import source image");
            ScannedImage scannedImage = new ScannedImage();
            scannedImage.setBatch(this._importProcessor.getScanBatch());
            scannedImage.setId(Long.valueOf(((ScanningDao)ScanningDao.Impl.get()).nextControlNumber(ScannedImage.class)));
            scannedImage.setFileName(string);
            importedImage.setScannedImage(scannedImage);
        } else {
            if (importedImage.getStartNewPatientFile()) {
                this.logger.debug((Object)"importedImage.getStartNewPatientFile() == true");
                this.logger.debug((Object)"PDF_DEBUG: Resetting _currentPatientFile to null");
                this._currentPatientFile = null;
            }
            if (this._currentPatientFile == null && importedImage.isValidImage()) {
                this.logger.debug((Object)"importedImage.isValidImage() == true");
                this.logger.debug((Object)"PDF_DEBUG: Creating new patient file");
                this._currentPatientFile = this.updatePatientFileCorrespondenceScanningFields();
                this.logger.debug((Object)("current patient file | " + this._currentPatientFile));
            }
            if (importedImage.isValidImage()) {
                this.logger.debug((Object)"importedImage.isValidImage() == true");
                this.logger.debug((Object)("PDF_DEBUG: Creating ScannedImage for patient file " + (this._currentPatientFile != null ? this._currentPatientFile.getId() : "NULL")));
                ScannedImage scannedImage = this._currentPatientFile.newScannedImage(false);
                scannedImage.setFileName(string);
                importedImage.setScannedImage(scannedImage);
                importedImage.setPatientFile(this._currentPatientFile);
            } else {
                this.logger.debug((Object)"PDF_DEBUG: Skipping image (not valid)");
            }
        }
        if (importedImage.getScannedImage() != null) {
            this.logger.debug((Object)"PDF_DEBUG: Inserting ScannedImage into database");
            importedImage.getScannedImage().insert();
        } else {
            this.logger.debug((Object)"PDF_DEBUG: No ScannedImage to insert");
        }
        this.send(importedImage);
    }

    public PatientFile updatePatientFileCorrespondenceScanningFields() {
        Long l;
        boolean bl;
        boolean bl2;
        PatientFile patientFile = this._scanBatch.addPatientFile();
        String string = this._correspondenceScanningInfo.resolvePatientNumberString();
        boolean bl3 = bl2 = !string.isEmpty();
        if (bl2) {
            patientFile.setPatientNumber(string);
        }
        boolean bl4 = bl = (l = this._correspondenceScanningInfo.resolveEncounter()) != 0L;
        if (bl) {
            patientFile.setEncounter(l);
        }
        if (bl || bl2) {
            this._dao.update((BaseBusinessBean)patientFile);
        }
        return patientFile;
    }

    public void setCurrentPatientFile(PatientFile patientFile) {
        this._currentPatientFile = patientFile;
    }
}

