/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImageData;
import com.ahsrcm.client.scanning.ImageSourceCallback;
import com.ahsrcm.client.scanning.ScannedImageSource;
import com.ahsrcm.core.util.DeployEdgeProperties;
import com.ahsrcm.scanning.device.Feeder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.io.IOHelper;
import net.model3.lang.Executor;
import net.model3.lang.StringX;
import net.model3.lang.SystemX;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.ThrowableX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

public class ClscanImageSource
extends ScannedImageSource {
    static Logger logger = LoggerHelper.getLogger();
    final String _scannerName;
    final boolean _useScan2;

    static String logScannerParms(String string) {
        List list = ListX.create((Object[])new String[]{"/GetColorTypes", "/GetResolutions", "/GetPageSizes", "/GetThreshold", "/GetContrast", "/GetBrightness", "/GetSource"});
        Executor executor = new Executor();
        String string2 = "clscan.exe /SetScanner \"" + string + "\" " + StringX.join((Iterable)list, (String)" ");
        executor.setCommandLine(string2);
        logger.debug((Object)"executing -- {}", (Object)string2);
        executor.execute();
        String string3 = executor.getLastOutput();
        logger.debug((Object)"stdout --\n{}", (Object)StringX.indent((String)string3, (String)"        "));
        return "\n" + string + ":\n" + string3 + "\n";
    }

    public static void logAllSpecs() {
        logger.debug((Object)"logging specs for all avaiable scanners");
        String string = "";
        for (String string2 : ClscanImageSource.getScannerIds()) {
            string = string + ClscanImageSource.logScannerParms(string2);
        }
        logger.debug((Object)string);
    }

    public static final List<ClscanImageSource> getScanners() {
        DeployEdgeProperties deployEdgeProperties = (DeployEdgeProperties)DependencyInjector.getInstance(DeployEdgeProperties.class);
        List list = ListX.create();
        for (String string : ClscanImageSource.getScannerIds()) {
            if (deployEdgeProperties.getUseClScanners().booleanValue()) {
                list.add(new ClscanImageSource(string, false));
            }
            if (!deployEdgeProperties.getUseCl2Scanners().booleanValue()) continue;
            list.add(new ClscanImageSource(string, true));
        }
        return list;
    }

    public static final List<String> getScannerIds() {
        if (!SystemX.isWindows()) {
            logger.debug((Object)"cannot get scanners because system not a windows system");
            return Collections.emptyList();
        }
        List list = ListX.create();
        Executor executor = new Executor();
        executor.setCommandLine("clscan.exe /GetScanners");
        executor.execute();
        logger.debug((Object)("/GetScanners output:\n{}" + StringX.indent((String)executor.getLastOutput(), (String)"    ")));
        if (executor.getLastResult() != 0) {
            logger.warn((Object)"error running clscan getscanners \n\texit code = {}\n\tstdout = {}\n\tstderr = {}", (Object)executor.getLastResult(), (Object)executor.getLastOutput(), (Object)executor.getLastError());
        } else {
            for (String string : StringX.lines((String)executor.getLastOutput())) {
                String string2 = string.trim();
                if (!StringX.isNotBlank((String)string2) || string2.trim().equalsIgnoreCase("Supported scanners:")) continue;
                list.add(string2);
            }
        }
        return list;
    }

    public ClscanImageSource(String string, boolean bl) {
        this._scannerName = string;
        this._useScan2 = bl;
    }

    @Override
    public boolean isDuplex() {
        return this.getFeeder() == Feeder.Duplex;
    }

    @Override
    public void startImport(ImageSourceCallback imageSourceCallback) {
        this._importProcessor.onImageProcessingStarted();
        List list = ListX.create();
        Directory directory = this.getImportProcessor().getWorkDirectory().subdir("clscan").getCanonical();
        String string = directory.getCanonicalPath().toLowerCase();
        list.add("clscan.exe");
        list.add("/SetScanner");
        list.add(this._scannerName);
        list.add("/SetColorType");
        list.add("BW");
        list.add("/SetResolution");
        list.add("200");
        list.add("/SetPageSizes");
        list.add("USLETTER");
        list.add("/SetFileName");
        list.add(string + "img-" + System.currentTimeMillis() + "-&COUNTER&.tiff");
        if (this.isDuplex()) {
            list.add("/SetDuplex");
        }
        if (this.getShowOptionsDialog()) {
            list.add("/ShowUI");
        }
        if (this._useScan2) {
            list.add("/UseScan2");
        }
        list.add("/SetMultiFile");
        try {
            String string2;
            Process process = Runtime.getRuntime().exec(list.toArray(new String[0]));
            this.pipeToErrorLog(process.getErrorStream());
            String string3 = " is saved.";
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                String string4 = string2.trim().toLowerCase();
                logger.debug((Object)("processing line - " + string2));
                if (!string4.endsWith(string3)) continue;
                imageSourceCallback.newImage(new ImageData.TiffFileImageData(new File(string4.substring(0, string4.length() - string3.length()))), true);
            }
            int n = process.waitFor();
            logger.debug((Object)"process exited with exitCode = {}", (Object)n);
        }
        catch (Exception exception) {
            logger.warn((Object)("error processing - " + StringX.join((Iterable)list, (String)" ")), (Object)exception);
            throw new RuntimeException(exception);
        }
    }

    void pipeToErrorLog(final InputStream inputStream) {
        ((ThreadScheduler)DependencyInjector.getInstance(ThreadScheduler.class)).submit("", new Runnable(){

            @Override
            public void run() {
                BufferedReader bufferedReader = null;
                try {
                    String string;
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((string = bufferedReader.readLine()) != null) {
                        logger.error((Object)("error in clscan.exe process -- " + string));
                    }
                }
                catch (Exception exception) {
                    try {
                        throw ThrowableX.throwUnchecked((Throwable)exception);
                    }
                    catch (Throwable throwable) {
                        IOHelper.close(bufferedReader);
                        throw throwable;
                    }
                }
                IOHelper.close((Reader)bufferedReader);
            }
        });
    }

    public String getId() {
        return this._scannerName;
    }

    @Override
    public String getName() {
        String string = this._useScan2 ? "2" : "";
        return this._scannerName + " (cl" + string + ")";
    }
}

