/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImageIndexer;
import com.ahsrcm.client.scanning.ImportedImage;
import com.ahsrcm.client.scanning.IndexingStep;
import com.ahsrcm.util.PixelChecker;
import com.google.inject.Inject;
import java.awt.image.BufferedImage;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class BlankPageIndexer
implements ImageIndexer {
    private static final Logger logger = LoggerHelper.getLogger(PixelChecker.class);
    @Inject
    PixelChecker _pixelChecker;
    ImportedImage _previousImage = null;
    boolean _duplex = true;
    boolean _validImageSinceStartNewPatientFile;

    @Inject
    private BlankPageIndexer() {
    }

    @Override
    public void start(IndexingStep indexingStep) {
        this._duplex = indexingStep.getImportProcessor().getImageSource().isDuplex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexImage(ImportedImage importedImage) {
        boolean bl = false;
        logger.debug((Object)("PDF_DEBUG: BlankPageIndexer.indexImage() for " + importedImage.getImageData().getFileName()));
        logger.debug((Object)("PDF_DEBUG: doBlankImageCheck = " + importedImage.isDoBlankImageCheck()));
        try {
            BufferedImage bufferedImage = importedImage.getImageData().asBufferedImage();
            try {
                if (importedImage.isDoBlankImageCheck()) {
                    bl = this._pixelChecker.isImageBlank(bufferedImage);
                    logger.debug((Object)("PDF_DEBUG: Blank page check result: " + bl));
                }
            }
            finally {
                bufferedImage.flush();
            }
            if (bl) {
                boolean bl2 = this.startNewPatientFile(importedImage);
                logger.debug((Object)("PDF_DEBUG: Blank page detected, startNewPatientFile=" + bl2));
                importedImage.setStartNewPatientFile(bl2);
                importedImage.setValidImage(false);
            } else {
                importedImage.setStartNewPatientFile(false);
                importedImage.setValidImage(true);
                logger.debug((Object)"PDF_DEBUG: Valid (non-blank) page");
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error checking if image is blank", (Object)exception);
            importedImage.setValidImage(false);
            importedImage.setStartNewPatientFile(false);
        }
        if (importedImage.getStartNewPatientFile()) {
            this._validImageSinceStartNewPatientFile = false;
        }
        if (importedImage.isValidImage()) {
            this._validImageSinceStartNewPatientFile = true;
        }
        this._previousImage = importedImage;
    }

    boolean startNewPatientFile(ImportedImage importedImage) {
        if (this._previousImage == null) {
            return false;
        }
        if (!this._duplex && this._validImageSinceStartNewPatientFile) {
            return true;
        }
        return this._duplex && this._validImageSinceStartNewPatientFile && !this._previousImage.isValidImage();
    }

    public void isDuplex(boolean bl) {
        this._duplex = bl;
    }

    public boolean isDuplex() {
        return this._duplex;
    }
}

