/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.scanning;

import com.ahsrcm.client.scanning.ImageIndexer;
import com.ahsrcm.client.scanning.ImageSource;
import com.ahsrcm.client.scanning.ImportProcessor;
import com.ahsrcm.client.scanning.ImportStep;
import com.ahsrcm.client.scanning.ImportedImage;
import com.ahsrcm.client.scanning.ImporterDirectories;
import com.ahsrcm.client.scanning.QueueMessage;
import com.ahsrcm.corp.ScanBatch;
import com.ahsrcm.corp.orm.ClientSideSessionContext;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.java.dev.properties.jdbc.Session;
import net.model3.collections.ListX;
import net.model3.collections.Queue;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.TimeDuration;
import net.model3.lang.Visitor;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.newfile.Directory;
import net.model3.swing.EventManager;
import net.model3.text.ThreadSafeSimpleDateFormat;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;

public abstract class AbstractImportProcessor
implements ImportProcessor {
    final Logger logger = LoggerHelper.getLogger();
    public final ScanBatch scanBatch;
    public final ImageSource imageSource;
    public final ImageIndexer indexer;
    public final List<ImportStep> steps = ListX.create();
    public final EventManager<ImportProcessor.Listener> listeners = EventManager.create();
    public final UUID uuid = UUID.randomUUID();
    final AtomicInteger _nextId = new AtomicInteger(1);
    final boolean _createSession;
    ImportProcessor.Status _status = ImportProcessor.Status.NotStarted;
    final FileAppender _appender;
    final Directory _workDirectory;
    Directory _completionDirectory;
    static final DateFormat THREADSAFE_DATE_FORMATTER = new ThreadSafeSimpleDateFormat("yyyy-MM-dd-EEE_HH-mm-ss-SSS");

    public AbstractImportProcessor(ScanBatch scanBatch, ImageSource imageSource, ImageIndexer imageIndexer, boolean bl) {
        this.scanBatch = scanBatch;
        this.imageSource = imageSource;
        this.indexer = imageIndexer;
        this._createSession = bl;
        imageSource.setImportProcessor(this);
        this.listeners.addListener((Object)new ImportProcessor.ListenerAdapter(){

            @Override
            public void success() {
                AbstractImportProcessor.this._status = ImportProcessor.Status.Success;
            }

            @Override
            public void error() {
                AbstractImportProcessor.this._status = ImportProcessor.Status.Failure;
            }
        });
        this._workDirectory = ((ImporterDirectories)DependencyInjector.getInstance(ImporterDirectories.class)).work.subdir(this.uuid.toString());
        this._workDirectory.makeDirectories();
        try {
            this._appender = new FileAppender(new SimpleLoggingConfigurator().getDefaultLayout(), this._workDirectory.file("log.txt").getCanonicalPath());
            this._appender.activateOptions();
        }
        catch (Exception exception) {
            throw ExceptionPropagator.throwUnchecked((Throwable)exception);
        }
    }

    @Override
    public ImportedImage newImportedImage() {
        ImportedImage importedImage = new ImportedImage();
        importedImage._id = this._nextId.getAndIncrement();
        return importedImage;
    }

    @Override
    public Directory getWorkDirectory() {
        return this._workDirectory;
    }

    @Override
    public void process() {
        Directory directory;
        ImportStep importStep3;
        this._status = ImportProcessor.Status.Processing;
        ClientSideSessionContext clientSideSessionContext = (ClientSideSessionContext)DependencyInjector.getInstance(ClientSideSessionContext.class);
        Session session = this._createSession ? clientSideSessionContext.newSession() : clientSideSessionContext.currentSession(true);
        ImportStep importStep2 = null;
        for (ImportStep importStep3 : this.steps) {
            directory = null;
            Queue queue = new Queue();
            if (importStep2 != null) {
                directory = importStep2._outgoingQueue;
            }
            importStep3.start(this, (Queue<QueueMessage>)directory, (Queue<QueueMessage>)queue, session);
            importStep2 = importStep3;
        }
        this.waitForCompletion();
        ImporterDirectories importerDirectories = (ImporterDirectories)DependencyInjector.getInstance(ImporterDirectories.class);
        importStep3 = this.hasErrors() ? importerDirectories.errors : importerDirectories.successes;
        this._appender.close();
        this._completionDirectory = AbstractImportProcessor.createDirectory((Directory)importStep3);
        directory = this.getWorkDirectory();
        if (directory.exists()) {
            directory.moveTo(this._completionDirectory.subdir(directory.getName()));
        }
    }

    @Override
    public Directory getCompletionDirectory() {
        return this._completionDirectory;
    }

    @Override
    public void logFatalError(final String string, final String string2, final Throwable throwable) {
        this.logger.error((Object)string2, (Object)throwable);
        this.listeners.safeDispatch((Visitor)new Visitor<ImportProcessor.Listener>(){

            public void visit(ImportProcessor.Listener listener) throws Exception {
                listener.logFatalError(string, string2, throwable);
            }
        });
    }

    @Override
    public ImportProcessor.Status getStatus() {
        return this._status;
    }

    @Override
    public boolean complete() {
        for (ImportStep importStep : this.steps) {
            if (!importStep.isRunning()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasErrors() {
        for (ImportStep importStep : this.steps) {
            if (importStep.getError() == null) continue;
            return true;
        }
        return this.getStatus() == ImportProcessor.Status.Failure;
    }

    void waitForCompletion() {
        TimeDuration timeDuration = new TimeDuration("15 seconds");
        while (!this.complete()) {
            timeDuration.sleep();
        }
    }

    @Override
    public Appender getAppender() {
        return this._appender;
    }

    @Override
    public EventManager<ImportProcessor.Listener> getListeners() {
        return this.listeners;
    }

    @Override
    public ScanBatch getScanBatch() {
        return this.scanBatch;
    }

    @Override
    public ImageSource getImageSource() {
        return this.imageSource;
    }

    @Override
    public void onImageProcessingStarted() {
        this.getListeners().safeDispatch((Visitor)new Visitor<ImportProcessor.Listener>(){

            public void visit(ImportProcessor.Listener listener) {
                listener.start();
            }
        });
    }

    static synchronized Directory createDirectory(Directory directory) {
        Directory directory2 = directory.subDirectory(AbstractImportProcessor.getFileSystemCompatibleTimestamp());
        while (directory2.exists()) {
            LoggerHelper.getLogger().debug((Object)"createDirectory() directory {} exists waiting to try again", (Object)directory2);
            directory2 = directory.subDirectory(AbstractImportProcessor.getFileSystemCompatibleTimestamp());
        }
        LoggerHelper.getLogger().debug((Object)"createDirectory() returning {}", (Object)directory2);
        directory2.makeDirectories();
        return directory2;
    }

    static String getFileSystemCompatibleTimestamp() {
        return AbstractImportProcessor.getFileSystemCompatibleTimestamp(new Date());
    }

    static String getFileSystemCompatibleTimestamp(Date date) {
        return THREADSAFE_DATE_FORMATTER.format(date);
    }
}

