/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.launcher;

import com.ahsrcm.client.launcher.StubbyApp;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.image.BufferedImage;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

public class StubbySampleApp
implements StubbyApp {
    JFrame _frame;
    JLabel _label = new JLabel();
    Logger logger = LoggerHelper.getLogger();
    StringBuilder _text = new StringBuilder();

    @Override
    public String appName() {
        return "stubby";
    }

    @Override
    public void processCommandLine(String string) {
        this._text.append(new Date()).append("  ").append(string).append("<br>");
        this._label.setText("<html>" + this._text + "</html>");
    }

    @Override
    public void start() {
        this._frame = new JFrame("Stubby");
        this._frame.add(new JScrollPane(this._label));
        this._frame.setDefaultCloseOperation(3);
        this._frame.setLocation(100, 100);
        this._frame.setSize(800, 400);
        this._frame.setVisible(true);
        this.registerTrayIcon();
    }

    @Override
    public Component getMainView() {
        return this._frame;
    }

    void registerTrayIcon() {
        if (SystemTray.isSupported()) {
            SystemTray systemTray = SystemTray.getSystemTray();
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(this.getClass().getClassLoader().getResource("windows.png"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            MouseAdapter mouseAdapter = new MouseAdapter(){};
            PopupMenu popupMenu = new PopupMenu();
            MenuItem menuItem = new MenuItem("Exit");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StubbySampleApp.this.logger.debug((Object)"Exit from tray menu");
                    System.exit(0);
                }
            });
            popupMenu.add(menuItem);
            final TrayIcon trayIcon = new TrayIcon(bufferedImage, "Tray Demo", popupMenu);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    trayIcon.displayMessage("Action Event", "An Action Event Has Been Performed!", TrayIcon.MessageType.INFO);
                }
            };
            trayIcon.setImageAutoSize(true);
            trayIcon.addActionListener(actionListener);
            trayIcon.addMouseListener(mouseAdapter);
            trayIcon.addMouseMotionListener(mouseAdapter);
            try {
                systemTray.add(trayIcon);
            }
            catch (AWTException aWTException) {
                this.logger.error((Object)"TrayIcon could not be added.", (Object)aWTException);
            }
        } else {
            this.logger.debug((Object)"System Tray is not supported");
        }
    }
}

