/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.launcher;

import com.ahsrcm.client.launcher.StubbyApp;
import com.google.inject.Inject;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileLock;
import java.util.UUID;
import javax.swing.JOptionPane;
import net.model3.guice.DependencyInjector;
import net.model3.io.IOHelper;
import net.model3.lang.ThreadScheduler;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.LoggingConfigurator;
import net.model3.newfile.Directory;
import net.model3.newfile.File;

public class StubbyLauncher {
    static Logger logger = LoggerHelper.getLogger();
    @Inject
    ThreadScheduler _threadScheduler;
    @Inject
    LoggingConfigurator _loggingConfigurator;
    ServerSocket _serverSocket;
    FileLock _sessionFileLock;
    UUID _uuid = UUID.randomUUID();
    @Inject
    StubbyApp _app;

    public static void main(String[] stringArray) {
        try {
            ((StubbyLauncher)DependencyInjector.getInstance(StubbyLauncher.class)).run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            logger.fatal((Object)exception);
        }
    }

    void run(String[] stringArray) {
        logger.debug((Object)("session file = " + this.getSessionFile().getCanonicalPath()));
        logger.debug((Object)("uuid = " + this._uuid));
        logger.debug((Object)("port = " + this.getPort()));
        logger.debug((Object)("pid = " + this.getPid()));
        this.obtainSessionLock();
        this.startSingleInstanceDaemon();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
        this._app.start();
        this.processCommandLine(stringBuilder.toString());
    }

    void obtainSessionLock() {
        File file = this.getSessionLockFile();
        try {
            this.registerShutdownHook();
            if (!file.exists()) {
                file.write(this.getIniInfo());
            }
            this._sessionFileLock = new RandomAccessFile(file.asFile(), "rw").getChannel().tryLock();
            if (this._sessionFileLock == null) {
                this.showErrorDialogAndExit("Unable to start ahs stubby the lock file is already locked by another process");
            }
            this.writeSessionFile();
        }
        catch (Exception exception) {
            this.showErrorDialogAndExit("Error trying to obtain the lock.  " + exception.getMessage());
        }
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){
            {
                this.setName("cleanup-shutdown-hook");
            }

            @Override
            public void run() {
                if (StubbyLauncher.this._sessionFileLock != null) {
                    try {
                        StubbyLauncher.this._sessionFileLock.release();
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception);
                    }
                    try {
                        StubbyLauncher.this.getSessionFile().delete();
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception);
                    }
                }
            }
        });
    }

    int getPort() {
        return this.getServerSocket().getLocalPort();
    }

    ServerSocket getServerSocket() {
        if (this._serverSocket == null) {
            try {
                this._serverSocket = new ServerSocket(0, 10, InetAddress.getByName("localhost"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this._serverSocket;
    }

    void showErrorDialogAndExit(String string) throws HeadlessException {
        JOptionPane.showMessageDialog(this._app.getMainView(), string);
        System.exit(1);
    }

    String getPid() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    void processCommandLine(String string) {
        logger.debug((Object)"command line = {}", (Object)string);
        try {
            this._app.processCommandLine(string);
        }
        catch (Exception exception) {
            logger.error((Object)"error processing command line -- {}\n", (Object)string, (Object)exception);
        }
    }

    String getSessionName() {
        String string = System.getenv("SESSIONNAME");
        if (string == null) {
            string = "default";
        }
        return string;
    }

    Directory getLogsDirectory() {
        return this.getUserDirectory().subDirectory("logs");
    }

    Directory getUserHome() {
        String string = System.getenv("USERPROFILE");
        if (string == null) {
            string = System.getProperty("user.home");
        }
        return new Directory(string);
    }

    Directory getUserDirectory() {
        return new Directory(this.getUserHome(), "AHS");
    }

    File getSessionFile() {
        return this.getUserDirectory().file("session-" + this.getSessionName() + ".ini");
    }

    File getSessionLockFile() {
        return this.getUserDirectory().file("session-" + this.getSessionName() + ".lock");
    }

    void writeSessionFile() {
        File file = this.getSessionFile();
        file.getParent().makeDirectories();
        String string = this.getIniInfo();
        file.write(string);
        logger.debug((Object)"wrote session ini file {}\n{}", (Object)file.getCanonicalPath(), (Object)string);
        file.asFile().deleteOnExit();
    }

    String getIniInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[SingleInstance]").append("\n");
        stringBuilder.append("port=").append(this.getPort()).append("\n");
        stringBuilder.append("pid=").append(this.getPid()).append("\n");
        stringBuilder.append("uuid=").append(this._uuid.toString()).append("\n");
        logger.debug((Object)"ini info\n{}", (Object)stringBuilder);
        return stringBuilder.toString();
    }

    void startSingleInstanceDaemon() {
        new Thread(){
            {
                this.setName("single-instance-daemon");
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        Socket socket = StubbyLauncher.this.getServerSocket().accept();
                        StubbyLauncher.this.processSingleInstanceRequest(socket);
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                    return;
                }
            }
        }.start();
    }

    void processSingleInstanceRequest(final Socket socket) {
        this._threadScheduler.submit("single-instance-reader", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.debug((Object)"processSingleInstanceRequest() started");
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    String string = bufferedReader.readLine();
                    if (string.equals(StubbyLauncher.this._uuid.toString())) {
                        int n;
                        StringBuilder stringBuilder = new StringBuilder();
                        while ((n = bufferedReader.read()) != -1) {
                            stringBuilder.append((char)n);
                        }
                        StubbyLauncher.this.processCommandLine(stringBuilder.toString());
                        socket.getOutputStream().write("SUCCESS".getBytes());
                    } else {
                        logger.error((Object)"invalid socket uuid = {}", (Object)string);
                        socket.getOutputStream().write("FAILED".getBytes());
                    }
                    socket.getOutputStream().flush();
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                }
                finally {
                    IOHelper.close((Socket)socket);
                }
            }
        });
    }
}

