/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.tools.ui;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.StringX;

public class TextFieldOverlayDecorator {
    final JTextComponent _textComponent;
    final Document _realDocument;
    final Color _realColor;
    final Color _overlayColor = Color.GRAY;
    final Document _overlayDocument = new PlainDocument(){
        private static final long serialVersionUID = -334514596720060282L;

        @Override
        public void addDocumentListener(DocumentListener documentListener) {
            TextFieldOverlayDecorator.this._realDocument.addDocumentListener(documentListener);
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
            TextFieldOverlayDecorator.this._realDocument.addUndoableEditListener(undoableEditListener);
        }

        @Override
        public void removeDocumentListener(DocumentListener documentListener) {
            TextFieldOverlayDecorator.this._realDocument.removeDocumentListener(documentListener);
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
            TextFieldOverlayDecorator.this._realDocument.removeUndoableEditListener(undoableEditListener);
        }
    };

    public TextFieldOverlayDecorator(JTextComponent jTextComponent) {
        this(jTextComponent, "Type here to Search.");
    }

    public TextFieldOverlayDecorator(JTextComponent jTextComponent, String string) {
        this._realDocument = jTextComponent.getDocument();
        this._textComponent = jTextComponent;
        this._realColor = this._textComponent.getForeground();
        try {
            this._overlayDocument.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw ExceptionPropagator.throwUnchecked((Throwable)badLocationException);
        }
        jTextComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                TextFieldOverlayDecorator.this.updateState();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TextFieldOverlayDecorator.this.updateState();
            }
        });
        this.updateState();
    }

    boolean doesRealDocumentHaveText() {
        try {
            return StringX.isNotBlank((String)this._realDocument.getText(0, this._realDocument.getLength()));
        }
        catch (BadLocationException badLocationException) {
            throw ExceptionPropagator.throwUnchecked((Throwable)badLocationException);
        }
    }

    void updateState() {
        Color color;
        Document document;
        if (this._textComponent.hasFocus() || this.doesRealDocumentHaveText()) {
            document = this._realDocument;
            color = this._realColor;
        } else {
            document = this._overlayDocument;
            color = this._overlayColor;
        }
        if (this._textComponent.getDocument() != document) {
            this._textComponent.setDocument(document);
            this._textComponent.setForeground(color);
        }
    }
}

