/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.tools.rpc;

import com.ahsrcm.client.tools.ServerUrlProvider;
import com.ahsrcm.client.tools.SessionIdProvider;
import com.ahsrcm.client.tools.heartbeat.Heartbeater;
import com.ahsrcm.client.tools.http.ServerUnavailableException;
import com.ahsrcm.client.tools.http.ServerUnavailablePopup;
import com.ahsrcm.client.tools.login.LoginPopup;
import com.ahsrcm.client.tools.login.NotAuthorizedException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.swing.JOptionPane;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

@Singleton
public class RPCStatusChecker {
    private static final Log logger = LogHelper.getLog(RPCStatusChecker.class);
    @Inject
    Heartbeater _heartbeater;
    @Inject
    ServerUrlProvider _serverUrlProvider;
    @Inject
    SessionIdProvider _sessionIdProvider;
    @Inject
    LoginPopup _loginPopup;
    @Inject
    ServerUnavailablePopup _serverUnavailablePopup;
    LoginPopup.CallBack _callback = new LoginPopup.CallBack(){

        @Override
        public void loggedIn(String string) {
            logger.debug((Object)"New session established");
            RPCStatusChecker.this._sessionIdProvider.set(string);
        }

        @Override
        public void cancelled() {
            logger.warn((Object)"Login was cancelled.");
        }
    };

    @Inject
    protected RPCStatusChecker() {
    }

    protected void handleUnexpectedResponse(int n, byte[] byArray) {
        String string = "invalid status code " + n + " in response to request to " + this._serverUrlProvider.get();
        throw new RuntimeException(string);
    }

    public void processHttpStatus(int n, byte[] byArray) {
        if (n < 200 || n > 299) {
            if (this._heartbeater.isAlive()) {
                logger.debug((Object)("processing non-okay status code " + n));
                this._heartbeater.setAlive(false);
                if (n == 401 || n == 403) {
                    this._sessionIdProvider.set(null);
                    logger.debug((Object)"401 status returned. Invalidated current session");
                    JOptionPane.showMessageDialog(null, "You have been logged out and will need to login again.", "Login Required", 2);
                    this._loginPopup.showLogin(this._callback);
                    throw new NotAuthorizedException();
                }
                if (n == 502 || n == 503 || n == 504) {
                    logger.warn((Object)"{} status returned. Giving user option for retry", (Object)n);
                    throw new ServerUnavailableException();
                }
                logger.error((Object)"unexpected status code {} in response to request to {}\n{}", (Object)n, this._serverUrlProvider.get(), (Object)new String(byArray));
                this.handleUnexpectedResponse(n, byArray);
            }
        } else {
            this._heartbeater.setAlive(true);
        }
    }

    public void validateClientStatus() {
        if (!this._heartbeater.isAlive()) {
            if (StringX.isNotBlank((String)((String)this._sessionIdProvider.get()))) {
                throw new NotAuthorizedException();
            }
            throw new ServerUnavailableException();
        }
    }
}

