/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.tools.rpc;

import java.io.Serializable;
import net.model3.lang.SystemX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

public abstract class RPCAction
implements Serializable {
    private static final long serialVersionUID = 1421329499384867239L;
    private static final Log logger = LogHelper.getLog();
    protected String _name;
    private transient boolean _gzippedPayload = true;

    protected RPCAction() {
    }

    public RPCAction(String string) {
        this._name = string;
    }

    public <T> T execute() {
        if (this._name == null) {
            throw new IllegalStateException("name must be set");
        }
        logger.debug((Object)"executing {}", (Object)this._name);
        try {
            Object object = this.executeImpl();
            logger.debug((Object)"execution of {} completed successfully", (Object)this._name);
            return (T)object;
        }
        catch (RuntimeException runtimeException) {
            logger.warn((Object)"execution of {} completed with an exception", (Object)this._name, (Object)runtimeException);
            throw runtimeException;
        }
    }

    protected abstract Object executeImpl();

    public String getName() {
        return this._name;
    }

    public String getShortName() {
        int n = this._name.indexOf("(");
        if (n >= 0) {
            return this._name.substring(0, n);
        }
        return this._name;
    }

    public String toString() {
        return this.getName() + "@" + SystemX.identityHexHashCode((Object)this);
    }

    public void setGzippedPayload(boolean bl) {
        this._gzippedPayload = bl;
    }

    public boolean isGzippedPayload() {
        return this._gzippedPayload;
    }

    public String getPathSuffix() {
        return "";
    }
}

