/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.tools.login;

import com.ahsrcm.client.tools.DeveloperProperties;
import com.ahsrcm.client.tools.ServerUrlProvider;
import com.ahsrcm.client.tools.http.HttpRequest;
import com.ahsrcm.client.tools.http.HttpStringTransaction;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.ThreadX;
import net.model3.lang.TimeDuration;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.net.UrlX;

@Singleton
public class LoginTool {
    public static final String Path_Login = "/api/login";
    public static final String Path_GetUserName = "/api/getUserName";
    public static final String Path_GetUserId = "/api/getUserId";
    public static final String Path_ValidateLogin = "/actions/ping";
    Logger logger = LoggerHelper.getLogger();
    @Inject
    DeveloperProperties _developerProperties;
    @Inject
    ServerUrlProvider _serverUrlProvider;

    public String login() {
        String string = this._developerProperties.getProperty("eaxUser");
        String string2 = this._developerProperties.getProperty("eaxPassword");
        if (string != null && string2 != null) {
            return this.login(string, string2);
        }
        return null;
    }

    public String getUserId(final String string) {
        return (String)new HttpStringTransaction(){

            @Override
            public HttpRequest prepareRequest() {
                return new HttpRequest(){
                    {
                        this.setUrl(LoginTool.this.getRequestUrl(LoginTool.Path_GetUserId));
                        this.addCookie("sess", string);
                    }
                };
            }
        }.execute();
    }

    public String getUserLoginName(final String string) {
        return (String)new HttpStringTransaction(){

            @Override
            public HttpRequest prepareRequest() {
                return new HttpRequest(){
                    {
                        this.setUrl(LoginTool.this.getRequestUrl(LoginTool.Path_GetUserName));
                        this.addCookie("sess", string);
                    }
                };
            }
        }.execute();
    }

    public UrlX getRequestUrl(String string) {
        return ((UrlX)this._serverUrlProvider.get()).subPath(string);
    }

    public boolean isValidLogin(final String string) {
        try {
            int n = 0;
            while (true) {
                try {
                    if (Boolean.FALSE.booleanValue()) {
                        throw new IOException();
                    }
                    new HttpStringTransaction(){

                        @Override
                        public HttpRequest prepareRequest() {
                            return new HttpRequest(){
                                {
                                    this.setUrl(LoginTool.this.getRequestUrl(LoginTool.Path_ValidateLogin));
                                    this.addUrlParm("sess", string);
                                }
                            };
                        }
                    }.execute();
                    return true;
                }
                catch (IOException iOException) {
                    if (n > 5) {
                        throw ExceptionPropagator.throwUnchecked((Throwable)iOException);
                    }
                    ++n;
                    this.logger.warn((Object)iOException);
                    ThreadX.sleep((TimeDuration)new TimeDuration("5 seconds"));
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String login(final String string, final String string2) {
        String string3 = (String)new HttpStringTransaction(){

            @Override
            public HttpRequest prepareRequest() {
                return new HttpRequest(){
                    {
                        this.setUrl(LoginTool.this.getRequestUrl(LoginTool.Path_Login));
                        this.addUrlParm("u", string);
                        this.addUrlParm("p", string2);
                    }
                };
            }

            @Override
            public boolean isSuccess(int n) {
                return n == 201;
            }
        }.execute();
        this.logger.debug((Object)"User {} login response is {}", (Object)string, (Object)string3);
        return string3;
    }
}

