/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.tools.login;

import com.ahsrcm.client.tools.SessionIdProvider;
import com.ahsrcm.client.tools.login.LoginTool;
import com.ahsrcm.client.tools.ui.EnterKeyListener;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.Visitor;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.swing.EventManager;
import net.model3x.swing.M3Panel;
import org.apache.http.client.methods.HttpPost;

@Singleton
public class LoginPopup {
    private static final Log logger = LogHelper.getLog(LoginPopup.class);
    @Inject
    LoginTool _loginTool;
    JFrame _frame;
    M3Panel _root;
    JTextField _username;
    JPasswordField _password;
    JButton _button;
    JButton _cancelButton;
    Exception _exception;
    HttpPost _post;
    EventManager<CallBack> _callbacks = EventManager.create();

    @Inject
    LoginPopup() {
    }

    private void init() {
        if (this._frame == null) {
            this._frame = new JFrame("Please Log In");
            this._frame.setAlwaysOnTop(true);
            this._root = new M3Panel("ins 5");
            this._username = new JTextField();
            this._username.setPreferredSize(new Dimension(200, this._username.getPreferredSize().height));
            this._password = new JPasswordField();
            this._button = new JButton(new AbstractAction("Login"){
                private static final long serialVersionUID = -7477110674530385773L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = null;
                    try {
                        string = LoginPopup.this._loginTool.login(LoginPopup.this._username.getText(), new String(LoginPopup.this._password.getPassword()));
                    }
                    catch (Exception exception) {
                        logger.warn((Object)"login failed with ", (Object)exception);
                    }
                    if (string != null) {
                        logger.debug((Object)"User {} login response | {}", (Object)LoginPopup.this._username.getText(), (Object)string);
                        LoginPopup.this.fireLoggedIn(string);
                        LoginPopup.this._frame.dispose();
                    } else {
                        JOptionPane.showMessageDialog(LoginPopup.this._frame, "Invalid username and/or password.", "Log in Failure", 0);
                    }
                }
            });
            this._cancelButton = new JButton(new AbstractAction("Cancel"){
                private static final long serialVersionUID = -6394134803017473592L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LoginPopup.this.fireCancelled();
                    LoginPopup.this._frame.dispose();
                }
            });
            this._frame.add((Component)this._root);
            this._root.add((Component)new JLabel("Log in to DeployEdge\t"), (Object)"spanx, wrap");
            EnterKeyListener enterKeyListener = new EnterKeyListener(this._button);
            this._root.add((Component)new JLabel("Username"));
            this._root.add((Component)this._username, (Object)"growx, wrap");
            this._username.addKeyListener(enterKeyListener);
            this._root.add((Component)new JLabel("Password"));
            this._root.add((Component)this._password, (Object)"growx, wrap");
            this._password.addKeyListener(enterKeyListener);
            this._root.add((Component)this._button);
            this._button.addKeyListener(enterKeyListener);
            this._root.add((Component)this._cancelButton);
            this._frame.addKeyListener(enterKeyListener);
            this._frame.pack();
            this._frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    LoginPopup.this.fireCancelled();
                }
            });
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = this._frame.getSize().width;
            int n2 = this._frame.getSize().height;
            int n3 = (dimension.width - n) / 2;
            int n4 = (dimension.height - n2) / 2;
            this._frame.setLocation(n3, n4);
        }
    }

    public void forceSameUsername() {
        this._username.setEnabled(false);
        this._username.setEditable(false);
    }

    public void forceSameUsername(String string) {
        this._username.setText(string);
        this._username.setEnabled(false);
        this._username.setEditable(false);
    }

    public void setUsername(String string) {
        this._username.setText(string);
    }

    public void showLogin() {
        this.init();
        this._frame.setVisible(true);
    }

    public boolean isVisible() {
        return this._frame != null && this._frame.isVisible();
    }

    public void showLogin(CallBack callBack) {
        this.init();
        this._frame.setVisible(true);
        this._callbacks.addListener((Object)callBack);
    }

    public void fireCancelled() {
        final List list = ListX.create();
        this._callbacks.safeDispatch((Visitor)new Visitor<CallBack>(){

            public void visit(CallBack callBack) {
                list.add(callBack);
                callBack.cancelled();
            }
        });
        for (CallBack callBack : list) {
            this._callbacks.removeListener((Object)callBack);
        }
    }

    public void fireLoggedIn(final String string) {
        final List list = ListX.create();
        this._callbacks.safeDispatch((Visitor)new Visitor<CallBack>(){

            public void visit(CallBack callBack) {
                list.add(callBack);
                callBack.loggedIn(string);
            }
        });
        for (CallBack callBack : list) {
            this._callbacks.removeListener((Object)callBack);
        }
    }

    public void withValidLogin(CallBack callBack) {
        String string = (String)((SessionIdProvider)DependencyInjector.getInstance(SessionIdProvider.class)).get();
        if (this._loginTool.isValidLogin(string)) {
            callBack.loggedIn(string);
        } else {
            this.showLogin(callBack);
        }
    }

    public static interface CallBack {
        public void loggedIn(String var1);

        public void cancelled();
    }
}

