/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.tools.http;

import com.ahsrcm.client.tools.http.ServerUnavailableException;
import com.ahsrcm.client.tools.login.NotAuthorizedException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.model3.io.IOHelper;
import net.model3.lang.ExceptionPropagator;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public class SimpleResponseHandler<T>
implements ResponseHandler<T> {
    public T handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int n = statusLine.getStatusCode();
        try {
            if (this.isSuccess(n)) {
                return this.processSuccess(httpResponse);
            }
            if (n >= 300 && n <= 399) {
                return this.processRedirect(httpResponse);
            }
            return this.processError(httpResponse);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.throwUnchecked((Throwable)exception);
        }
    }

    public boolean isSuccess(int n) {
        return n >= 200 && n <= 299;
    }

    public T processRedirect(HttpResponse httpResponse) throws Exception {
        return this.processError(httpResponse);
    }

    public T processError(HttpResponse httpResponse) throws Exception {
        StatusLine statusLine = httpResponse.getStatusLine();
        int n = statusLine.getStatusCode();
        String string = IOHelper.readFully((Reader)new InputStreamReader(httpResponse.getEntity().getContent()));
        if (n == 403 || n == 401) {
            throw new NotAuthorizedException(string);
        }
        if (n == 503 || n == 504 || n == 502) {
            throw new ServerUnavailableException(string);
        }
        throw new RuntimeException("invalid http response " + n + ":" + statusLine.getReasonPhrase() + "\n" + string);
    }

    public T processSuccess(HttpResponse httpResponse) throws Exception {
        return null;
    }
}

