/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.tools.http;

import com.ahsrcm.client.tools.http.SimpleResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import net.model3.io.IOHelper;
import net.model3.lang.ExceptionPropagator;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;

public class ObjectInputStreamResponseHandler<T>
extends SimpleResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int n = statusLine.getStatusCode();
        try {
            if (n >= 200 && n <= 299) {
                return this.processSuccess(httpResponse);
            }
            this.processError(httpResponse);
            throw new RuntimeException("invalid http response " + n + ":" + statusLine.getReasonPhrase());
        }
        catch (Exception exception) {
            throw ExceptionPropagator.throwUnchecked((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T processSuccess(HttpResponse httpResponse) throws Exception {
        T t;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(httpResponse.getEntity().getContent());
            t = this.processSuccess(objectInputStream);
        }
        catch (Throwable throwable) {
            IOHelper.close(objectInputStream);
            throw throwable;
        }
        IOHelper.close((InputStream)objectInputStream);
        return t;
    }

    public T processSuccess(ObjectInputStream objectInputStream) throws Exception {
        return (T)objectInputStream.readObject();
    }
}

