/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.tools.http;

import com.ahsrcm.client.tools.http.HttpMethod;
import com.ahsrcm.client.tools.http.HttpMethods;
import com.ahsrcm.client.tools.http.Parms;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import net.model3.lang.ExceptionPropagator;
import net.model3.lang.Pair;
import net.model3.net.UrlX;
import org.apache.http.client.methods.HttpRequestBase;

public class HttpRequest {
    UrlX _url;
    Parms _urlParms = new Parms();
    Parms _cookies = new Parms();
    Parms _postParms = new Parms();
    Parms _headers = new Parms();
    HttpMethod _method = HttpMethods.POST;

    public void setUrl(UrlX urlX) {
        this._url = urlX;
    }

    public void setUrl(String string) {
        this._url = new UrlX(string);
    }

    public HttpMethod getMethod() {
        return this._method;
    }

    public void setMethod(HttpMethod httpMethod) {
        this._method = httpMethod;
    }

    public void addUrlParm(String string, String string2) {
        this._urlParms.add(string, string2);
    }

    public void addPostParm(String string, String string2) {
        this._postParms.add(string, string2);
    }

    public void addHeader(String string, String string2) {
        this._headers.add(string, string2);
    }

    public void addCookie(String string, String string2) {
        this._cookies.add(string, string2);
    }

    public String encodeUrlParm(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception exception) {
            throw ExceptionPropagator.throwUnchecked((Throwable)exception);
        }
    }

    public Parms getCookies() {
        return this._cookies;
    }

    public Parms getUrlParms() {
        return this._urlParms;
    }

    public Parms getPostParms() {
        return this._postParms;
    }

    public Parms getHeaders() {
        return this._headers;
    }

    public UrlX getUrl() {
        return this._url;
    }

    public HttpRequestBase toHttpRequestBase() throws URISyntaxException {
        HttpRequestBase httpRequestBase = this.getMethod().newHttpUriRequest();
        if (this.getCookies().size() > 0) {
            httpRequestBase.setHeader("Cookie", this.getCookies().join("=", ";"));
        }
        for (Pair<String, String> pair : this.getHeaders()) {
            httpRequestBase.setHeader((String)pair.getLeft(), (String)pair.getRight());
        }
        if (this.getPostParms().size() > 0) {
            httpRequestBase.setParams(this.getPostParms().asHttpParams());
        }
        String string = this.getUrlParms().size() > 0 ? this.getUrl().toString() + "?" + this.getUrlParms().asQueryString() : this.getUrl().toString();
        httpRequestBase.setURI(new URI(string));
        return httpRequestBase;
    }
}

