/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.tools.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class GZipContentHandler {
    public static final DefaultHttpClient createHttpClient() {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
                if (!httpRequest.containsHeader("Accept-Encoding")) {
                    httpRequest.addHeader("Accept-Encoding", "gzip");
                }
            }
        });
        defaultHttpClient.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
                HttpEntity httpEntity = httpResponse.getEntity();
                Header header = httpEntity.getContentEncoding();
                if (header != null) {
                    HeaderElement[] headerElementArray = header.getElements();
                    for (int i = 0; i < headerElementArray.length; ++i) {
                        if (!headerElementArray[i].getName().equalsIgnoreCase("gzip")) continue;
                        httpResponse.setEntity((HttpEntity)new GzipDecompressingEntity(httpResponse.getEntity()));
                        return;
                    }
                }
            }
        });
        return defaultHttpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bob() throws Exception {
        DefaultHttpClient defaultHttpClient = GZipContentHandler.createHttpClient();
        try {
            HttpGet httpGet = new HttpGet("http://www.apache.org/");
            System.out.println("executing request " + httpGet.getURI());
            CloseableHttpResponse closeableHttpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
            System.out.println("----------------------------------------");
            System.out.println(closeableHttpResponse.getStatusLine());
            System.out.println(closeableHttpResponse.getLastHeader("Content-Encoding"));
            System.out.println(closeableHttpResponse.getLastHeader("Content-Length"));
            System.out.println("----------------------------------------");
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            if (httpEntity != null) {
                String string = EntityUtils.toString((HttpEntity)httpEntity);
                System.out.println(string);
                System.out.println("----------------------------------------");
                System.out.println("Uncompressed size: " + string.length());
            }
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
        }
    }

    static class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity httpEntity) {
            super(httpEntity);
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            InputStream inputStream = this.wrappedEntity.getContent();
            return new GZIPInputStream(inputStream);
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

