/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.client.tools.heartbeat;

import com.ahsrcm.client.tools.DeveloperProperties;
import com.ahsrcm.client.tools.ServerUrlProvider;
import com.ahsrcm.client.tools.SessionIdProvider;
import com.ahsrcm.client.tools.login.LoginTool;
import com.ahsrcm.client.tools.rpc.RPCStatusChecker;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Window;
import java.io.IOException;
import net.model3.chrono.DateTime;
import net.model3.guice.LifeCycleListeners;
import net.model3.lang.StringX;
import net.model3.lang.ThreadScheduler;
import net.model3.lang.TimeDuration;
import net.model3.lang.Visitor;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.net.UrlX;
import net.model3.swing.EventManager;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

@Singleton
public class Heartbeater
implements LifeCycleListeners.Config {
    public static final String Path = "/api/heartbeat";
    private static final Log logger = LogHelper.getLog(Heartbeater.class);
    boolean _started = false;
    boolean _alive = true;
    @Inject
    ThreadScheduler _threadScheduler;
    @Inject
    ServerUrlProvider _serverUrlProvider;
    @Inject
    SessionIdProvider _sessionIdProvider;
    @Inject
    RPCStatusChecker _rpcStatusChecker;
    @Inject
    DeveloperProperties _developerProperties;
    @Inject
    LoginTool _loginTool;
    TimeDuration _frequency = TimeDuration.fromMinutes((double)1.0);
    EventManager<Listener> _eventManager = EventManager.create();

    @Inject
    private Heartbeater() {
    }

    public void configComplete() throws Exception {
        this.start();
    }

    public void start() {
        if (!this._started) {
            this._started = true;
            this.submitNextHeartbeat();
        }
    }

    void submitNextHeartbeat() {
        this._threadScheduler.schedule("hearbeater", this._frequency, new Runnable(){

            @Override
            public void run() {
                try {
                    if (Heartbeater.this.hasActiveWindows()) {
                        Heartbeater.this.doHeartbeat();
                    } else {
                        logger.debug((Object)"No active windows!!");
                    }
                }
                finally {
                    Heartbeater.this.submitNextHeartbeat();
                }
            }
        });
    }

    private int convertStringToInt(String string, int n) {
        try {
            if (string == null) {
                return n;
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.warn((Object)"convertStringToInt -- value={} developer property cannot be parsed as an int", (Object)string);
            return n;
        }
    }

    private RequestConfig getHttpConfig() {
        String string = this._developerProperties.getProperty("http.connect.timeout");
        String string2 = this._developerProperties.getProperty("http.socket.timeout");
        int n = this.convertStringToInt(string, 0);
        int n2 = this.convertStringToInt(string2, 0);
        logger.debug(new Object[]{"getHttpConfig -- connectionTimeoutDevProp={}, socketTimeoutDevProp={}, connectTimeoutInt={}, socketTimeoutInt={}", string, string2, n, n2});
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(n).setSocketTimeout(n2).build();
        return requestConfig;
    }

    private void doHeartbeat() {
        try {
            if (StringX.isNotBlank((String)((String)this._sessionIdProvider.get()))) {
                CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
                HttpGet httpGet = new HttpGet(((UrlX)this._serverUrlProvider.get()).subPath(Path).asString() + "?sess=" + (String)this._sessionIdProvider.get());
                httpGet.setConfig(this.getHttpConfig());
                closeableHttpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)new ResponseHandler<Void>(){

                    public Void handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
                        StatusLine statusLine = httpResponse.getStatusLine();
                        int n = statusLine.getStatusCode();
                        try {
                            Heartbeater.this._rpcStatusChecker.processHttpStatus(n, null);
                            logger.debug((Object)"successful heartbeat | {}", (Object)n);
                            Heartbeater.this.setAlive(true);
                        }
                        catch (Exception exception) {
                            String string = Heartbeater.this.heartbeatLogWarningMessage();
                            logger.error((Object)string, (Object)exception);
                            Heartbeater.this.setAlive(false);
                        }
                        return null;
                    }
                });
            }
        }
        catch (Exception exception) {
            String string = this.heartbeatLogWarningMessage();
            logger.error((Object)("Heartbeat Error " + string), (Object)exception);
            this.setAlive(false);
        }
    }

    private String heartbeatLogWarningMessage() {
        String string = ((UrlX)this._serverUrlProvider.get()).toString();
        int n = this.getHttpConfig().getConnectTimeout();
        DateTime dateTime = new DateTime();
        String string2 = this._loginTool.getUserLoginName((String)this._sessionIdProvider.get());
        return "doHeartbeat failed while " + string2 + " trying to connect to " + string + " at " + dateTime.asFriendlyString() + " with connectTimeout=" + n + " milliseconds";
    }

    public boolean isAlive() {
        return this._alive;
    }

    public void setAlive(final boolean bl) {
        final boolean bl2 = this._alive;
        this._alive = bl;
        this._eventManager.safeDispatch((Visitor)new Visitor<Listener>(){

            public void visit(Listener listener) {
                listener.alivenessStateChange(bl, bl2);
            }
        });
    }

    public void setFrequency(TimeDuration timeDuration) {
        this._frequency = timeDuration;
    }

    private boolean hasActiveWindows() {
        Window[] windowArray;
        for (Window window : windowArray = Window.getWindows()) {
            if (!window.isVisible()) continue;
            return true;
        }
        return false;
    }

    public EventManager<Listener> getEventManager() {
        return this._eventManager;
    }

    public static interface Listener {
        public void alivenessStateChange(boolean var1, boolean var2);
    }
}

