/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.HashSet;
import java.util.List;
import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.Property;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.jdbc.SessionConfiguration;
import net.model3.lang.ExceptionPropagator;

public class BeanPropertyConverter
implements Converter {
    private PureJavaReflectionProvider _pureJavaReflectionProvider;
    private ReflectionProvider _reflectionProvider;
    private Mapper _mapper;
    SessionConfiguration _sessionConfiguration;

    public BeanPropertyConverter(SessionConfiguration sessionConfiguration, XStream xStream) {
        this._mapper = xStream.getMapper();
        this._reflectionProvider = xStream.getReflectionProvider();
    }

    public boolean canConvert(Class clazz) {
        return this._sessionConfiguration.getPersister(clazz) != null;
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        IBeanContext iBeanContext = BeanContainer.get().getContext(object);
        for (IPropertyContext iPropertyContext : iBeanContext.getProperties()) {
            IndexedProperty indexedProperty;
            if (iPropertyContext.isTransient()) continue;
            if (iPropertyContext instanceof IndexedProperty) {
                indexedProperty = (IndexedProperty)((Object)iPropertyContext);
                for (Object t : indexedProperty) {
                    hierarchicalStreamWriter.startNode(iPropertyContext.getContext().getName());
                    Class<?> clazz = iPropertyContext.getContext().getType();
                    Class clazz2 = this._mapper.defaultImplementationOf(clazz);
                    if (!clazz.equals(clazz2)) {
                        hierarchicalStreamWriter.addAttribute(this._mapper.aliasForAttribute("class"), this._mapper.serializedClass(clazz));
                    }
                    marshallingContext.convertAnother(t);
                    hierarchicalStreamWriter.endNode();
                }
                continue;
            }
            indexedProperty = iPropertyContext.getValue(object);
            if (indexedProperty == null) continue;
            hierarchicalStreamWriter.startNode(iPropertyContext.getContext().getName());
            marshallingContext.convertAnother((Object)indexedProperty);
            hierarchicalStreamWriter.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        try {
            HashSet<IndexedProperty> hashSet = new HashSet<IndexedProperty>();
            IBeanContext iBeanContext = BeanContainer.get().getContext(unmarshallingContext.getRequiredType());
            Object obj = iBeanContext.getType().newInstance();
            Object var6_7 = null;
            while (hierarchicalStreamReader.hasMoreChildren()) {
                hierarchicalStreamReader.moveDown();
                String string = hierarchicalStreamReader.getNodeName();
                String string2 = this._mapper.realMember(obj.getClass(), string);
                BaseProperty<?> baseProperty = iBeanContext.getProperty(string2).getProperty(obj);
                if (baseProperty instanceof Property) {
                    Property property = (Property)iBeanContext.getProperty(string2).getProperty(obj);
                    Object object = unmarshallingContext.convertAnother(obj, property.getContext().getType());
                    if (baseProperty instanceof IndexedProperty) {
                        IndexedProperty indexedProperty = (IndexedProperty)baseProperty;
                        if (!hashSet.contains(indexedProperty)) {
                            ((List)indexedProperty.get()).clear();
                            hashSet.add(indexedProperty);
                        }
                        ((IndexedProperty)property).add(object);
                    } else {
                        property.set(object);
                    }
                }
                hierarchicalStreamReader.moveUp();
            }
            return obj;
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap((Throwable)exception);
        }
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        String string = hierarchicalStreamReader.getAttribute(this._mapper.aliasForAttribute("resolves-to"));
        Object object = unmarshallingContext.currentObject();
        if (object != null) {
            return object;
        }
        if (string != null) {
            return this._reflectionProvider.newInstance(this._mapper.realClass(string));
        }
        return this._reflectionProvider.newInstance(unmarshallingContext.getRequiredType());
    }

    public PureJavaReflectionProvider getPureJavaReflectionProvider() {
        if (this._pureJavaReflectionProvider == null) {
            this._pureJavaReflectionProvider = new PureJavaReflectionProvider();
        }
        return this._pureJavaReflectionProvider;
    }
}

