/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.java.dev.properties.IndexedProperty;
import net.java.dev.properties.Property;
import net.java.dev.properties.jdbc.CurrentSession;
import net.java.dev.properties.jdbc.EntityPersister;
import net.java.dev.properties.jdbc.InternalSession;
import net.model3.collections.ListX;
import net.model3.util.StringJoiner;

public class Utils {
    private Utils() {
    }

    public static Number createZero(Class clazz) {
        if (Double.class.isAssignableFrom(clazz)) {
            return 0.0;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return Float.valueOf(0.0f);
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return 0;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return 0L;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return (byte)0;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (short)0;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return BigDecimal.valueOf(0L);
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return BigInteger.valueOf(0L);
        }
        throw new IllegalArgumentException("Unknown number subclass: " + clazz.getName());
    }

    public static Number normalizeType(Number number, Class clazz) {
        if (number.getClass() == clazz) {
            return number;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return number.doubleValue();
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return Float.valueOf(number.floatValue());
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return number.intValue();
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return number.longValue();
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return number.byteValue();
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return number.shortValue();
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return BigInteger.valueOf(number.longValue());
        }
        throw new IllegalArgumentException("Unknown number subclass: " + clazz.getName());
    }

    public static Class getNonPrimitive(Class clazz) {
        if (Double.TYPE == clazz) {
            return Double.class;
        }
        if (Float.TYPE == clazz) {
            return Float.class;
        }
        if (Integer.TYPE == clazz) {
            return Integer.class;
        }
        if (Long.TYPE == clazz) {
            return Long.class;
        }
        if (Byte.TYPE == clazz) {
            return Byte.class;
        }
        if (Short.TYPE == clazz) {
            return Short.class;
        }
        if (Character.TYPE == clazz) {
            return Character.class;
        }
        if (Boolean.TYPE == clazz) {
            return Boolean.class;
        }
        throw new IllegalArgumentException("The submitted class is not a primitive type class: " + clazz);
    }

    public static Class getPrimitive(Class clazz) {
        if (Double.class == clazz) {
            return Double.TYPE;
        }
        if (Float.class == clazz) {
            return Float.TYPE;
        }
        if (Integer.class == clazz) {
            return Integer.TYPE;
        }
        if (Long.class == clazz) {
            return Long.TYPE;
        }
        if (Byte.class == clazz) {
            return Byte.TYPE;
        }
        if (Short.class == clazz) {
            return Short.TYPE;
        }
        if (Character.class == clazz) {
            return Character.TYPE;
        }
        if (Boolean.class == clazz) {
            return Boolean.TYPE;
        }
        throw new IllegalArgumentException("The submitted class is a primitive type class: " + clazz);
    }

    public static String prettyName(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.startsWith("_")) {
            string = string.substring(1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Character.toUpperCase(string.charAt(0)));
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static Collection<?> getPropertyAsCollection(Property<?> property) {
        HashSet hashSet = new HashSet();
        if (property instanceof IndexedProperty) {
            IndexedProperty indexedProperty = (IndexedProperty)property;
            hashSet.addAll((Collection)indexedProperty.get());
        } else if (property.get() != null) {
            hashSet.add(property.get());
        }
        return hashSet;
    }

    public static <T> List<T> batchLoad(Class<T> clazz, List<Object> list) {
        InternalSession internalSession = (InternalSession)CurrentSession.get();
        EntityPersister<T> entityPersister = internalSession.getConfig().getPersister(clazz);
        if (entityPersister.getColumns().size() > 1) {
            throw new RuntimeException("this method does not support " + clazz + " since it is backed by a table with multiple primary keys");
        }
        List list2 = ListX.create();
        List list3 = ListX.create();
        List list4 = ListX.create();
        for (Object object : list) {
            T t = internalSession.fetchFromCache(clazz, true, object);
            if (t == null) {
                list2.add(object);
                list3.add("?");
                continue;
            }
            list4.add(t);
        }
        if (list2.size() > 0) {
            Object object;
            String string = entityPersister.getPrimaryKeyColumns().get(0).getName();
            object = (String)string + " in (" + new StringJoiner((Iterable)list3, ",") + ")";
            list4.addAll(internalSession.select(clazz, (String)object, list2));
        }
        return list4;
    }
}

