/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.util;

import net.java.dev.properties.BaseProperty;
import net.java.dev.properties.container.BeanEventManager;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.OrmPropertyContext;
import net.java.dev.properties.container.PropertyContextable;
import net.java.dev.properties.util.AbstractDelegatePropertyContext;
import net.java.dev.properties.util.Utils;

public class ProxyPathPropertyContext
extends AbstractDelegatePropertyContext {
    IPropertyContext[] _delegateChain;
    IPropertyContext _firstInChain;
    IPropertyContext _lastInChain;
    String _name;
    String _displayName;

    public ProxyPathPropertyContext(IPropertyContext ... iPropertyContextArray) {
        this._delegateChain = iPropertyContextArray;
        this._lastInChain = this._delegateChain[this._delegateChain.length - 1];
        this._firstInChain = this._delegateChain[0];
    }

    public ProxyPathPropertyContext(String string, IPropertyContext ... iPropertyContextArray) {
        this._name = string;
        this._delegateChain = iPropertyContextArray;
        this._lastInChain = this._delegateChain[this._delegateChain.length - 1];
        this._firstInChain = this._delegateChain[0];
    }

    public ProxyPathPropertyContext(String string, PropertyContextable ... propertyContextableArray) {
        this._name = string;
        this._delegateChain = new IPropertyContext[propertyContextableArray.length];
        for (int i = 0; i < propertyContextableArray.length; ++i) {
            this._delegateChain[i] = propertyContextableArray[i].getContext();
        }
        this._lastInChain = this._delegateChain[this._delegateChain.length - 1];
        this._firstInChain = this._delegateChain[0];
    }

    @Override
    public IPropertyContext getContextForDelegation() {
        return this._lastInChain;
    }

    @Override
    public IPropertyContext getContext() {
        return this;
    }

    @Override
    public IBeanContext getParentBeanContext() {
        return this._firstInChain.getParentBeanContext();
    }

    @Override
    public BaseProperty<?> getProperty(Object object) {
        Object object2 = object;
        for (int i = 0; i < this._delegateChain.length - 1; ++i) {
            if (object2 == null) {
                return null;
            }
            object2 = this._delegateChain[i].getValue(object2);
        }
        return this._lastInChain.getProperty(object2);
    }

    @Override
    public <T> T getValue(Object object) {
        for (IPropertyContext iPropertyContext : this._delegateChain) {
            if (object == null) break;
            object = iPropertyContext.getValue(object);
        }
        return (T)object;
    }

    @Override
    public String getName() {
        if (this._name == null) {
            return super.getName();
        }
        return this._name;
    }

    @Override
    public String getDisplayName() {
        if (this._name == null) {
            return super.getDisplayName();
        }
        if (this._displayName == null) {
            this._displayName = Utils.prettyName(this._name);
        }
        return this._displayName;
    }

    @Override
    public BeanEventManager getEventManager() {
        return null;
    }

    @Override
    public OrmPropertyContext getOrmContext() {
        return null;
    }
}

