/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.properties.util;

import java.util.Comparator;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContextable;

public class BeanComparator<T>
implements Comparator<T> {
    private final IPropertyContext[] _properties;
    private final boolean _ascending;

    public BeanComparator(boolean bl, IPropertyContext ... iPropertyContextArray) {
        this._properties = iPropertyContextArray;
        this._ascending = bl;
    }

    @Override
    public int compare(T t, T t2) {
        if (t == null || t2 == null) {
            if (t != null) {
                return 1;
            }
            if (t2 != null) {
                return -1;
            }
            return 0;
        }
        int n = 0;
        for (IPropertyContext iPropertyContext : this._properties) {
            Comparable comparable = (Comparable)iPropertyContext.getValue(t);
            Comparable comparable2 = (Comparable)iPropertyContext.getValue(t2);
            if (comparable == null) {
                n = -1;
                break;
            }
            if (comparable2 == null) {
                n = 1;
            }
            if ((n = comparable.compareTo(comparable2)) != 0) break;
        }
        if (n == 0) {
            return 0;
        }
        if (!this._ascending) {
            return -n;
        }
        return n;
    }

    public BeanComparator<T> reverse() {
        return new BeanComparator<T>(!this._ascending, this._properties);
    }

    public static <T> BeanComparator<T> create(PropertyContextable ... propertyContextableArray) {
        IPropertyContext[] iPropertyContextArray = new IPropertyContext[propertyContextableArray.length];
        for (int i = 0; i < iPropertyContextArray.length; ++i) {
            iPropertyContextArray[i] = propertyContextableArray[i].getContext();
        }
        return new BeanComparator<T>(true, iPropertyContextArray);
    }
}

